/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.UnknownClassOrMethodId;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class AMQImpl
implements AMQP {
    public static Method readMethodFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        short methodId = in.readShort();
        switch (classId) {
            case 10: {
                switch (methodId) {
                    case 10: {
                        Connection.Start result = new Connection.Start();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Connection.StartOk result = new Connection.StartOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Connection.Secure result = new Connection.Secure();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Connection.SecureOk result = new Connection.SecureOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Connection.Tune result = new Connection.Tune();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Connection.TuneOk result = new Connection.TuneOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Connection.Open result = new Connection.Open();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Connection.OpenOk result = new Connection.OpenOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Connection.Redirect result = new Connection.Redirect();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 60: {
                        Connection.Close result = new Connection.Close();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 61: {
                        Connection.CloseOk result = new Connection.CloseOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 20: {
                switch (methodId) {
                    case 10: {
                        Channel.Open result = new Channel.Open();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Channel.OpenOk result = new Channel.OpenOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Channel.Flow result = new Channel.Flow();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Channel.FlowOk result = new Channel.FlowOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Channel.Alert result = new Channel.Alert();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Channel.Close result = new Channel.Close();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Channel.CloseOk result = new Channel.CloseOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 30: {
                switch (methodId) {
                    case 10: {
                        Access.Request result = new Access.Request();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Access.RequestOk result = new Access.RequestOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 40: {
                switch (methodId) {
                    case 10: {
                        Exchange.Declare result = new Exchange.Declare();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Exchange.DeclareOk result = new Exchange.DeclareOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Exchange.Delete result = new Exchange.Delete();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Exchange.DeleteOk result = new Exchange.DeleteOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 50: {
                switch (methodId) {
                    case 10: {
                        Queue.Declare result = new Queue.Declare();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Queue.DeclareOk result = new Queue.DeclareOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Queue.Bind result = new Queue.Bind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Queue.BindOk result = new Queue.BindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Queue.Purge result = new Queue.Purge();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Queue.PurgeOk result = new Queue.PurgeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Queue.Delete result = new Queue.Delete();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Queue.DeleteOk result = new Queue.DeleteOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Queue.Unbind result = new Queue.Unbind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 51: {
                        Queue.UnbindOk result = new Queue.UnbindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 60: {
                switch (methodId) {
                    case 10: {
                        Basic.Qos result = new Basic.Qos();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Basic.QosOk result = new Basic.QosOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Basic.Consume result = new Basic.Consume();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Basic.ConsumeOk result = new Basic.ConsumeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Basic.Cancel result = new Basic.Cancel();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Basic.CancelOk result = new Basic.CancelOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Basic.Publish result = new Basic.Publish();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Basic.Return result = new Basic.Return();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 60: {
                        Basic.Deliver result = new Basic.Deliver();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 70: {
                        Basic.Get result = new Basic.Get();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 71: {
                        Basic.GetOk result = new Basic.GetOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 72: {
                        Basic.GetEmpty result = new Basic.GetEmpty();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 80: {
                        Basic.Ack result = new Basic.Ack();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 90: {
                        Basic.Reject result = new Basic.Reject();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 100: {
                        Basic.Recover result = new Basic.Recover();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 70: {
                switch (methodId) {
                    case 10: {
                        File.Qos result = new File.Qos();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        File.QosOk result = new File.QosOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        File.Consume result = new File.Consume();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        File.ConsumeOk result = new File.ConsumeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        File.Cancel result = new File.Cancel();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        File.CancelOk result = new File.CancelOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        File.Open result = new File.Open();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        File.OpenOk result = new File.OpenOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        File.Stage result = new File.Stage();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 60: {
                        File.Publish result = new File.Publish();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 70: {
                        File.Return result = new File.Return();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 80: {
                        File.Deliver result = new File.Deliver();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 90: {
                        File.Ack result = new File.Ack();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 100: {
                        File.Reject result = new File.Reject();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 80: {
                switch (methodId) {
                    case 10: {
                        Stream.Qos result = new Stream.Qos();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Stream.QosOk result = new Stream.QosOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Stream.Consume result = new Stream.Consume();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Stream.ConsumeOk result = new Stream.ConsumeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Stream.Cancel result = new Stream.Cancel();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Stream.CancelOk result = new Stream.CancelOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Stream.Publish result = new Stream.Publish();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Stream.Return result = new Stream.Return();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 60: {
                        Stream.Deliver result = new Stream.Deliver();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 90: {
                switch (methodId) {
                    case 10: {
                        Tx.Select result = new Tx.Select();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Tx.SelectOk result = new Tx.SelectOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Tx.Commit result = new Tx.Commit();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Tx.CommitOk result = new Tx.CommitOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Tx.Rollback result = new Tx.Rollback();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Tx.RollbackOk result = new Tx.RollbackOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 100: {
                switch (methodId) {
                    case 10: {
                        Dtx.Select result = new Dtx.Select();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Dtx.SelectOk result = new Dtx.SelectOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Dtx.Start result = new Dtx.Start();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Dtx.StartOk result = new Dtx.StartOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 110: {
                switch (methodId) {
                    case 10: {
                        Tunnel.Request result = new Tunnel.Request();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 120: {
                switch (methodId) {
                    case 10: {
                        Test.Integer result = new Test.Integer();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Test.IntegerOk result = new Test.IntegerOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Test.String result = new Test.String();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Test.StringOk result = new Test.StringOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Test.Table result = new Test.Table();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Test.TableOk result = new Test.TableOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Test.Content result = new Test.Content();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Test.ContentOk result = new Test.ContentOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
        }
        throw new UnknownClassOrMethodId(classId, methodId);
    }

    public static AMQContentHeader readContentHeaderFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        switch (classId) {
            case 60: {
                return new AMQP.BasicProperties();
            }
            case 70: {
                return new AMQP.FileProperties();
            }
            case 80: {
                return new AMQP.StreamProperties();
            }
            case 110: {
                return new AMQP.TunnelProperties();
            }
        }
        throw new UnknownClassOrMethodId(classId, -1);
    }

    public static class DefaultMethodVisitor
    implements MethodVisitor {
        public Object visit(Connection.Start x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.StartOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Secure x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.SecureOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Tune x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.TuneOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Redirect x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Flow x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.FlowOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Alert x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.Request x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.RequestOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Bind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.BindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Purge x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.PurgeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Unbind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.UnbindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Qos x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.QosOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Consume x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.ConsumeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Cancel x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.CancelOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Publish x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Return x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Deliver x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Get x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetEmpty x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Ack x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Reject x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Recover x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Qos x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.QosOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Consume x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.ConsumeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Cancel x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.CancelOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Stage x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Publish x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Return x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Deliver x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Ack x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(File.Reject x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Qos x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.QosOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Consume x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.ConsumeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Cancel x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.CancelOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Publish x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Return x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Stream.Deliver x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Select x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.SelectOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Commit x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.CommitOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Rollback x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.RollbackOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Dtx.Select x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Dtx.SelectOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Dtx.Start x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Dtx.StartOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tunnel.Request x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.Integer x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.IntegerOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.String x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.StringOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.Table x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.TableOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.Content x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Test.ContentOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }
    }

    public static interface MethodVisitor {
        public Object visit(Connection.Start var1) throws IOException;

        public Object visit(Connection.StartOk var1) throws IOException;

        public Object visit(Connection.Secure var1) throws IOException;

        public Object visit(Connection.SecureOk var1) throws IOException;

        public Object visit(Connection.Tune var1) throws IOException;

        public Object visit(Connection.TuneOk var1) throws IOException;

        public Object visit(Connection.Open var1) throws IOException;

        public Object visit(Connection.OpenOk var1) throws IOException;

        public Object visit(Connection.Redirect var1) throws IOException;

        public Object visit(Connection.Close var1) throws IOException;

        public Object visit(Connection.CloseOk var1) throws IOException;

        public Object visit(Channel.Open var1) throws IOException;

        public Object visit(Channel.OpenOk var1) throws IOException;

        public Object visit(Channel.Flow var1) throws IOException;

        public Object visit(Channel.FlowOk var1) throws IOException;

        public Object visit(Channel.Alert var1) throws IOException;

        public Object visit(Channel.Close var1) throws IOException;

        public Object visit(Channel.CloseOk var1) throws IOException;

        public Object visit(Access.Request var1) throws IOException;

        public Object visit(Access.RequestOk var1) throws IOException;

        public Object visit(Exchange.Declare var1) throws IOException;

        public Object visit(Exchange.DeclareOk var1) throws IOException;

        public Object visit(Exchange.Delete var1) throws IOException;

        public Object visit(Exchange.DeleteOk var1) throws IOException;

        public Object visit(Queue.Declare var1) throws IOException;

        public Object visit(Queue.DeclareOk var1) throws IOException;

        public Object visit(Queue.Bind var1) throws IOException;

        public Object visit(Queue.BindOk var1) throws IOException;

        public Object visit(Queue.Purge var1) throws IOException;

        public Object visit(Queue.PurgeOk var1) throws IOException;

        public Object visit(Queue.Delete var1) throws IOException;

        public Object visit(Queue.DeleteOk var1) throws IOException;

        public Object visit(Queue.Unbind var1) throws IOException;

        public Object visit(Queue.UnbindOk var1) throws IOException;

        public Object visit(Basic.Qos var1) throws IOException;

        public Object visit(Basic.QosOk var1) throws IOException;

        public Object visit(Basic.Consume var1) throws IOException;

        public Object visit(Basic.ConsumeOk var1) throws IOException;

        public Object visit(Basic.Cancel var1) throws IOException;

        public Object visit(Basic.CancelOk var1) throws IOException;

        public Object visit(Basic.Publish var1) throws IOException;

        public Object visit(Basic.Return var1) throws IOException;

        public Object visit(Basic.Deliver var1) throws IOException;

        public Object visit(Basic.Get var1) throws IOException;

        public Object visit(Basic.GetOk var1) throws IOException;

        public Object visit(Basic.GetEmpty var1) throws IOException;

        public Object visit(Basic.Ack var1) throws IOException;

        public Object visit(Basic.Reject var1) throws IOException;

        public Object visit(Basic.Recover var1) throws IOException;

        public Object visit(File.Qos var1) throws IOException;

        public Object visit(File.QosOk var1) throws IOException;

        public Object visit(File.Consume var1) throws IOException;

        public Object visit(File.ConsumeOk var1) throws IOException;

        public Object visit(File.Cancel var1) throws IOException;

        public Object visit(File.CancelOk var1) throws IOException;

        public Object visit(File.Open var1) throws IOException;

        public Object visit(File.OpenOk var1) throws IOException;

        public Object visit(File.Stage var1) throws IOException;

        public Object visit(File.Publish var1) throws IOException;

        public Object visit(File.Return var1) throws IOException;

        public Object visit(File.Deliver var1) throws IOException;

        public Object visit(File.Ack var1) throws IOException;

        public Object visit(File.Reject var1) throws IOException;

        public Object visit(Stream.Qos var1) throws IOException;

        public Object visit(Stream.QosOk var1) throws IOException;

        public Object visit(Stream.Consume var1) throws IOException;

        public Object visit(Stream.ConsumeOk var1) throws IOException;

        public Object visit(Stream.Cancel var1) throws IOException;

        public Object visit(Stream.CancelOk var1) throws IOException;

        public Object visit(Stream.Publish var1) throws IOException;

        public Object visit(Stream.Return var1) throws IOException;

        public Object visit(Stream.Deliver var1) throws IOException;

        public Object visit(Tx.Select var1) throws IOException;

        public Object visit(Tx.SelectOk var1) throws IOException;

        public Object visit(Tx.Commit var1) throws IOException;

        public Object visit(Tx.CommitOk var1) throws IOException;

        public Object visit(Tx.Rollback var1) throws IOException;

        public Object visit(Tx.RollbackOk var1) throws IOException;

        public Object visit(Dtx.Select var1) throws IOException;

        public Object visit(Dtx.SelectOk var1) throws IOException;

        public Object visit(Dtx.Start var1) throws IOException;

        public Object visit(Dtx.StartOk var1) throws IOException;

        public Object visit(Tunnel.Request var1) throws IOException;

        public Object visit(Test.Integer var1) throws IOException;

        public Object visit(Test.IntegerOk var1) throws IOException;

        public Object visit(Test.String var1) throws IOException;

        public Object visit(Test.StringOk var1) throws IOException;

        public Object visit(Test.Table var1) throws IOException;

        public Object visit(Test.TableOk var1) throws IOException;

        public Object visit(Test.Content var1) throws IOException;

        public Object visit(Test.ContentOk var1) throws IOException;
    }

    public static class Test {
        public static final int INDEX = 120;

        public static class ContentOk
        extends Method
        implements AMQP.Test.ContentOk {
            public static final int INDEX = 41;
            public int contentChecksum;

            public int getContentChecksum() {
                return this.contentChecksum;
            }

            public ContentOk(int contentChecksum) {
                this.contentChecksum = contentChecksum;
            }

            public ContentOk() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 41;
            }

            public java.lang.String protocolMethodName() {
                return "test.content-ok";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("content-checksum=");
                acc.append(this.contentChecksum);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.contentChecksum = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.contentChecksum);
            }
        }

        public static class Content
        extends Method
        implements AMQP.Test.Content {
            public static final int INDEX = 40;

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 40;
            }

            public java.lang.String protocolMethodName() {
                return "test.content";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class TableOk
        extends Method
        implements AMQP.Test.TableOk {
            public static final int INDEX = 31;
            public long integerResult;
            public LongString stringResult;

            public long getIntegerResult() {
                return this.integerResult;
            }

            public LongString getStringResult() {
                return this.stringResult;
            }

            public TableOk(long integerResult, LongString stringResult) {
                this.integerResult = integerResult;
                this.stringResult = stringResult;
            }

            public TableOk() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 31;
            }

            public java.lang.String protocolMethodName() {
                return "test.table-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("integer-result=");
                acc.append(this.integerResult);
                acc.append(",");
                acc.append("string-result=");
                acc.append(this.stringResult);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.integerResult = reader.readLonglong();
                this.stringResult = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.integerResult);
                writer.writeLongstr(this.stringResult);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Table
        extends Method
        implements AMQP.Test.Table {
            public static final int INDEX = 30;
            public Map<java.lang.String, Object> table;
            public int integerOp;
            public int stringOp;

            @Override
            public Map<java.lang.String, Object> getTable() {
                return this.table;
            }

            @Override
            public int getIntegerOp() {
                return this.integerOp;
            }

            @Override
            public int getStringOp() {
                return this.stringOp;
            }

            public Table(Map<java.lang.String, Object> table, int integerOp, int stringOp) {
                this.table = table;
                this.integerOp = integerOp;
                this.stringOp = stringOp;
            }

            public Table() {
            }

            @Override
            public int protocolClassId() {
                return 120;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public java.lang.String protocolMethodName() {
                return "test.table";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("table=");
                acc.append(this.table);
                acc.append(",");
                acc.append("integer-op=");
                acc.append(this.integerOp);
                acc.append(",");
                acc.append("string-op=");
                acc.append(this.stringOp);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.table = reader.readTable();
                this.integerOp = reader.readOctet();
                this.stringOp = reader.readOctet();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeTable(this.table);
                writer.writeOctet(this.integerOp);
                writer.writeOctet(this.stringOp);
            }
        }

        public static class StringOk
        extends Method
        implements AMQP.Test.StringOk {
            public static final int INDEX = 21;
            public LongString result;

            public LongString getResult() {
                return this.result;
            }

            public StringOk(LongString result) {
                this.result = result;
            }

            public StringOk() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 21;
            }

            public java.lang.String protocolMethodName() {
                return "test.string-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("result=");
                acc.append(this.result);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.result = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.result);
            }
        }

        public static class String
        extends Method
        implements AMQP.Test.String {
            public static final int INDEX = 20;
            public java.lang.String string1;
            public LongString string2;
            public int operation;

            public java.lang.String getString1() {
                return this.string1;
            }

            public LongString getString2() {
                return this.string2;
            }

            public int getOperation() {
                return this.operation;
            }

            public String(java.lang.String string1, LongString string2, int operation) {
                this.string1 = string1;
                this.string2 = string2;
                this.operation = operation;
            }

            public String() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 20;
            }

            public java.lang.String protocolMethodName() {
                return "test.string";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("string-1=");
                acc.append(this.string1);
                acc.append(",");
                acc.append("string-2=");
                acc.append(this.string2);
                acc.append(",");
                acc.append("operation=");
                acc.append(this.operation);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.string1 = reader.readShortstr();
                this.string2 = reader.readLongstr();
                this.operation = reader.readOctet();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.string1);
                writer.writeLongstr(this.string2);
                writer.writeOctet(this.operation);
            }
        }

        public static class IntegerOk
        extends Method
        implements AMQP.Test.IntegerOk {
            public static final int INDEX = 11;
            public long result;

            public long getResult() {
                return this.result;
            }

            public IntegerOk(long result) {
                this.result = result;
            }

            public IntegerOk() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 11;
            }

            public java.lang.String protocolMethodName() {
                return "test.integer-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("result=");
                acc.append(this.result);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.result = reader.readLonglong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.result);
            }
        }

        public static class Integer
        extends Method
        implements AMQP.Test.Integer {
            public static final int INDEX = 10;
            public int integer1;
            public int integer2;
            public int integer3;
            public long integer4;
            public int operation;

            public int getInteger1() {
                return this.integer1;
            }

            public int getInteger2() {
                return this.integer2;
            }

            public int getInteger3() {
                return this.integer3;
            }

            public long getInteger4() {
                return this.integer4;
            }

            public int getOperation() {
                return this.operation;
            }

            public Integer(int integer1, int integer2, int integer3, long integer4, int operation) {
                this.integer1 = integer1;
                this.integer2 = integer2;
                this.integer3 = integer3;
                this.integer4 = integer4;
                this.operation = operation;
            }

            public Integer() {
            }

            public int protocolClassId() {
                return 120;
            }

            public int protocolMethodId() {
                return 10;
            }

            public java.lang.String protocolMethodName() {
                return "test.integer";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("integer-1=");
                acc.append(this.integer1);
                acc.append(",");
                acc.append("integer-2=");
                acc.append(this.integer2);
                acc.append(",");
                acc.append("integer-3=");
                acc.append(this.integer3);
                acc.append(",");
                acc.append("integer-4=");
                acc.append(this.integer4);
                acc.append(",");
                acc.append("operation=");
                acc.append(this.operation);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.integer1 = reader.readOctet();
                this.integer2 = reader.readShort();
                this.integer3 = reader.readLong();
                this.integer4 = reader.readLonglong();
                this.operation = reader.readOctet();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeOctet(this.integer1);
                writer.writeShort(this.integer2);
                writer.writeLong(this.integer3);
                writer.writeLonglong(this.integer4);
                writer.writeOctet(this.operation);
            }
        }
    }

    public static class Tunnel {
        public static final int INDEX = 110;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Request
        extends Method
        implements AMQP.Tunnel.Request {
            public static final int INDEX = 10;
            public Map<String, Object> metaData;

            @Override
            public Map<String, Object> getMetaData() {
                return this.metaData;
            }

            public Request(Map<String, Object> metaData) {
                this.metaData = metaData;
            }

            public Request() {
            }

            @Override
            public int protocolClassId() {
                return 110;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "tunnel.request";
            }

            @Override
            public boolean hasContent() {
                return true;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("meta-data=");
                acc.append(this.metaData);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.metaData = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeTable(this.metaData);
            }
        }
    }

    public static class Dtx {
        public static final int INDEX = 100;

        public static class StartOk
        extends Method
        implements AMQP.Dtx.StartOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 100;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "dtx.start-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Start
        extends Method
        implements AMQP.Dtx.Start {
            public static final int INDEX = 20;
            public String dtxIdentifier;

            public String getDtxIdentifier() {
                return this.dtxIdentifier;
            }

            public Start(String dtxIdentifier) {
                this.dtxIdentifier = dtxIdentifier;
            }

            public Start() {
            }

            public int protocolClassId() {
                return 100;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "dtx.start";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("dtx-identifier=");
                acc.append(this.dtxIdentifier);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.dtxIdentifier = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.dtxIdentifier);
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Dtx.SelectOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 100;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "dtx.select-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Dtx.Select {
            public static final int INDEX = 10;

            public int protocolClassId() {
                return 100;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "dtx.select";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }
    }

    public static class Tx {
        public static final int INDEX = 90;

        public static class RollbackOk
        extends Method
        implements AMQP.Tx.RollbackOk {
            public static final int INDEX = 31;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "tx.rollback-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Rollback
        extends Method
        implements AMQP.Tx.Rollback {
            public static final int INDEX = 30;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "tx.rollback";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class CommitOk
        extends Method
        implements AMQP.Tx.CommitOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "tx.commit-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Commit
        extends Method
        implements AMQP.Tx.Commit {
            public static final int INDEX = 20;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "tx.commit";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Tx.SelectOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "tx.select-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Tx.Select {
            public static final int INDEX = 10;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "tx.select";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }
    }

    public static class Stream {
        public static final int INDEX = 80;

        public static class Deliver
        extends Method
        implements AMQP.Stream.Deliver {
            public static final int INDEX = 60;
            public String consumerTag;
            public long deliveryTag;
            public String exchange;
            public String queue;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getQueue() {
                return this.queue;
            }

            public Deliver(String consumerTag, long deliveryTag, String exchange, String queue) {
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.exchange = exchange;
                this.queue = queue;
            }

            public Deliver() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "stream.deliver";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.deliveryTag = reader.readLonglong();
                this.exchange = reader.readShortstr();
                this.queue = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.queue);
            }
        }

        public static class Return
        extends Method
        implements AMQP.Stream.Return {
            public static final int INDEX = 50;
            public int replyCode;
            public String replyText;
            public String exchange;
            public String routingKey;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Return() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "stream.return";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.Stream.Publish {
            public static final int INDEX = 40;
            public int ticket;
            public String exchange;
            public String routingKey;
            public boolean mandatory;
            public boolean immediate;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getImmediate() {
                return this.immediate;
            }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
            }

            public Publish() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "stream.publish";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("mandatory=");
                acc.append(this.mandatory);
                acc.append(",");
                acc.append("immediate=");
                acc.append(this.immediate);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.mandatory = reader.readBit();
                this.immediate = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.Stream.CancelOk {
            public static final int INDEX = 31;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public CancelOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public CancelOk() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "stream.cancel-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.Stream.Cancel {
            public static final int INDEX = 30;
            public String consumerTag;
            public boolean nowait;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Cancel(String consumerTag, boolean nowait) {
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }

            public Cancel() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "stream.cancel";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.Stream.ConsumeOk {
            public static final int INDEX = 21;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public ConsumeOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public ConsumeOk() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "stream.consume-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Consume
        extends Method
        implements AMQP.Stream.Consume {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String consumerTag;
            public boolean noLocal;
            public boolean exclusive;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNoLocal() {
                return this.noLocal;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean exclusive, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.exclusive = exclusive;
                this.nowait = nowait;
            }

            public Consume() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "stream.consume";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("no-local=");
                acc.append(this.noLocal);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.consumerTag = reader.readShortstr();
                this.noLocal = reader.readBit();
                this.exclusive = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.Stream.QosOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "stream.qos-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Qos
        extends Method
        implements AMQP.Stream.Qos {
            public static final int INDEX = 10;
            public int prefetchSize;
            public int prefetchCount;
            public int consumeRate;
            public boolean global;

            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            public int getConsumeRate() {
                return this.consumeRate;
            }

            public boolean getGlobal() {
                return this.global;
            }

            public Qos(int prefetchSize, int prefetchCount, int consumeRate, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.consumeRate = consumeRate;
                this.global = global;
            }

            public Qos() {
            }

            public int protocolClassId() {
                return 80;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "stream.qos";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("prefetch-size=");
                acc.append(this.prefetchSize);
                acc.append(",");
                acc.append("prefetch-count=");
                acc.append(this.prefetchCount);
                acc.append(",");
                acc.append("consume-rate=");
                acc.append(this.consumeRate);
                acc.append(",");
                acc.append("global=");
                acc.append(this.global);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.prefetchSize = reader.readLong();
                this.prefetchCount = reader.readShort();
                this.consumeRate = reader.readLong();
                this.global = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeLong(this.consumeRate);
                writer.writeBit(this.global);
            }
        }
    }

    public static class File {
        public static final int INDEX = 70;

        public static class Reject
        extends Method
        implements AMQP.File.Reject {
            public static final int INDEX = 100;
            public long deliveryTag;
            public boolean requeue;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRequeue() {
                return this.requeue;
            }

            public Reject(long deliveryTag, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.requeue = requeue;
            }

            public Reject() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 100;
            }

            public String protocolMethodName() {
                return "file.reject";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.requeue);
            }
        }

        public static class Ack
        extends Method
        implements AMQP.File.Ack {
            public static final int INDEX = 90;
            public long deliveryTag;
            public boolean multiple;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            public Ack(long deliveryTag, boolean multiple) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
            }

            public Ack() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 90;
            }

            public String protocolMethodName() {
                return "file.ack";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("multiple=");
                acc.append(this.multiple);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.multiple = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
            }
        }

        public static class Deliver
        extends Method
        implements AMQP.File.Deliver {
            public static final int INDEX = 80;
            public String consumerTag;
            public long deliveryTag;
            public boolean redelivered;
            public String exchange;
            public String routingKey;
            public String identifier;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public String getIdentifier() {
                return this.identifier;
            }

            public Deliver(String consumerTag, long deliveryTag, boolean redelivered, String exchange, String routingKey, String identifier) {
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.identifier = identifier;
            }

            public Deliver() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 80;
            }

            public String protocolMethodName() {
                return "file.deliver";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("redelivered=");
                acc.append(this.redelivered);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("identifier=");
                acc.append(this.identifier);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.deliveryTag = reader.readLonglong();
                this.redelivered = reader.readBit();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.identifier = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeShortstr(this.identifier);
            }
        }

        public static class Return
        extends Method
        implements AMQP.File.Return {
            public static final int INDEX = 70;
            public int replyCode;
            public String replyText;
            public String exchange;
            public String routingKey;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Return() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 70;
            }

            public String protocolMethodName() {
                return "file.return";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.File.Publish {
            public static final int INDEX = 60;
            public int ticket;
            public String exchange;
            public String routingKey;
            public boolean mandatory;
            public boolean immediate;
            public String identifier;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getImmediate() {
                return this.immediate;
            }

            public String getIdentifier() {
                return this.identifier;
            }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate, String identifier) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
                this.identifier = identifier;
            }

            public Publish() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "file.publish";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("mandatory=");
                acc.append(this.mandatory);
                acc.append(",");
                acc.append("immediate=");
                acc.append(this.immediate);
                acc.append(",");
                acc.append("identifier=");
                acc.append(this.identifier);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.mandatory = reader.readBit();
                this.immediate = reader.readBit();
                this.identifier = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
                writer.writeShortstr(this.identifier);
            }
        }

        public static class Stage
        extends Method
        implements AMQP.File.Stage {
            public static final int INDEX = 50;

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "file.stage";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.File.OpenOk {
            public static final int INDEX = 41;
            public long stagedSize;

            public long getStagedSize() {
                return this.stagedSize;
            }

            public OpenOk(long stagedSize) {
                this.stagedSize = stagedSize;
            }

            public OpenOk() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "file.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("staged-size=");
                acc.append(this.stagedSize);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.stagedSize = reader.readLonglong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.stagedSize);
            }
        }

        public static class Open
        extends Method
        implements AMQP.File.Open {
            public static final int INDEX = 40;
            public String identifier;
            public long contentSize;

            public String getIdentifier() {
                return this.identifier;
            }

            public long getContentSize() {
                return this.contentSize;
            }

            public Open(String identifier, long contentSize) {
                this.identifier = identifier;
                this.contentSize = contentSize;
            }

            public Open() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "file.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("identifier=");
                acc.append(this.identifier);
                acc.append(",");
                acc.append("content-size=");
                acc.append(this.contentSize);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.identifier = reader.readShortstr();
                this.contentSize = reader.readLonglong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.identifier);
                writer.writeLonglong(this.contentSize);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.File.CancelOk {
            public static final int INDEX = 31;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public CancelOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public CancelOk() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "file.cancel-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.File.Cancel {
            public static final int INDEX = 30;
            public String consumerTag;
            public boolean nowait;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Cancel(String consumerTag, boolean nowait) {
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }

            public Cancel() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "file.cancel";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.File.ConsumeOk {
            public static final int INDEX = 21;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public ConsumeOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public ConsumeOk() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "file.consume-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Consume
        extends Method
        implements AMQP.File.Consume {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String consumerTag;
            public boolean noLocal;
            public boolean noAck;
            public boolean exclusive;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNoLocal() {
                return this.noLocal;
            }

            public boolean getNoAck() {
                return this.noAck;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.noAck = noAck;
                this.exclusive = exclusive;
                this.nowait = nowait;
            }

            public Consume() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "file.consume";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("no-local=");
                acc.append(this.noLocal);
                acc.append(",");
                acc.append("no-ack=");
                acc.append(this.noAck);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.consumerTag = reader.readShortstr();
                this.noLocal = reader.readBit();
                this.noAck = reader.readBit();
                this.exclusive = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.noAck);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.File.QosOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "file.qos-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Qos
        extends Method
        implements AMQP.File.Qos {
            public static final int INDEX = 10;
            public int prefetchSize;
            public int prefetchCount;
            public boolean global;

            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            public boolean getGlobal() {
                return this.global;
            }

            public Qos(int prefetchSize, int prefetchCount, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.global = global;
            }

            public Qos() {
            }

            public int protocolClassId() {
                return 70;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "file.qos";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("prefetch-size=");
                acc.append(this.prefetchSize);
                acc.append(",");
                acc.append("prefetch-count=");
                acc.append(this.prefetchCount);
                acc.append(",");
                acc.append("global=");
                acc.append(this.global);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.prefetchSize = reader.readLong();
                this.prefetchCount = reader.readShort();
                this.global = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeBit(this.global);
            }
        }
    }

    public static class Basic {
        public static final int INDEX = 60;

        public static class Recover
        extends Method
        implements AMQP.Basic.Recover {
            public static final int INDEX = 100;
            public boolean requeue;

            public boolean getRequeue() {
                return this.requeue;
            }

            public Recover(boolean requeue) {
                this.requeue = requeue;
            }

            public Recover() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 100;
            }

            public String protocolMethodName() {
                return "basic.recover";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.requeue);
            }
        }

        public static class Reject
        extends Method
        implements AMQP.Basic.Reject {
            public static final int INDEX = 90;
            public long deliveryTag;
            public boolean requeue;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRequeue() {
                return this.requeue;
            }

            public Reject(long deliveryTag, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.requeue = requeue;
            }

            public Reject() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 90;
            }

            public String protocolMethodName() {
                return "basic.reject";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.requeue);
            }
        }

        public static class Ack
        extends Method
        implements AMQP.Basic.Ack {
            public static final int INDEX = 80;
            public long deliveryTag;
            public boolean multiple;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            public Ack(long deliveryTag, boolean multiple) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
            }

            public Ack() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 80;
            }

            public String protocolMethodName() {
                return "basic.ack";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("multiple=");
                acc.append(this.multiple);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.multiple = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
            }
        }

        public static class GetEmpty
        extends Method
        implements AMQP.Basic.GetEmpty {
            public static final int INDEX = 72;
            public String clusterId;

            public String getClusterId() {
                return this.clusterId;
            }

            public GetEmpty(String clusterId) {
                this.clusterId = clusterId;
            }

            public GetEmpty() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 72;
            }

            public String protocolMethodName() {
                return "basic.get-empty";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("cluster-id=");
                acc.append(this.clusterId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.clusterId = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.clusterId);
            }
        }

        public static class GetOk
        extends Method
        implements AMQP.Basic.GetOk {
            public static final int INDEX = 71;
            public long deliveryTag;
            public boolean redelivered;
            public String exchange;
            public String routingKey;
            public int messageCount;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public GetOk(long deliveryTag, boolean redelivered, String exchange, String routingKey, int messageCount) {
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.messageCount = messageCount;
            }

            public GetOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 71;
            }

            public String protocolMethodName() {
                return "basic.get-ok";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("redelivered=");
                acc.append(this.redelivered);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.redelivered = reader.readBit();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeLong(this.messageCount);
            }
        }

        public static class Get
        extends Method
        implements AMQP.Basic.Get {
            public static final int INDEX = 70;
            public int ticket;
            public String queue;
            public boolean noAck;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNoAck() {
                return this.noAck;
            }

            public Get(int ticket, String queue, boolean noAck) {
                this.ticket = ticket;
                this.queue = queue;
                this.noAck = noAck;
            }

            public Get() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 70;
            }

            public String protocolMethodName() {
                return "basic.get";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("no-ack=");
                acc.append(this.noAck);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.noAck = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.noAck);
            }
        }

        public static class Deliver
        extends Method
        implements AMQP.Basic.Deliver {
            public static final int INDEX = 60;
            public String consumerTag;
            public long deliveryTag;
            public boolean redelivered;
            public String exchange;
            public String routingKey;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Deliver(String consumerTag, long deliveryTag, boolean redelivered, String exchange, String routingKey) {
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Deliver() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "basic.deliver";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("redelivered=");
                acc.append(this.redelivered);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.deliveryTag = reader.readLonglong();
                this.redelivered = reader.readBit();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Return
        extends Method
        implements AMQP.Basic.Return {
            public static final int INDEX = 50;
            public int replyCode;
            public String replyText;
            public String exchange;
            public String routingKey;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Return() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "basic.return";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.Basic.Publish {
            public static final int INDEX = 40;
            public int ticket;
            public String exchange;
            public String routingKey;
            public boolean mandatory;
            public boolean immediate;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getImmediate() {
                return this.immediate;
            }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
            }

            public Publish() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "basic.publish";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("mandatory=");
                acc.append(this.mandatory);
                acc.append(",");
                acc.append("immediate=");
                acc.append(this.immediate);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.mandatory = reader.readBit();
                this.immediate = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.Basic.CancelOk {
            public static final int INDEX = 31;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public CancelOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public CancelOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "basic.cancel-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.Basic.Cancel {
            public static final int INDEX = 30;
            public String consumerTag;
            public boolean nowait;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Cancel(String consumerTag, boolean nowait) {
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }

            public Cancel() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "basic.cancel";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.Basic.ConsumeOk {
            public static final int INDEX = 21;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public ConsumeOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public ConsumeOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "basic.consume-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Consume
        extends Method
        implements AMQP.Basic.Consume {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String consumerTag;
            public boolean noLocal;
            public boolean noAck;
            public boolean exclusive;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNoLocal() {
                return this.noLocal;
            }

            public boolean getNoAck() {
                return this.noAck;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.noAck = noAck;
                this.exclusive = exclusive;
                this.nowait = nowait;
            }

            public Consume() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "basic.consume";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("no-local=");
                acc.append(this.noLocal);
                acc.append(",");
                acc.append("no-ack=");
                acc.append(this.noAck);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.consumerTag = reader.readShortstr();
                this.noLocal = reader.readBit();
                this.noAck = reader.readBit();
                this.exclusive = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.noAck);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.Basic.QosOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "basic.qos-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Qos
        extends Method
        implements AMQP.Basic.Qos {
            public static final int INDEX = 10;
            public int prefetchSize;
            public int prefetchCount;
            public boolean global;

            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            public boolean getGlobal() {
                return this.global;
            }

            public Qos(int prefetchSize, int prefetchCount, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.global = global;
            }

            public Qos() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "basic.qos";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("prefetch-size=");
                acc.append(this.prefetchSize);
                acc.append(",");
                acc.append("prefetch-count=");
                acc.append(this.prefetchCount);
                acc.append(",");
                acc.append("global=");
                acc.append(this.global);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.prefetchSize = reader.readLong();
                this.prefetchCount = reader.readShort();
                this.global = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeBit(this.global);
            }
        }
    }

    public static class Queue {
        public static final int INDEX = 50;

        public static class UnbindOk
        extends Method
        implements AMQP.Queue.UnbindOk {
            public static final int INDEX = 51;

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "queue.unbind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Unbind
        extends Method
        implements AMQP.Queue.Unbind {
            public static final int INDEX = 50;
            public int ticket;
            public String queue;
            public String exchange;
            public String routingKey;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Unbind(int ticket, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.arguments = arguments;
            }

            public Unbind() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "queue.unbind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Queue.DeleteOk {
            public static final int INDEX = 41;
            public int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public DeleteOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public DeleteOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "queue.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Queue.Delete {
            public static final int INDEX = 40;
            public int ticket;
            public String queue;
            public boolean ifUnused;
            public boolean ifEmpty;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getIfEmpty() {
                return this.ifEmpty;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.ifUnused = ifUnused;
                this.ifEmpty = ifEmpty;
                this.nowait = nowait;
            }

            public Delete() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "queue.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("if-unused=");
                acc.append(this.ifUnused);
                acc.append(",");
                acc.append("if-empty=");
                acc.append(this.ifEmpty);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.ifUnused = reader.readBit();
                this.ifEmpty = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.ifEmpty);
                writer.writeBit(this.nowait);
            }
        }

        public static class PurgeOk
        extends Method
        implements AMQP.Queue.PurgeOk {
            public static final int INDEX = 31;
            public int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public PurgeOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public PurgeOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "queue.purge-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Purge
        extends Method
        implements AMQP.Queue.Purge {
            public static final int INDEX = 30;
            public int ticket;
            public String queue;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Purge(int ticket, String queue, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.nowait = nowait;
            }

            public Purge() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "queue.purge";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.nowait);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Queue.BindOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "queue.bind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind
        extends Method
        implements AMQP.Queue.Bind {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String exchange;
            public String routingKey;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Bind(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Bind() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "queue.bind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Queue.DeclareOk {
            public static final int INDEX = 11;
            public String queue;
            public int messageCount;
            public int consumerCount;

            public String getQueue() {
                return this.queue;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public int getConsumerCount() {
                return this.consumerCount;
            }

            public DeclareOk(String queue, int messageCount, int consumerCount) {
                this.queue = queue;
                this.messageCount = messageCount;
                this.consumerCount = consumerCount;
            }

            public DeclareOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "queue.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(",");
                acc.append("consumer-count=");
                acc.append(this.consumerCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.queue = reader.readShortstr();
                this.messageCount = reader.readLong();
                this.consumerCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.queue);
                writer.writeLong(this.messageCount);
                writer.writeLong(this.consumerCount);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Queue.Declare {
            public static final int INDEX = 10;
            public int ticket;
            public String queue;
            public boolean passive;
            public boolean durable;
            public boolean exclusive;
            public boolean autoDelete;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.passive = passive;
                this.durable = durable;
                this.exclusive = exclusive;
                this.autoDelete = autoDelete;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Declare() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "queue.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("durable=");
                acc.append(this.durable);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("auto-delete=");
                acc.append(this.autoDelete);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.passive = reader.readBit();
                this.durable = reader.readBit();
                this.exclusive = reader.readBit();
                this.autoDelete = reader.readBit();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Exchange {
        public static final int INDEX = 40;

        public static class DeleteOk
        extends Method
        implements AMQP.Exchange.DeleteOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "exchange.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Exchange.Delete {
            public static final int INDEX = 20;
            public int ticket;
            public String exchange;
            public boolean ifUnused;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String exchange, boolean ifUnused, boolean nowait) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.ifUnused = ifUnused;
                this.nowait = nowait;
            }

            public Delete() {
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "exchange.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("if-unused=");
                acc.append(this.ifUnused);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.ifUnused = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.nowait);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Exchange.DeclareOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "exchange.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Exchange.Declare {
            public static final int INDEX = 10;
            public int ticket;
            public String exchange;
            public String type;
            public boolean passive;
            public boolean durable;
            public boolean autoDelete;
            public boolean internal;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getInternal() {
                return this.internal;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.type = type;
                this.passive = passive;
                this.durable = durable;
                this.autoDelete = autoDelete;
                this.internal = internal;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Declare() {
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("type=");
                acc.append(this.type);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("durable=");
                acc.append(this.durable);
                acc.append(",");
                acc.append("auto-delete=");
                acc.append(this.autoDelete);
                acc.append(",");
                acc.append("internal=");
                acc.append(this.internal);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.type = reader.readShortstr();
                this.passive = reader.readBit();
                this.durable = reader.readBit();
                this.autoDelete = reader.readBit();
                this.internal = reader.readBit();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.type);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.internal);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Access {
        public static final int INDEX = 30;

        public static class RequestOk
        extends Method
        implements AMQP.Access.RequestOk {
            public static final int INDEX = 11;
            public int ticket;

            public int getTicket() {
                return this.ticket;
            }

            public RequestOk(int ticket) {
                this.ticket = ticket;
            }

            public RequestOk() {
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "access.request-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
            }
        }

        public static class Request
        extends Method
        implements AMQP.Access.Request {
            public static final int INDEX = 10;
            public String realm;
            public boolean exclusive;
            public boolean passive;
            public boolean active;
            public boolean write;
            public boolean read;

            public String getRealm() {
                return this.realm;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getPassive() {
                return this.passive;
            }

            public boolean getActive() {
                return this.active;
            }

            public boolean getWrite() {
                return this.write;
            }

            public boolean getRead() {
                return this.read;
            }

            public Request(String realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
                this.realm = realm;
                this.exclusive = exclusive;
                this.passive = passive;
                this.active = active;
                this.write = write;
                this.read = read;
            }

            public Request() {
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "access.request";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("realm=");
                acc.append(this.realm);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("active=");
                acc.append(this.active);
                acc.append(",");
                acc.append("write=");
                acc.append(this.write);
                acc.append(",");
                acc.append("read=");
                acc.append(this.read);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.realm = reader.readShortstr();
                this.exclusive = reader.readBit();
                this.passive = reader.readBit();
                this.active = reader.readBit();
                this.write = reader.readBit();
                this.read = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.realm);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.passive);
                writer.writeBit(this.active);
                writer.writeBit(this.write);
                writer.writeBit(this.read);
            }
        }
    }

    public static class Channel {
        public static final int INDEX = 20;

        public static class CloseOk
        extends Method
        implements AMQP.Channel.CloseOk {
            public static final int INDEX = 41;

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "channel.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Channel.Close {
            public static final int INDEX = 40;
            public int replyCode;
            public String replyText;
            public int classId;
            public int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "channel.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("class-id=");
                acc.append(this.classId);
                acc.append(",");
                acc.append("method-id=");
                acc.append(this.methodId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.classId = reader.readShort();
                this.methodId = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Alert
        extends Method
        implements AMQP.Channel.Alert {
            public static final int INDEX = 30;
            public int replyCode;
            public String replyText;
            public Map<String, Object> details;

            @Override
            public int getReplyCode() {
                return this.replyCode;
            }

            @Override
            public String getReplyText() {
                return this.replyText;
            }

            @Override
            public Map<String, Object> getDetails() {
                return this.details;
            }

            public Alert(int replyCode, String replyText, Map<String, Object> details) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.details = details;
            }

            public Alert() {
            }

            @Override
            public int protocolClassId() {
                return 20;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "channel.alert";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("details=");
                acc.append(this.details);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.details = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeTable(this.details);
            }
        }

        public static class FlowOk
        extends Method
        implements AMQP.Channel.FlowOk {
            public static final int INDEX = 21;
            public boolean active;

            public boolean getActive() {
                return this.active;
            }

            public FlowOk(boolean active) {
                this.active = active;
            }

            public FlowOk() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "channel.flow-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("active=");
                acc.append(this.active);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.active = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class Flow
        extends Method
        implements AMQP.Channel.Flow {
            public static final int INDEX = 20;
            public boolean active;

            public boolean getActive() {
                return this.active;
            }

            public Flow(boolean active) {
                this.active = active;
            }

            public Flow() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "channel.flow";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("active=");
                acc.append(this.active);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.active = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Channel.OpenOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "channel.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Open
        extends Method
        implements AMQP.Channel.Open {
            public static final int INDEX = 10;
            public String outOfBand;

            public String getOutOfBand() {
                return this.outOfBand;
            }

            public Open(String outOfBand) {
                this.outOfBand = outOfBand;
            }

            public Open() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "channel.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("out-of-band=");
                acc.append(this.outOfBand);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.outOfBand = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.outOfBand);
            }
        }
    }

    public static class Connection {
        public static final int INDEX = 10;

        public static class CloseOk
        extends Method
        implements AMQP.Connection.CloseOk {
            public static final int INDEX = 61;

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 61;
            }

            public String protocolMethodName() {
                return "connection.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Connection.Close {
            public static final int INDEX = 60;
            public int replyCode;
            public String replyText;
            public int classId;
            public int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "connection.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("class-id=");
                acc.append(this.classId);
                acc.append(",");
                acc.append("method-id=");
                acc.append(this.methodId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.classId = reader.readShort();
                this.methodId = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class Redirect
        extends Method
        implements AMQP.Connection.Redirect {
            public static final int INDEX = 50;
            public String host;
            public String knownHosts;

            public String getHost() {
                return this.host;
            }

            public String getKnownHosts() {
                return this.knownHosts;
            }

            public Redirect(String host, String knownHosts) {
                this.host = host;
                this.knownHosts = knownHosts;
            }

            public Redirect() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "connection.redirect";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("host=");
                acc.append(this.host);
                acc.append(",");
                acc.append("known-hosts=");
                acc.append(this.knownHosts);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.host = reader.readShortstr();
                this.knownHosts = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.host);
                writer.writeShortstr(this.knownHosts);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Connection.OpenOk {
            public static final int INDEX = 41;
            public String knownHosts;

            public String getKnownHosts() {
                return this.knownHosts;
            }

            public OpenOk(String knownHosts) {
                this.knownHosts = knownHosts;
            }

            public OpenOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "connection.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("known-hosts=");
                acc.append(this.knownHosts);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.knownHosts = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.knownHosts);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Connection.Open {
            public static final int INDEX = 40;
            public String virtualHost;
            public String capabilities;
            public boolean insist;

            public String getVirtualHost() {
                return this.virtualHost;
            }

            public String getCapabilities() {
                return this.capabilities;
            }

            public boolean getInsist() {
                return this.insist;
            }

            public Open(String virtualHost, String capabilities, boolean insist) {
                this.virtualHost = virtualHost;
                this.capabilities = capabilities;
                this.insist = insist;
            }

            public Open() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "connection.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("virtual-host=");
                acc.append(this.virtualHost);
                acc.append(",");
                acc.append("capabilities=");
                acc.append(this.capabilities);
                acc.append(",");
                acc.append("insist=");
                acc.append(this.insist);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.virtualHost = reader.readShortstr();
                this.capabilities = reader.readShortstr();
                this.insist = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.virtualHost);
                writer.writeShortstr(this.capabilities);
                writer.writeBit(this.insist);
            }
        }

        public static class TuneOk
        extends Method
        implements AMQP.Connection.TuneOk {
            public static final int INDEX = 31;
            public int channelMax;
            public int frameMax;
            public int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public TuneOk(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public TuneOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "connection.tune-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("channel-max=");
                acc.append(this.channelMax);
                acc.append(",");
                acc.append("frame-max=");
                acc.append(this.frameMax);
                acc.append(",");
                acc.append("heartbeat=");
                acc.append(this.heartbeat);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.channelMax = reader.readShort();
                this.frameMax = reader.readLong();
                this.heartbeat = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class Tune
        extends Method
        implements AMQP.Connection.Tune {
            public static final int INDEX = 30;
            public int channelMax;
            public int frameMax;
            public int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public Tune(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public Tune() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "connection.tune";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("channel-max=");
                acc.append(this.channelMax);
                acc.append(",");
                acc.append("frame-max=");
                acc.append(this.frameMax);
                acc.append(",");
                acc.append("heartbeat=");
                acc.append(this.heartbeat);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.channelMax = reader.readShort();
                this.frameMax = reader.readLong();
                this.heartbeat = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class SecureOk
        extends Method
        implements AMQP.Connection.SecureOk {
            public static final int INDEX = 21;
            public LongString response;

            public LongString getResponse() {
                return this.response;
            }

            public SecureOk(LongString response) {
                this.response = response;
            }

            public SecureOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "connection.secure-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("response=");
                acc.append(this.response);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.response = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.response);
            }
        }

        public static class Secure
        extends Method
        implements AMQP.Connection.Secure {
            public static final int INDEX = 20;
            public LongString challenge;

            public LongString getChallenge() {
                return this.challenge;
            }

            public Secure(LongString challenge) {
                this.challenge = challenge;
            }

            public Secure() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "connection.secure";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("challenge=");
                acc.append(this.challenge);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.challenge = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.challenge);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StartOk
        extends Method
        implements AMQP.Connection.StartOk {
            public static final int INDEX = 11;
            public Map<String, Object> clientProperties;
            public String mechanism;
            public LongString response;
            public String locale;

            @Override
            public Map<String, Object> getClientProperties() {
                return this.clientProperties;
            }

            @Override
            public String getMechanism() {
                return this.mechanism;
            }

            @Override
            public LongString getResponse() {
                return this.response;
            }

            @Override
            public String getLocale() {
                return this.locale;
            }

            public StartOk(Map<String, Object> clientProperties, String mechanism, LongString response, String locale) {
                this.clientProperties = clientProperties;
                this.mechanism = mechanism;
                this.response = response;
                this.locale = locale;
            }

            public StartOk() {
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start-ok";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("client-properties=");
                acc.append(this.clientProperties);
                acc.append(",");
                acc.append("mechanism=");
                acc.append(this.mechanism);
                acc.append(",");
                acc.append("response=");
                acc.append(this.response);
                acc.append(",");
                acc.append("locale=");
                acc.append(this.locale);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.clientProperties = reader.readTable();
                this.mechanism = reader.readShortstr();
                this.response = reader.readLongstr();
                this.locale = reader.readShortstr();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeTable(this.clientProperties);
                writer.writeShortstr(this.mechanism);
                writer.writeLongstr(this.response);
                writer.writeShortstr(this.locale);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Start
        extends Method
        implements AMQP.Connection.Start {
            public static final int INDEX = 10;
            public int versionMajor;
            public int versionMinor;
            public Map<String, Object> serverProperties;
            public LongString mechanisms;
            public LongString locales;

            @Override
            public int getVersionMajor() {
                return this.versionMajor;
            }

            @Override
            public int getVersionMinor() {
                return this.versionMinor;
            }

            @Override
            public Map<String, Object> getServerProperties() {
                return this.serverProperties;
            }

            @Override
            public LongString getMechanisms() {
                return this.mechanisms;
            }

            @Override
            public LongString getLocales() {
                return this.locales;
            }

            public Start(int versionMajor, int versionMinor, Map<String, Object> serverProperties, LongString mechanisms, LongString locales) {
                this.versionMajor = versionMajor;
                this.versionMinor = versionMinor;
                this.serverProperties = serverProperties;
                this.mechanisms = mechanisms;
                this.locales = locales;
            }

            public Start() {
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("version-major=");
                acc.append(this.versionMajor);
                acc.append(",");
                acc.append("version-minor=");
                acc.append(this.versionMinor);
                acc.append(",");
                acc.append("server properties=");
                acc.append(this.serverProperties);
                acc.append(",");
                acc.append("mechanisms=");
                acc.append(this.mechanisms);
                acc.append(",");
                acc.append("locales=");
                acc.append(this.locales);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.versionMajor = reader.readOctet();
                this.versionMinor = reader.readOctet();
                this.serverProperties = reader.readTable();
                this.mechanisms = reader.readLongstr();
                this.locales = reader.readLongstr();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeOctet(this.versionMajor);
                writer.writeOctet(this.versionMinor);
                writer.writeTable(this.serverProperties);
                writer.writeLongstr(this.mechanisms);
                writer.writeLongstr(this.locales);
            }
        }
    }
}

