/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionParameters;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.RedirectException;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.rabbitmq.client.impl.ExceptionHandler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.ShutdownNotifierComponent;
import com.rabbitmq.client.impl.Version;
import com.rabbitmq.utility.BlockingCell;
import com.rabbitmq.utility.Utility;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnection
extends ShutdownNotifierComponent
implements Connection {
    public static final int HANDSHAKE_TIMEOUT = 10000;
    public static final int CONNECTION_CLOSING_TIMEOUT = 10000;
    private static final Version clientVersion = new Version(8, 0);
    public final ConnectionParameters _params;
    public final AMQChannel _channel0 = new AMQChannel(this, 0){

        public boolean processAsync(Command c) throws IOException {
            return this._connection.processControlCommand(c);
        }
    };
    public ChannelManager _channelManager = new ChannelManager(0);
    public final FrameHandler _frameHandler;
    public volatile boolean _running = false;
    public int _frameMax;
    public final ExceptionHandler _exceptionHandler;
    public BlockingCell<Object> _appContinuation = new BlockingCell();
    public boolean _brokerInitiatedShutdown = false;
    public volatile long _lastActivityTime = Long.MAX_VALUE;
    public int _missedHeartbeats;
    public int _heartbeat;
    public Address[] _knownHosts;
    private static final long NANOS_IN_SECOND = 1000000000L;

    public final void disconnectChannel(int channelNumber) {
        this._channelManager.disconnectChannel(channelNumber);
    }

    public void ensureIsOpen() throws AlreadyClosedException {
        if (!this.isOpen()) {
            throw new AlreadyClosedException("Attempt to use closed connection", this);
        }
    }

    @Override
    public String getHost() {
        return this._frameHandler.getHost();
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    @Override
    public ConnectionParameters getParameters() {
        return this._params;
    }

    @Override
    public Address[] getKnownHosts() {
        return this._knownHosts;
    }

    public AMQConnection(ConnectionParameters params, FrameHandler frameHandler) {
        this(params, frameHandler, new DefaultExceptionHandler());
    }

    public AMQConnection(ConnectionParameters params, FrameHandler frameHandler, ExceptionHandler exceptionHandler) {
        this.checkPreconditions();
        this._params = params;
        this._frameHandler = frameHandler;
        this._running = true;
        this._frameMax = 0;
        this._missedHeartbeats = 0;
        this._heartbeat = 0;
        this._exceptionHandler = exceptionHandler;
        this._brokerInitiatedShutdown = false;
    }

    public void start(boolean insist) throws IOException, RedirectException {
        AMQChannel.SimpleBlockingRpcContinuation connStartBlocker = new AMQChannel.SimpleBlockingRpcContinuation();
        this._channel0.enqueueRpc(connStartBlocker);
        this._frameHandler.setTimeout(10000);
        this._frameHandler.sendHeader();
        MainLoop ml = new MainLoop();
        ml.setName("AMQP Connection " + this.getHost() + ":" + this.getPort());
        ml.start();
        try {
            AMQP.Connection.Start connStart = (AMQP.Connection.Start)((Object)((AMQCommand)connStartBlocker.getReply()).getMethod());
            Version serverVersion = new Version(connStart.getVersionMajor(), connStart.getVersionMinor());
            if (!Version.checkVersion(clientVersion, serverVersion)) {
                this._frameHandler.close();
                throw new IOException("protocol version mismatch: expected " + clientVersion + ", got " + serverVersion);
            }
        }
        catch (ShutdownSignalException sse) {
            throw AMQChannel.wrap(sse);
        }
        LongString saslResponse = LongStringHelper.asLongString("\u0000" + this._params.getUserName() + "\u0000" + this._params.getPassword());
        AMQImpl.Connection.StartOk startOk = new AMQImpl.Connection.StartOk(this.buildClientPropertiesTable(), "PLAIN", saslResponse, "en_US");
        AMQP.Connection.Tune connTune = (AMQP.Connection.Tune)((Object)this._channel0.exnWrappingRpc(startOk).getMethod());
        int channelMax = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedChannelMax(), connTune.getChannelMax());
        this._channelManager = new ChannelManager(channelMax);
        int frameMax = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedFrameMax(), connTune.getFrameMax());
        this.setFrameMax(frameMax);
        int heartbeat = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedHeartbeat(), connTune.getHeartbeat());
        this.setHeartbeat(heartbeat);
        this._channel0.transmit(new AMQImpl.Connection.TuneOk(channelMax, frameMax, heartbeat));
        Method res = this._channel0.exnWrappingRpc(new AMQImpl.Connection.Open(this._params.getVirtualHost(), "", insist)).getMethod();
        if (res instanceof AMQP.Connection.Redirect) {
            AMQP.Connection.Redirect redirect = (AMQP.Connection.Redirect)((Object)res);
            throw new RedirectException(Address.parseAddress(redirect.getHost()), Address.parseAddresses(redirect.getKnownHosts()));
        }
        AMQP.Connection.OpenOk openOk = (AMQP.Connection.OpenOk)((Object)res);
        this._knownHosts = Address.parseAddresses(openOk.getKnownHosts());
    }

    public void checkPreconditions() {
        AMQCommand.checkEmptyContentBodyFrameSize();
    }

    @Override
    public int getChannelMax() {
        return this._channelManager.getChannelMax();
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    public void setFrameMax(int value) {
        this._frameMax = value;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        try {
            this._heartbeat = heartbeat;
            this._frameHandler.setTimeout(heartbeat * 1000 / 4);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this, channelNumber);
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this);
    }

    public Frame readFrame() throws IOException {
        return this._frameHandler.readFrame();
    }

    public void writeFrame(Frame f) throws IOException {
        this._frameHandler.writeFrame(f);
        this._lastActivityTime = System.nanoTime();
    }

    public Map<String, Object> buildClientPropertiesTable() {
        return Frame.buildTable(new Object[]{"product", LongStringHelper.asLongString("RabbitMQ"), "version", LongStringHelper.asLongString("1.7.2"), "platform", LongStringHelper.asLongString("Java"), "copyright", LongStringHelper.asLongString("Copyright (C) 2007-2008 LShift Ltd., Cohesive Financial Technologies LLC., and Rabbit Technologies Ltd."), "information", LongStringHelper.asLongString("Licensed under the MPL.  See http://www.rabbitmq.com/")});
    }

    private static int negotiatedMaxValue(int clientValue, int serverValue) {
        return clientValue == 0 || serverValue == 0 ? Math.max(clientValue, serverValue) : Math.min(clientValue, serverValue);
    }

    public void maybeSendHeartbeat() throws IOException {
        if (this._heartbeat == 0) {
            return;
        }
        long now = System.nanoTime();
        if (now > this._lastActivityTime + (long)this._heartbeat * 1000000000L) {
            this._lastActivityTime = now;
            this.writeFrame(new Frame(8, 0));
        }
    }

    public void handleSocketTimeout() throws MissedHeartbeatException {
        if (this._heartbeat == 0) {
            return;
        }
        ++this._missedHeartbeats;
        if (this._missedHeartbeats > 8) {
            throw new MissedHeartbeatException("Heartbeat missing with heartbeat == " + this._heartbeat + " seconds");
        }
    }

    public boolean processControlCommand(Command c) throws IOException {
        Method method = c.getMethod();
        if (method instanceof AMQP.Connection.Close) {
            this.handleConnectionClose(c);
            return true;
        }
        if (this.isOpen()) {
            return false;
        }
        if (method instanceof AMQP.Connection.CloseOk) {
            this._running = false;
            return this._channel0._activeRpc == null;
        }
        return true;
    }

    public void handleConnectionClose(Command closeCommand) {
        ShutdownSignalException sse = this.shutdown(closeCommand, false, null, false);
        try {
            this._channel0.quiescingTransmit(new AMQImpl.Connection.CloseOk());
        }
        catch (IOException ioe) {
            Utility.emptyStatement();
        }
        this._heartbeat = 0;
        this._brokerInitiatedShutdown = true;
        SocketCloseWait scw = new SocketCloseWait(sse);
        scw.setName("AMQP Connection Closing Monitor " + this.getHost() + ":" + this.getPort());
        scw.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShutdownSignalException shutdown(Object reason, boolean initiatedByApplication, Throwable cause, boolean notifyRpc) {
        ShutdownSignalException sse = new ShutdownSignalException(true, initiatedByApplication, reason, this);
        sse.initCause(cause);
        AMQConnection aMQConnection = this;
        synchronized (aMQConnection) {
            if (initiatedByApplication) {
                this.ensureIsOpen();
            }
            if (this.isOpen()) {
                this._shutdownCause = sse;
            }
        }
        this._channel0.processShutdownSignal(sse, !initiatedByApplication, notifyRpc);
        this._channelManager.handleSignal(sse);
        return sse;
    }

    @Override
    public void close() throws IOException {
        this.close(-1);
    }

    @Override
    public void close(int timeout) throws IOException {
        this.close(200, "OK", timeout);
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, -1);
    }

    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.close(closeCode, closeMessage, true, null, timeout, false);
    }

    @Override
    public void abort() {
        this.abort(-1);
    }

    @Override
    public void abort(int closeCode, String closeMessage) {
        this.abort(closeCode, closeMessage, -1);
    }

    @Override
    public void abort(int timeout) {
        this.abort(200, "OK", timeout);
    }

    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        try {
            this.close(closeCode, closeMessage, true, null, timeout, true);
        }
        catch (IOException e) {
            Utility.emptyStatement();
        }
    }

    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause) throws IOException {
        this.close(closeCode, closeMessage, initiatedByApplication, cause, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause, int timeout, boolean abort) throws IOException {
        boolean sync = !(Thread.currentThread() instanceof MainLoop);
        try {
            AMQImpl.Connection.Close reason = new AMQImpl.Connection.Close(closeCode, closeMessage, 0, 0);
            this.shutdown(reason, initiatedByApplication, cause, true);
            if (sync) {
                AMQChannel.SimpleBlockingRpcContinuation k = new AMQChannel.SimpleBlockingRpcContinuation();
                this._channel0.quiescingRpc(reason, k);
                k.getReply(timeout);
            } else {
                this._channel0.quiescingTransmit(reason);
            }
        }
        catch (TimeoutException tte) {
            if (!abort) {
                throw new ShutdownSignalException(true, true, tte, this);
            }
        }
        catch (ShutdownSignalException sse) {
            if (!abort) {
                throw sse;
            }
        }
        catch (IOException ioe) {
            if (!abort) {
                throw ioe;
            }
        }
        finally {
            if (sync) {
                this._frameHandler.close();
            }
        }
    }

    public String toString() {
        return "amqp://" + this._params.getUserName() + "@" + this.getHost() + ":" + this.getPort() + this._params.getVirtualHost();
    }

    private class SocketCloseWait
    extends Thread {
        private ShutdownSignalException cause;

        public SocketCloseWait(ShutdownSignalException sse) {
            this.cause = sse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AMQConnection.this._appContinuation.uninterruptibleGet(10000);
            }
            catch (TimeoutException ise) {
                AMQConnection.this._frameHandler.close();
            }
            finally {
                AMQConnection.this._running = false;
                AMQConnection.this._channel0.notifyOutstandingRpc(this.cause);
            }
        }
    }

    private class MainLoop
    extends Thread {
        private MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (AMQConnection.this._running) {
                    Frame frame = AMQConnection.this.readFrame();
                    AMQConnection.this.maybeSendHeartbeat();
                    if (frame != null) {
                        AMQConnection.this._missedHeartbeats = 0;
                        if (frame.type == 8) continue;
                        if (frame.channel == 0) {
                            AMQConnection.this._channel0.handleFrame(frame);
                            continue;
                        }
                        if (!AMQConnection.this.isOpen()) continue;
                        AMQConnection.this._channelManager.getChannel(frame.channel).handleFrame(frame);
                        continue;
                    }
                    AMQConnection.this.handleSocketTimeout();
                }
            }
            catch (EOFException ex) {
                if (!AMQConnection.this._brokerInitiatedShutdown) {
                    AMQConnection.this.shutdown(ex, false, ex, true);
                }
            }
            catch (Throwable ex) {
                AMQConnection.this._exceptionHandler.handleUnexpectedConnectionDriverException(AMQConnection.this, ex);
                AMQConnection.this.shutdown(ex, false, ex, true);
            }
            finally {
                AMQConnection.this._frameHandler.close();
                AMQConnection.this._appContinuation.set(null);
                AMQConnection.this.notifyListeners();
            }
        }
    }
}

