/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionParameters;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.RedirectException;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.rabbitmq.client.impl.ExceptionHandler;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.Version;
import com.rabbitmq.utility.Utility;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnection
implements Connection {
    public static final int HANDSHAKE_TIMEOUT = 10000;
    public static final int CONNECTION_CLOSING_TIMEOUT = 10000;
    private static final Version clientVersion = new Version(8, 0);
    public final ConnectionParameters _params;
    public final AMQChannel _channel0 = new AMQChannel(this, 0){

        public boolean processAsync(Command c) throws IOException {
            return this._connection.processControlCommand(c);
        }
    };
    public final ChannelManager _channelManager = new ChannelManager();
    public final FrameHandler _frameHandler;
    public volatile boolean _running = false;
    public volatile ShutdownSignalException _shutdownCause = null;
    public int _frameMax;
    public final ExceptionHandler _exceptionHandler;
    public volatile long _lastActivityTime = Long.MAX_VALUE;
    public int _missedHeartbeats;
    public int _heartbeat;
    public Address[] _knownHosts;
    private static final long NANOS_IN_SECOND = 1000000000L;

    public final void disconnectChannel(int channelNumber) {
        this._channelManager.disconnectChannel(channelNumber);
    }

    public boolean isOpen() {
        return this._shutdownCause == null;
    }

    public void ensureIsOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Attempt to use closed connection");
        }
    }

    @Override
    public String getHost() {
        return this._frameHandler.getHost();
    }

    @Override
    public int getPort() {
        return this._frameHandler.getPort();
    }

    @Override
    public ConnectionParameters getParameters() {
        return this._params;
    }

    @Override
    public Address[] getKnownHosts() {
        return this._knownHosts;
    }

    public AMQConnection(ConnectionParameters params, boolean insist, FrameHandler frameHandler) throws RedirectException, IOException {
        this(params, insist, frameHandler, new DefaultExceptionHandler());
    }

    public AMQConnection(ConnectionParameters params, boolean insist, FrameHandler frameHandler, ExceptionHandler exceptionHandler) throws RedirectException, IOException {
        this.checkPreconditions();
        this._params = params;
        this._frameHandler = frameHandler;
        this._running = true;
        this._frameMax = 0;
        this._missedHeartbeats = 0;
        this._heartbeat = 0;
        this._exceptionHandler = exceptionHandler;
        new MainLoop();
        this._knownHosts = this.open(this._params, insist);
    }

    public void checkPreconditions() {
        AMQCommand.checkEmptyContentBodyFrameSize();
    }

    @Override
    public int getChannelMax() {
        return this._channelManager.getChannelMax();
    }

    public void setChannelMax(int value) {
        this._channelManager.setChannelMax(value);
    }

    @Override
    public int getFrameMax() {
        return this._frameMax;
    }

    public void setFrameMax(int value) {
        this._frameMax = value;
    }

    @Override
    public int getHeartbeat() {
        return this._heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        try {
            this._heartbeat = heartbeat;
            this._frameHandler.setTimeout(heartbeat * 1000 / 4);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this._exceptionHandler;
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this, channelNumber);
    }

    @Override
    public Channel createChannel() throws IOException {
        this.ensureIsOpen();
        return this._channelManager.createChannel(this);
    }

    public Frame readFrame() throws IOException {
        return this._frameHandler.readFrame();
    }

    public void writeFrame(Frame f) throws IOException {
        this._frameHandler.writeFrame(f);
        this._lastActivityTime = System.nanoTime();
    }

    public Map<String, Object> buildClientPropertiesTable() {
        return Frame.buildTable(new Object[]{"product", LongStringHelper.asLongString("RabbitMQ"), "version", LongStringHelper.asLongString("1.3.0"), "platform", LongStringHelper.asLongString("Java"), "copyright", LongStringHelper.asLongString("Copyright (C) 2007-2008 LShift Ltd., Cohesive Financial Technologies LLC., and Rabbit Technologies Ltd."), "information", LongStringHelper.asLongString("Licensed under the MPL.  See http://www.rabbitmq.com/")});
    }

    public Address[] open(ConnectionParameters params, boolean insist) throws RedirectException, IOException {
        try {
            AMQChannel.SimpleBlockingRpcContinuation connStartBlocker = new AMQChannel.SimpleBlockingRpcContinuation();
            this._channel0.enqueueRpc(connStartBlocker);
            this._frameHandler.setTimeout(10000);
            this._frameHandler.sendHeader();
            if (!this.isOpen()) {
                throw this._shutdownCause;
            }
            AMQP.Connection.Start connStart = (AMQP.Connection.Start)((Object)((AMQCommand)connStartBlocker.getReply()).getMethod());
            Version serverVersion = new Version(connStart.getVersionMajor(), connStart.getVersionMinor());
            if (!Version.checkVersion(clientVersion, serverVersion)) {
                this._frameHandler.close();
                throw new IOException("protocol version mismatch: expected " + clientVersion + ", got " + serverVersion);
            }
        }
        catch (ShutdownSignalException sse) {
            throw AMQChannel.wrap(sse);
        }
        LongString saslResponse = LongStringHelper.asLongString("\u0000" + params.getUserName() + "\u0000" + params.getPassword());
        AMQImpl.Connection.StartOk startOk = new AMQImpl.Connection.StartOk(this.buildClientPropertiesTable(), "PLAIN", saslResponse, "en_US");
        AMQP.Connection.Tune connTune = (AMQP.Connection.Tune)((Object)this._channel0.exnWrappingRpc(startOk).getMethod());
        int channelMax = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedChannelMax(), connTune.getChannelMax());
        this.setChannelMax(channelMax);
        int frameMax = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedFrameMax(), connTune.getFrameMax());
        this.setFrameMax(frameMax);
        int heartbeat = AMQConnection.negotiatedMaxValue(this.getParameters().getRequestedHeartbeat(), connTune.getHeartbeat());
        this.setHeartbeat(heartbeat);
        this._channel0.transmit(new AMQImpl.Connection.TuneOk(channelMax, frameMax, heartbeat));
        Method res = this._channel0.exnWrappingRpc(new AMQImpl.Connection.Open(params.getVirtualHost(), "", insist)).getMethod();
        if (res instanceof AMQP.Connection.Redirect) {
            AMQP.Connection.Redirect redirect = (AMQP.Connection.Redirect)((Object)res);
            throw new RedirectException(Address.parseAddress(redirect.getHost()), Address.parseAddresses(redirect.getKnownHosts()));
        }
        AMQP.Connection.OpenOk openOk = (AMQP.Connection.OpenOk)((Object)res);
        return Address.parseAddresses(openOk.getKnownHosts());
    }

    private static int negotiatedMaxValue(int clientValue, int serverValue) {
        return clientValue == 0 || serverValue == 0 ? Math.max(clientValue, serverValue) : Math.min(clientValue, serverValue);
    }

    public void maybeSendHeartbeat() throws IOException {
        if (this._heartbeat == 0) {
            return;
        }
        long now = System.nanoTime();
        if (now > this._lastActivityTime + (long)this._heartbeat * 1000000000L) {
            this._lastActivityTime = now;
            this.writeFrame(new Frame(8, 0));
        }
    }

    public void handleSocketTimeout() throws MissedHeartbeatException {
        if (this._heartbeat == 0) {
            return;
        }
        ++this._missedHeartbeats;
        if (this._missedHeartbeats > 8) {
            throw new MissedHeartbeatException("Heartbeat missing with heartbeat == " + this._heartbeat + " seconds");
        }
    }

    public boolean processControlCommand(Command c) throws IOException {
        Method method = c.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQP.Connection.Close) {
                this.handleConnectionClose(c);
                return true;
            }
            return false;
        }
        return !(method instanceof AMQP.Connection.CloseOk);
    }

    public void handleConnectionClose(Command closeCommand) {
        try {
            this._channel0.transmit(new AMQImpl.Connection.CloseOk());
        }
        catch (IOException ioe) {
            Utility.emptyStatement();
        }
        this.shutdown(closeCommand, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Object reason, boolean initiatedByApplication, Throwable cause) {
        AMQConnection aMQConnection = this;
        synchronized (aMQConnection) {
            this.ensureIsOpen();
            this._shutdownCause = new ShutdownSignalException(true, initiatedByApplication, reason);
        }
        if (cause != null) {
            this._shutdownCause.initCause(cause);
        }
        this._channel0.processShutdownSignal(this._shutdownCause);
        this._channelManager.handleSignal(this._shutdownCause);
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause) throws IOException {
        try {
            AMQImpl.Connection.Close reason = new AMQImpl.Connection.Close(closeCode, closeMessage, 0, 0);
            this.shutdown(reason, initiatedByApplication, cause);
            this._channel0.quiescingRpc(reason, 10000, new AMQCommand(new AMQImpl.Connection.CloseOk()));
        }
        catch (ShutdownSignalException sse) {
        }
        finally {
            this._running = false;
        }
    }

    public String toString() {
        return "amqp://" + this._params.getUserName() + "@" + this.getHost() + ":" + this.getPort() + this._params.getVirtualHost();
    }

    private class MainLoop
    extends Thread {
        public MainLoop() {
            this.start();
        }

        public void run() {
            block7: {
                try {
                    while (AMQConnection.this._running) {
                        Frame frame = AMQConnection.this.readFrame();
                        AMQConnection.this.maybeSendHeartbeat();
                        if (frame != null) {
                            AMQConnection.this._missedHeartbeats = 0;
                            if (frame.type == 8) continue;
                            if (frame.channel == 0) {
                                AMQConnection.this._channel0.handleFrame(frame);
                                continue;
                            }
                            if (!AMQConnection.this.isOpen()) continue;
                            ChannelN channel = AMQConnection.this._channelManager.getChannel(frame.channel);
                            channel.handleFrame(frame);
                            continue;
                        }
                        AMQConnection.this.handleSocketTimeout();
                    }
                }
                catch (EOFException ex) {
                    if (AMQConnection.this.isOpen()) {
                        System.err.println("AMQConnection.mainLoop: connection close");
                        AMQConnection.this.shutdown(ex, false, ex);
                    }
                }
                catch (Throwable ex) {
                    AMQConnection.this._exceptionHandler.handleUnexpectedConnectionDriverException(AMQConnection.this, ex);
                    if (!AMQConnection.this.isOpen()) break block7;
                    AMQConnection.this.shutdown(ex, false, ex);
                }
            }
            AMQConnection.this._frameHandler.close();
        }
    }
}

