/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import com.r0adkll.slidr.model.SlidrConfig;
import com.r0adkll.slidr.model.SlidrInterface;
import com.r0adkll.slidr.util.ViewDragHelper;
import com.r0adkll.slidr.widget.ScrimRenderer;

public class SliderPanel
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private int screenWidth;
    private int screenHeight;
    private View decorView;
    private ViewDragHelper dragHelper;
    private OnPanelSlideListener listener;
    private Paint scrimPaint;
    private ScrimRenderer scrimRenderer;
    private boolean isLocked = false;
    private boolean isEdgeTouched = false;
    private int edgePosition;
    private SlidrConfig config;
    private final SlidrInterface defaultSlidrInterface = new SlidrInterface(){

        @Override
        public void lock() {
            SliderPanel.this.lock();
        }

        @Override
        public void unlock() {
            SliderPanel.this.unlock();
        }
    };
    private final ViewDragHelper.Callback leftCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.dragHelper.isEdgeTouched(SliderPanel.this.edgePosition, pointerId);
            return child.getId() == SliderPanel.this.decorView.getId() && edgeCase;
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, 0, SliderPanel.this.screenWidth);
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.screenWidth;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold();
            if (xvel > 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = SliderPanel.this.screenWidth;
                } else if (left > leftThreshold) {
                    settleLeft = SliderPanel.this.screenWidth;
                }
            } else if (xvel == 0.0f && left > leftThreshold) {
                settleLeft = SliderPanel.this.screenWidth;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)left / (float)SliderPanel.this.screenWidth;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getLeft() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private final ViewDragHelper.Callback rightCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.dragHelper.isEdgeTouched(SliderPanel.this.edgePosition, pointerId);
            return child.getId() == SliderPanel.this.decorView.getId() && edgeCase;
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, -SliderPanel.this.screenWidth, 0);
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.screenWidth;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold();
            if (xvel < 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = -SliderPanel.this.screenWidth;
                } else if (left < -leftThreshold) {
                    settleLeft = -SliderPanel.this.screenWidth;
                }
            } else if (xvel == 0.0f && left < -leftThreshold) {
                settleLeft = -SliderPanel.this.screenWidth;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(left) / (float)SliderPanel.this.screenWidth;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getLeft() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private final ViewDragHelper.Callback topCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.decorView.getId() && (!SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.isEdgeTouched);
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, 0, SliderPanel.this.screenHeight);
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.screenHeight;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold();
            if (yvel > 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = SliderPanel.this.screenHeight;
                } else if (top > topThreshold) {
                    settleTop = SliderPanel.this.screenHeight;
                }
            } else if (yvel == 0.0f && top > topThreshold) {
                settleTop = SliderPanel.this.screenHeight;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.screenHeight;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getTop() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private final ViewDragHelper.Callback bottomCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.decorView.getId() && (!SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.isEdgeTouched);
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, -SliderPanel.this.screenHeight, 0);
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.screenHeight;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold();
            if (yvel < 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = -SliderPanel.this.screenHeight;
                } else if (top < -topThreshold) {
                    settleTop = -SliderPanel.this.screenHeight;
                }
            } else if (yvel == 0.0f && top < -topThreshold) {
                settleTop = -SliderPanel.this.screenHeight;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.screenHeight;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getTop() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private final ViewDragHelper.Callback verticalCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.decorView.getId() && (!SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.isEdgeTouched);
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, -SliderPanel.this.screenHeight, SliderPanel.this.screenHeight);
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.screenHeight;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isSideSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int top = releasedChild.getTop();
            int settleTop = 0;
            int topThreshold = (int)((float)SliderPanel.this.getHeight() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isSideSwiping = Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold();
            if (yvel > 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = SliderPanel.this.screenHeight;
                } else if (top > topThreshold) {
                    settleTop = SliderPanel.this.screenHeight;
                }
            } else if (yvel < 0.0f) {
                if (Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold() && !isSideSwiping) {
                    settleTop = -SliderPanel.this.screenHeight;
                } else if (top < -topThreshold) {
                    settleTop = -SliderPanel.this.screenHeight;
                }
            } else if (top > topThreshold) {
                settleTop = SliderPanel.this.screenHeight;
            } else if (top < -topThreshold) {
                settleTop = -SliderPanel.this.screenHeight;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(releasedChild.getLeft(), settleTop);
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.screenHeight;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getTop() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private final ViewDragHelper.Callback horizontalCallback = new ViewDragHelper.Callback(){

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            boolean edgeCase = !SliderPanel.this.config.isEdgeOnly() || SliderPanel.this.dragHelper.isEdgeTouched(SliderPanel.this.edgePosition, pointerId);
            return child.getId() == SliderPanel.this.decorView.getId() && edgeCase;
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, -SliderPanel.this.screenWidth, SliderPanel.this.screenWidth);
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.screenWidth;
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            boolean isVerticalSwiping;
            super.onViewReleased(releasedChild, xvel, yvel);
            int left = releasedChild.getLeft();
            int settleLeft = 0;
            int leftThreshold = (int)((float)SliderPanel.this.getWidth() * SliderPanel.this.config.getDistanceThreshold());
            boolean bl = isVerticalSwiping = Math.abs(yvel) > SliderPanel.this.config.getVelocityThreshold();
            if (xvel > 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = SliderPanel.this.screenWidth;
                } else if (left > leftThreshold) {
                    settleLeft = SliderPanel.this.screenWidth;
                }
            } else if (xvel < 0.0f) {
                if (Math.abs(xvel) > SliderPanel.this.config.getVelocityThreshold() && !isVerticalSwiping) {
                    settleLeft = -SliderPanel.this.screenWidth;
                } else if (left < -leftThreshold) {
                    settleLeft = -SliderPanel.this.screenWidth;
                }
            } else if (left > leftThreshold) {
                settleLeft = SliderPanel.this.screenWidth;
            } else if (left < -leftThreshold) {
                settleLeft = -SliderPanel.this.screenWidth;
            }
            SliderPanel.this.dragHelper.settleCapturedViewAt(settleLeft, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(left) / (float)SliderPanel.this.screenWidth;
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onSlideChange(percent);
            }
            SliderPanel.this.applyScrim(percent);
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SliderPanel.this.listener != null) {
                SliderPanel.this.listener.onStateChanged(state);
            }
            switch (state) {
                case 0: {
                    if (SliderPanel.this.decorView.getLeft() == 0) {
                        if (SliderPanel.this.listener == null) break;
                        SliderPanel.this.listener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.listener == null) break;
                    SliderPanel.this.listener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };

    public SliderPanel(Context context) {
        super(context);
    }

    public SliderPanel(Context context, View decorView, SlidrConfig config) {
        super(context);
        this.decorView = decorView;
        this.config = config == null ? new SlidrConfig.Builder().build() : config;
        this.init();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean interceptForDrag;
        if (this.isLocked) {
            return false;
        }
        if (this.config.isEdgeOnly()) {
            this.isEdgeTouched = this.canDragFromEdge(ev);
        }
        try {
            interceptForDrag = this.dragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception e) {
            interceptForDrag = false;
        }
        return interceptForDrag && !this.isLocked;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isLocked) {
            return false;
        }
        try {
            this.dragHelper.processTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.scrimRenderer.render(canvas, this.config.getPosition(), this.scrimPaint);
    }

    public void setOnPanelSlideListener(OnPanelSlideListener listener) {
        this.listener = listener;
    }

    public SlidrInterface getDefaultInterface() {
        return this.defaultSlidrInterface;
    }

    private void init() {
        ViewDragHelper.Callback callback;
        this.setWillNotDraw(false);
        this.screenWidth = this.getResources().getDisplayMetrics().widthPixels;
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        switch (this.config.getPosition()) {
            case LEFT: {
                callback = this.leftCallback;
                this.edgePosition = 1;
                break;
            }
            case RIGHT: {
                callback = this.rightCallback;
                this.edgePosition = 2;
                break;
            }
            case TOP: {
                callback = this.topCallback;
                this.edgePosition = 4;
                break;
            }
            case BOTTOM: {
                callback = this.bottomCallback;
                this.edgePosition = 8;
                break;
            }
            case VERTICAL: {
                callback = this.verticalCallback;
                this.edgePosition = 12;
                break;
            }
            case HORIZONTAL: {
                callback = this.horizontalCallback;
                this.edgePosition = 3;
                break;
            }
            default: {
                callback = this.leftCallback;
                this.edgePosition = 1;
            }
        }
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, this.config.getSensitivity(), callback);
        this.dragHelper.setMinVelocity(minVel);
        this.dragHelper.setEdgeTrackingEnabled(this.edgePosition);
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        this.scrimPaint = new Paint();
        this.scrimPaint.setColor(this.config.getScrimColor());
        this.scrimPaint.setAlpha(SliderPanel.toAlpha(this.config.getScrimStartAlpha()));
        this.scrimRenderer = new ScrimRenderer((View)this, this.decorView);
        this.post(new Runnable(){

            @Override
            public void run() {
                SliderPanel.this.screenHeight = SliderPanel.this.getHeight();
            }
        });
    }

    private void lock() {
        this.dragHelper.abort();
        this.isLocked = true;
    }

    private void unlock() {
        this.dragHelper.abort();
        this.isLocked = false;
    }

    private boolean canDragFromEdge(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        switch (this.config.getPosition()) {
            case LEFT: {
                return x < this.config.getEdgeSize(this.getWidth());
            }
            case RIGHT: {
                return x > (float)this.getWidth() - this.config.getEdgeSize(this.getWidth());
            }
            case BOTTOM: {
                return y > (float)this.getHeight() - this.config.getEdgeSize(this.getHeight());
            }
            case TOP: {
                return y < this.config.getEdgeSize(this.getHeight());
            }
            case HORIZONTAL: {
                return x < this.config.getEdgeSize(this.getWidth()) || x > (float)this.getWidth() - this.config.getEdgeSize(this.getWidth());
            }
            case VERTICAL: {
                return y < this.config.getEdgeSize(this.getHeight()) || y > (float)this.getHeight() - this.config.getEdgeSize(this.getHeight());
            }
        }
        return false;
    }

    private void applyScrim(float percent) {
        float alpha = percent * (this.config.getScrimStartAlpha() - this.config.getScrimEndAlpha()) + this.config.getScrimEndAlpha();
        this.scrimPaint.setAlpha(SliderPanel.toAlpha(alpha));
        this.invalidate(this.scrimRenderer.getDirtyRect(this.config.getPosition()));
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static int toAlpha(float percentage) {
        return (int)(percentage * 255.0f);
    }

    public static interface OnPanelSlideListener {
        public void onStateChanged(int var1);

        public void onClosed();

        public void onOpened();

        public void onSlideChange(float var1);
    }
}

