/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr;

import android.animation.ArgbEvaluator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.r0adkll.slidr.R;
import com.r0adkll.slidr.model.SlidrConfig;
import com.r0adkll.slidr.model.SlidrInterface;
import com.r0adkll.slidr.widget.SliderPanel;

public class Slidr {
    public static SlidrInterface attach(Activity activity) {
        return Slidr.attach(activity, -1, -1);
    }

    public static SlidrInterface attach(final Activity activity, final int statusBarColor1, final int statusBarColor2) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View oldScreen = decorView.getChildAt(0);
        decorView.removeViewAt(0);
        final SliderPanel panel = new SliderPanel((Context)activity, oldScreen);
        panel.setId(R.id.slidable_panel);
        oldScreen.setId(R.id.slidable_content);
        panel.addView(oldScreen);
        decorView.addView((View)panel, 0);
        panel.setOnPanelSlideListener(new SliderPanel.OnPanelSlideListener(){
            private final ArgbEvaluator mEvaluator = new ArgbEvaluator();

            @Override
            public void onStateChanged(int state) {
            }

            @Override
            public void onClosed() {
                activity.finish();
                activity.overridePendingTransition(0, 0);
            }

            @Override
            public void onOpened() {
            }

            @Override
            @TargetApi(value=21)
            public void onSlideChange(float percent) {
                if (Build.VERSION.SDK_INT >= 21 && statusBarColor1 != -1 && statusBarColor2 != -1) {
                    int newColor = (Integer)this.mEvaluator.evaluate(percent, (Object)statusBarColor1, (Object)statusBarColor2);
                    activity.getWindow().setStatusBarColor(newColor);
                }
            }
        });
        SlidrInterface slidrInterface = new SlidrInterface(){

            @Override
            public void lock() {
                panel.lock();
            }

            @Override
            public void unlock() {
                panel.unlock();
            }
        };
        return slidrInterface;
    }

    public static SlidrInterface attach(final Activity activity, final SlidrConfig config) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View oldScreen = decorView.getChildAt(0);
        decorView.removeViewAt(0);
        final SliderPanel panel = new SliderPanel((Context)activity, oldScreen, config);
        panel.setId(R.id.slidable_panel);
        oldScreen.setId(R.id.slidable_content);
        panel.addView(oldScreen);
        decorView.addView((View)panel, 0);
        panel.setOnPanelSlideListener(new SliderPanel.OnPanelSlideListener(){
            private final ArgbEvaluator mEvaluator = new ArgbEvaluator();

            @Override
            public void onStateChanged(int state) {
                if (config.getListener() != null) {
                    config.getListener().onSlideStateChanged(state);
                }
            }

            @Override
            public void onClosed() {
                if (config.getListener() != null) {
                    config.getListener().onSlideClosed();
                }
                activity.finish();
                activity.overridePendingTransition(0, 0);
            }

            @Override
            public void onOpened() {
                if (config.getListener() != null) {
                    config.getListener().onSlideOpened();
                }
            }

            @Override
            @TargetApi(value=21)
            public void onSlideChange(float percent) {
                if (Build.VERSION.SDK_INT >= 21 && config.areStatusBarColorsValid()) {
                    int newColor = (Integer)this.mEvaluator.evaluate(percent, (Object)config.getPrimaryColor(), (Object)config.getSecondaryColor());
                    activity.getWindow().setStatusBarColor(newColor);
                }
                if (config.getListener() != null) {
                    config.getListener().onSlideChange(percent);
                }
            }
        });
        SlidrInterface slidrInterface = new SlidrInterface(){

            @Override
            public void lock() {
                panel.lock();
            }

            @Override
            public void unlock() {
                panel.unlock();
            }
        };
        return slidrInterface;
    }

    public static SlidrInterface replace(ViewGroup view, final SlidrConfig config) {
        ViewGroup parent = (ViewGroup)view.getParent();
        ViewGroup.LayoutParams params = view.getLayoutParams();
        parent.removeView((View)view);
        final SliderPanel panel = new SliderPanel(view.getContext(), (View)view, config);
        panel.setId(view.getId());
        view.setId(R.id.slidable_panel);
        panel.addView((View)view);
        parent.addView((View)panel, params);
        panel.setOnPanelSlideListener(new SliderPanel.OnPanelSlideListener(){

            @Override
            public void onStateChanged(int state) {
                if (config.getListener() != null) {
                    config.getListener().onSlideStateChanged(state);
                }
            }

            @Override
            public void onClosed() {
                if (config.getListener() != null) {
                    config.getListener().onSlideClosed();
                }
            }

            @Override
            public void onOpened() {
                if (config.getListener() != null) {
                    config.getListener().onSlideOpened();
                }
            }

            @Override
            @TargetApi(value=21)
            public void onSlideChange(float percent) {
                if (config.getListener() != null) {
                    config.getListener().onSlideChange(percent);
                }
            }
        });
        SlidrInterface slidrInterface = new SlidrInterface(){

            @Override
            public void lock() {
                panel.lock();
            }

            @Override
            public void unlock() {
                panel.unlock();
            }
        };
        return slidrInterface;
    }
}

