/*
 * Decompiled with CFR 0.152.
 */
package com.qw.workflow;

import android.util.SparseArray;
import com.qw.workflow.DevTools;
import com.qw.workflow.WorkNode;

public class WorkFlow {
    private final String TAG = WorkFlow.class.getSimpleName();
    private SparseArray<WorkNode> flowNodes;
    private WorkNode recentNode;
    private boolean isDisposed = false;
    private FlowCallBack callBack;

    public WorkFlow(SparseArray<WorkNode> flowNodes) {
        this.flowNodes = flowNodes;
    }

    public void setCallBack(FlowCallBack callBack) {
        this.callBack = callBack;
    }

    public void dispose() {
        this.reset();
        if (null != this.flowNodes) {
            this.flowNodes.clear();
            this.flowNodes = null;
            this.recentNode = null;
        }
        this.isDisposed = true;
        this.callBack = null;
    }

    public void addNode(WorkNode workNode) {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        this.flowNodes.append(workNode.getId(), (Object)workNode);
    }

    public void start() {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        this.startWithNode(this.flowNodes.keyAt(0));
    }

    public void startWithNode(int startNodeId) {
        WorkNode startNode;
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (this.flowNodes.indexOfKey(startNodeId) < 0 || this.flowNodes.size() == 0) {
            DevTools.w(this.TAG, "there is no node in workFlow");
            return;
        }
        this.reset();
        final int startIndex = this.flowNodes.indexOfKey(startNodeId);
        this.recentNode = startNode = (WorkNode)this.flowNodes.valueAt(startIndex);
        startNode.doWork(new WorkNode.WorkCallBack(){

            @Override
            public void onWorkCompleted() {
                WorkFlow.this.findAndExecuteNextNodeIfExist(startIndex);
            }
        });
        if (null != this.callBack) {
            this.callBack.onNodeChanged(startNode.getId());
        }
    }

    public void continueWork() {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (null != this.recentNode) {
            this.recentNode.onCompleted();
        }
    }

    public void revert() {
        int recentIndex;
        int targetId;
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (null != this.recentNode && null != this.flowNodes && (targetId = this.flowNodes.keyAt((recentIndex = this.flowNodes.indexOfValue((Object)this.recentNode)) - 1)) >= 0) {
            this.startWithNode(targetId);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public int getRecentNodeId() {
        if (null == this.recentNode) {
            return -1;
        }
        return this.recentNode.getId();
    }

    private void findAndExecuteNextNodeIfExist(int startIndex) {
        final int nextIndex = startIndex + 1;
        WorkNode nextNode = (WorkNode)this.flowNodes.valueAt(nextIndex);
        if (null != nextNode) {
            this.recentNode = nextNode;
            nextNode.doWork(new WorkNode.WorkCallBack(){

                @Override
                public void onWorkCompleted() {
                    WorkFlow.this.findAndExecuteNextNodeIfExist(nextIndex);
                }
            });
            if (null != this.callBack) {
                this.callBack.onNodeChanged(nextNode.getId());
            }
            return;
        }
        if (null != this.callBack) {
            this.callBack.onFlowFinish();
        }
    }

    private void reset() {
        if (null != this.flowNodes) {
            for (int i = 0; i < this.flowNodes.size(); ++i) {
                ((WorkNode)this.flowNodes.valueAt(i)).removeCallBack();
            }
        }
    }

    public static class Builder {
        private SparseArray<WorkNode> f = new SparseArray();
        private FlowCallBack cb;

        public Builder withNode(WorkNode node) {
            this.f.append(node.getId(), (Object)node);
            return this;
        }

        public Builder setCallBack(FlowCallBack callBack) {
            this.cb = callBack;
            return this;
        }

        public WorkFlow create() {
            WorkFlow workFlow = new WorkFlow(this.f);
            workFlow.setCallBack(this.cb);
            return workFlow;
        }
    }

    public static interface FlowCallBack {
        public void onNodeChanged(int var1);

        public void onFlowFinish();
    }
}

