/*
 * Decompiled with CFR 0.152.
 */
package com.qw.workflow;

import com.qw.workflow.Node;
import com.qw.workflow.Worker;

public class WorkNode
implements Node {
    private int nodeId;
    private Worker worker;
    private WorkCallBack callBack;

    public static WorkNode build(int nodeId, Worker worker) {
        return new WorkNode(nodeId, worker);
    }

    public WorkNode(int nodeId, Worker worker) {
        this.nodeId = nodeId;
        this.worker = worker;
    }

    void doWork(WorkCallBack callBack) {
        this.callBack = callBack;
        this.worker.doWork(this);
    }

    void removeCallBack() {
        this.callBack = null;
    }

    @Override
    public int getId() {
        return this.nodeId;
    }

    @Override
    public void onCompleted() {
        if (null != this.callBack) {
            this.callBack.onWorkCompleted();
        }
    }

    public String toString() {
        return "nodeId : " + this.getId();
    }

    static interface WorkCallBack {
        public void onWorkCompleted();
    }
}

