/*
 * Decompiled with CFR 0.152.
 */
package com.qw.workflow;

import android.util.SparseArray;
import com.qw.workflow.WorkNode;

public class WorkFlow {
    private final String TAG = WorkFlow.class.getSimpleName();
    private SparseArray<WorkNode> flowNodes;
    private WorkNode recentNode;
    private boolean isDisposed = false;

    public WorkFlow(SparseArray<WorkNode> flowNodes) {
        this.flowNodes = flowNodes;
    }

    public void dispose() {
        this.reset();
        if (null != this.flowNodes) {
            this.flowNodes.clear();
            this.flowNodes = null;
            this.recentNode = null;
        }
        this.isDisposed = true;
    }

    public void addNode(WorkNode workNode) {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        this.flowNodes.append(workNode.getId(), (Object)workNode);
    }

    public void start() {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        this.startWithNode(this.flowNodes.keyAt(0));
    }

    public void startWithNode(int startNodeId) {
        WorkNode startNode;
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (this.flowNodes.indexOfKey(startNodeId) < 0 || this.flowNodes.size() == 0) {
            return;
        }
        this.reset();
        final int startIndex = this.flowNodes.indexOfKey(startNodeId);
        this.recentNode = startNode = (WorkNode)this.flowNodes.valueAt(startIndex);
        startNode.doWork(new WorkNode.WorkCallBack(){

            @Override
            public void onWorkCompleted() {
                WorkFlow.this.findAndExecuteNextNodeIfExist(startIndex);
            }
        });
    }

    public void continueWork() {
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (null != this.recentNode) {
            this.recentNode.onCompleted();
        }
    }

    public void revert() {
        int recentIndex;
        int targetId;
        if (this.isDisposed) {
            throw new IllegalStateException("you can not operate a disposed workflow");
        }
        if (null != this.recentNode && null != this.flowNodes && (targetId = this.flowNodes.keyAt((recentIndex = this.flowNodes.indexOfValue((Object)this.recentNode)) - 1)) >= 0) {
            this.startWithNode(targetId);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public int getRecentNodeId() {
        if (null == this.recentNode) {
            return -1;
        }
        return this.recentNode.getId();
    }

    private void findAndExecuteNextNodeIfExist(int startIndex) {
        final int nextIndex = startIndex + 1;
        WorkNode nextNode = (WorkNode)this.flowNodes.valueAt(nextIndex);
        if (null != nextNode) {
            this.recentNode = nextNode;
            nextNode.doWork(new WorkNode.WorkCallBack(){

                @Override
                public void onWorkCompleted() {
                    WorkFlow.this.findAndExecuteNextNodeIfExist(nextIndex);
                }
            });
        }
    }

    private void reset() {
        if (null != this.flowNodes) {
            for (int i = 0; i < this.flowNodes.size(); ++i) {
                ((WorkNode)this.flowNodes.valueAt(i)).removeCallBack();
            }
        }
    }

    public static class Builder {
        private SparseArray<WorkNode> f = new SparseArray();

        public Builder withNode(WorkNode node) {
            this.f.append(node.getId(), (Object)node);
            return this;
        }

        public WorkFlow create() {
            return new WorkFlow(this.f);
        }
    }
}

