/*
 * Decompiled with CFR 0.152.
 */
package com.qw.curtain.lib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.qw.curtain.lib.HollowInfo;
import java.util.HashMap;

public class GuideView
extends View {
    private HollowInfo[] mHollows;
    private HashMap<HollowInfo, Rect> mPositionCache;
    private int mCurtainColor = -2013265920;
    private Paint mPaint;

    public GuideView(@NonNull Context context) {
        super(context, null);
        this.init();
    }

    public void setHollowInfo(HollowInfo ... hollows) {
        this.mHollows = hollows;
        this.postInvalidate();
    }

    public void setCurtainColor(int color) {
        this.mCurtainColor = color;
        this.postInvalidate();
    }

    private void init() {
        this.mPaint = new Paint(1);
        this.mPositionCache = new HashMap(10);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int count = Build.VERSION.SDK_INT >= 21 ? canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null) : canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        this.drawBackGround(canvas);
        this.drawHollowFields(canvas);
        canvas.restoreToCount(count);
    }

    private void drawBackGround(Canvas canvas) {
        this.mPaint.setXfermode(null);
        this.mPaint.setColor(this.mCurtainColor);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
    }

    private void drawHollowFields(Canvas canvas) {
        this.mPaint.setColor(-1);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        for (HollowInfo mHollow : this.mHollows) {
            this.drawSingleHollow(mHollow, canvas);
        }
    }

    private void drawSingleHollow(HollowInfo info, Canvas canvas) {
        if (this.mHollows.length <= 0) {
            return;
        }
        Rect fromCache = this.mPositionCache.get(info);
        if (null != fromCache) {
            canvas.drawRect(fromCache, this.mPaint);
            return;
        }
        if (null == info.targetBound) {
            info.targetBound = new Rect();
            info.targetView.getDrawingRect(info.targetBound);
        }
        int[] viewLocation = new int[2];
        info.targetView.getLocationOnScreen(viewLocation);
        info.targetBound.left = viewLocation[0];
        info.targetBound.top = viewLocation[1];
        info.targetBound.right += info.targetBound.left;
        info.targetBound.bottom += info.targetBound.top;
        int padding = info.padding;
        info.targetBound.left -= padding;
        info.targetBound.top -= padding;
        info.targetBound.right += padding;
        info.targetBound.bottom += padding;
        if (info.getOffset(0x40000000) > 0) {
            info.targetBound.top += info.getOffset(0x40000000);
            info.targetBound.bottom += info.getOffset(0x40000000);
        }
        if (info.getOffset(Integer.MIN_VALUE) > 0) {
            info.targetBound.right += info.getOffset(Integer.MIN_VALUE);
            info.targetBound.left += info.getOffset(Integer.MIN_VALUE);
        }
        info.targetBound.top -= this.getStatusBarHeight();
        info.targetBound.bottom -= this.getStatusBarHeight();
        canvas.drawRect(info.targetBound, this.mPaint);
        this.mPositionCache.put(info, info.targetBound);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getScreenWidth(), this.getScreenHeight() * 2);
    }

    private int getScreenWidth() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    private int getScreenHeight() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.heightPixels;
    }

    private int getStatusBarHeight() {
        int statusBarHeight = 0;
        int resourceId = this.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }
}

