/*
 * Decompiled with CFR 0.152.
 */
package com.qw.curtain.lib;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.qw.curtain.lib.Curtain;
import com.qw.curtain.lib.GuideView;
import com.qw.curtain.lib.HollowInfo;
import com.qw.curtain.lib.IGuide;
import com.qw.curtain.lib.R;

public class GuideDialogFragment
extends DialogFragment
implements IGuide {
    private static final int MAX_CHILD_COUNT = 2;
    private static final int GUIDE_ID = 3;
    private FrameLayout contentView;
    private int animationStyle = R.style.dialogWindowAnim;
    private Dialog dialog;
    private Curtain.CallBack callBack;
    private int topLayoutRes = 0;

    public void show(GuideView guideView) {
        FragmentActivity activity = (FragmentActivity)guideView.getContext();
        guideView.setId(3);
        this.contentView = new FrameLayout((Context)activity);
        this.contentView.addView((View)guideView);
        this.dialog = new AlertDialog.Builder((Context)activity, R.style.TransparentDialog).setView((View)this.contentView).create();
        this.setAnimation(this.dialog);
        this.show(activity.getSupportFragmentManager(), GuideDialogFragment.class.getSimpleName());
    }

    public void setAnimationStyle(int animationStyle) {
        this.animationStyle = animationStyle;
    }

    public void setCallBack(Curtain.CallBack callBack) {
        this.callBack = callBack;
    }

    public void setTopViewRes(int topLayoutRes) {
        this.topLayoutRes = topLayoutRes;
    }

    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (Exception e) {
            manager.beginTransaction().add((Fragment)this, tag).commitAllowingStateLoss();
        }
    }

    @Override
    public void updateHollows(HollowInfo ... hollows) {
        GuideView guideView = (GuideView)this.contentView.findViewById(3);
        if (null != guideView) {
            guideView.setHollowInfo(hollows);
        }
    }

    @Override
    public void updateTopView(@LayoutRes int layoutId) {
        if (null == this.contentView || this.getActivity() == null) {
            return;
        }
        this.setTopViewRes(layoutId);
        this.updateTopView();
    }

    @Override
    public <T extends View> T findViewByIdInTopView(int id) {
        if (null == this.contentView) {
            return null;
        }
        return (T)this.contentView.findViewById(id);
    }

    @Override
    public void dismissGuide() {
        this.dismissAllowingStateLoss();
    }

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        return this.dialog;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        try {
            super.onActivityCreated(savedInstanceState);
        }
        catch (Exception e) {
            return;
        }
        if (this.topLayoutRes != 0) {
            this.updateTopView();
        }
        if (null != this.callBack) {
            this.callBack.onShow(this);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (null != this.callBack) {
            this.callBack.onDismiss(this);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.dialog != null) {
            this.dialog = null;
        }
    }

    private void setAnimation(Dialog dialog) {
        if (this.animationStyle != 0 && dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setWindowAnimations(this.animationStyle);
        }
    }

    private void updateTopView() {
        if (this.contentView.getChildCount() == 2) {
            this.contentView.removeViewAt(1);
        }
        LayoutInflater.from((Context)this.getActivity()).inflate(this.topLayoutRes, (ViewGroup)this.contentView, true);
    }
}

