/*
 * Decompiled with CFR 0.152.
 */
package com.qw.curtain.lib;

import android.content.Context;
import android.graphics.Rect;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.qw.curtain.lib.GuideDialogFragment;
import com.qw.curtain.lib.GuideView;
import com.qw.curtain.lib.HollowInfo;
import com.qw.curtain.lib.IGuide;

public class Curtain {
    private FragmentActivity activity;
    private SparseArray<HollowInfo> hollows;
    private CallBack callBack;
    private boolean cancelBackPressed = true;
    private int curtainColor = -1442840576;
    private int topViewId;
    private int animationStyle = 0;

    public Curtain(Fragment fragment) {
        this(fragment.getActivity());
    }

    public Curtain(FragmentActivity activity) {
        this.activity = activity;
        this.hollows = new SparseArray();
    }

    public Curtain with(View which) {
        if (which.getId() == -1) {
            throw new IllegalArgumentException("view must have an id");
        }
        HollowInfo info = this.findHollow(which);
        if (null == info) {
            this.append(which);
        }
        return this;
    }

    public Curtain withPadding(View which, int padding) {
        if (which.getId() == -1) {
            throw new IllegalArgumentException("view must have an id");
        }
        HollowInfo info = this.findHollow(which);
        if (null == info) {
            info = this.append(which);
        }
        info.padding = padding;
        return this;
    }

    public Curtain withSize(View which, int width, int height) {
        if (which.getId() == -1) {
            throw new IllegalArgumentException("view must have an id");
        }
        HollowInfo info = this.findHollow(which);
        if (null == info) {
            info = this.append(which);
        }
        info.targetBound = new Rect(0, 0, width, height);
        return this;
    }

    public Curtain withOffset(View which, int offset, int direction2) {
        if (which.getId() == -1) {
            throw new IllegalArgumentException("view must have an id");
        }
        HollowInfo info = this.findHollow(which);
        if (null == info) {
            info = this.append(which);
        }
        info.setOffset(offset, direction2);
        return this;
    }

    public Curtain setTopView(@LayoutRes int layoutId) {
        this.topViewId = layoutId;
        return this;
    }

    public Curtain setCurtainColor(int color) {
        this.curtainColor = color;
        return this;
    }

    public Curtain setCurtainColorRes(@ColorRes int color) {
        this.curtainColor = color;
        return this;
    }

    public Curtain setCancelBackPressed(boolean cancelBackPress) {
        this.cancelBackPressed = cancelBackPress;
        return this;
    }

    public Curtain setCallBack(CallBack callBack) {
        this.callBack = callBack;
        return this;
    }

    public Curtain setAnimationStyle(@StyleRes int animation) {
        this.animationStyle = animation;
        return this;
    }

    public void show() {
        if (this.hollows.size() == 0) {
            throw new IllegalStateException("with out any views");
        }
        GuideDialogFragment guider = new GuideDialogFragment();
        guider.setCancelable(this.cancelBackPressed);
        guider.setCallBack(this.callBack);
        guider.setAnimationStyle(this.animationStyle);
        guider.setTopViewRes(this.topViewId);
        GuideView guideView = new GuideView((Context)this.activity);
        guideView.setCurtainColor(this.curtainColor);
        this.addHollows(guideView);
        guider.show(guideView);
    }

    private HollowInfo findHollow(View view) {
        for (int i = 0; i < this.hollows.size(); ++i) {
            HollowInfo info = (HollowInfo)this.hollows.valueAt(i);
            if (info.targetView != view) continue;
            return info;
        }
        return null;
    }

    private HollowInfo append(View view) {
        HollowInfo info = new HollowInfo(view);
        info.targetView = view;
        this.hollows.append(view.getId(), (Object)info);
        return info;
    }

    private void addHollows(GuideView guideView) {
        HollowInfo[] tobeDraw = new HollowInfo[this.hollows.size()];
        for (int i = 0; i < this.hollows.size(); ++i) {
            tobeDraw[i] = (HollowInfo)this.hollows.valueAt(i);
        }
        guideView.setHollowInfo(tobeDraw);
    }

    public static interface CallBack {
        public void onShow(IGuide var1);

        public void onDismiss(IGuide var1);
    }
}

