/*
 * Decompiled with CFR 0.152.
 */
package com.hunter.library.timing.impl;

import android.util.Log;
import com.hunter.library.timing.IBlockHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StacktraceBlockHandler
implements IBlockHandler {
    private final String TAG = "StacktraceBlockImpl";
    private String newline = System.getProperty("line.separator");
    private String doubleNewline = this.newline + this.newline;
    private List<BlockTrace> blockTraces = Collections.synchronizedList(new ArrayList());
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int threshold;

    public StacktraceBlockHandler(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void timingMethod(String method, final int mills) {
        if (mills < this.threshold()) {
            return;
        }
        Log.i((String)"StacktraceBlockImpl", (String)(method + " costs " + mills));
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        final StackTraceElement currMethod = stackTraceElements[2];
        final StackTraceElement callMethod = stackTraceElements[3];
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                StacktraceBlockHandler.this.buildStacktrace(mills, currMethod.getClassName() + "." + currMethod.getMethodName(), callMethod.getClassName() + "." + callMethod.getMethodName());
            }
        });
    }

    private void buildStacktrace(int currMills, String currMethod, String callMethod) {
        boolean flag = false;
        for (BlockTrace blockTrace : this.blockTraces) {
            String method = blockTrace.methods.get(blockTrace.methods.size() - 1);
            int mills = blockTrace.mills.get(blockTrace.mills.size() - 1);
            if (!currMethod.equals(method) || mills != -1) continue;
            blockTrace.mills.set(blockTrace.mills.size() - 1, currMills);
            if (blockTrace.traceCostedTime < currMills) {
                blockTrace.traceCostedTime = currMills;
            }
            blockTrace.methods.add(callMethod);
            blockTrace.mills.add(-1);
            flag = true;
        }
        if (!flag) {
            BlockTrace blockTrace = new BlockTrace();
            blockTrace.methods.add(currMethod);
            blockTrace.mills.add(currMills);
            blockTrace.methods.add(callMethod);
            blockTrace.mills.add(-1);
            this.blockTraces.add(blockTrace);
        }
    }

    @Override
    public String dump() {
        String stackTraceContent = this.getBlockStackTrace();
        Log.i((String)"StacktraceBlockImpl", (String)stackTraceContent);
        return stackTraceContent;
    }

    private String getBlockStackTrace() {
        ArrayList<BlockTrace> copyBlockTraces = new ArrayList<BlockTrace>(this.blockTraces);
        Collections.sort(copyBlockTraces, new Comparator<BlockTrace>(){

            @Override
            public int compare(BlockTrace o1, BlockTrace o2) {
                if (o1.traceCostedTime > o2.traceCostedTime) {
                    return -1;
                }
                if (o1.traceCostedTime < o2.traceCostedTime) {
                    return 1;
                }
                return 0;
            }
        });
        StringBuilder result = new StringBuilder();
        result.append(this.doubleNewline).append("----BlockStackTrace----Total ").append(copyBlockTraces.size()).append("----");
        for (BlockTrace blockTrace : copyBlockTraces) {
            result.append(this.newline).append("Block StackTrace ").append(copyBlockTraces.indexOf(blockTrace)).append(this.newline);
            result.append(blockTrace.toString()).append(this.newline);
        }
        return result.toString();
    }

    @Override
    public void clear() {
        this.blockTraces.clear();
    }

    @Override
    public int threshold() {
        return this.threshold;
    }

    private class BlockTrace {
        ArrayList<String> methods = new ArrayList();
        ArrayList<Integer> mills = new ArrayList();
        int traceCostedTime = -1;

        BlockTrace() {
        }

        public String toString() {
            int size = this.methods.size();
            if (size <= 0) {
                return "BlockTrace length is " + size;
            }
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < size; ++i) {
                if (i != size - 1) {
                    stringBuilder.append(this.methods.get(i)).append(" costed ").append(this.mills.get(i)).append("ms").append("\n");
                    continue;
                }
                stringBuilder.append(this.methods.get(i)).append(" is root");
            }
            return stringBuilder.toString();
        }
    }
}

