/*
 * Decompiled with CFR 0.152.
 */
package com.hunter.library.debug;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;

public class TimingLogger {
    private String mTag;
    private String mLabel;
    private boolean mDisabled;
    ArrayList<Long> mSplits;
    ArrayList<String> mSplitLabels;

    public TimingLogger(String tag, String label) {
        this.reset(tag, label);
    }

    public void reset(String tag, String label) {
        this.mTag = tag;
        this.mLabel = label;
        this.reset();
    }

    public void reset() {
        this.mDisabled = false;
        if (this.mDisabled) {
            return;
        }
        if (this.mSplits == null) {
            this.mSplits = new ArrayList();
            this.mSplitLabels = new ArrayList();
        } else {
            this.mSplits.clear();
            this.mSplitLabels.clear();
        }
        this.addSplit(null);
    }

    public void addSplit(String splitLabel) {
        if (this.mDisabled) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        this.mSplits.add(now);
        this.mSplitLabels.add(splitLabel);
    }

    public void dumpToLog() {
        long first;
        if (this.mDisabled) {
            return;
        }
        Log.d((String)this.mTag, (String)(this.mLabel + ": begin"));
        long now = first = this.mSplits.get(0).longValue();
        for (int i = 1; i < this.mSplits.size(); ++i) {
            now = this.mSplits.get(i);
            String splitLabel = this.mSplitLabels.get(i);
            long prev = this.mSplits.get(i - 1);
            Log.d((String)this.mTag, (String)(this.mLabel + ":      " + (now - prev) + " ms, " + splitLabel));
        }
        Log.d((String)this.mTag, (String)(this.mLabel + ": end, " + (now - first) + " ms"));
    }
}

