/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;

public class PermissionHelper {
    public static boolean onRequestPermissionsResult(int[] grantResults) {
        if (grantResults != null) {
            boolean result = true;
            for (int status : grantResults) {
                result = result && status == 0;
            }
            return result;
        }
        return false;
    }

    public static boolean checkSelfPermission(Context context, String ... permissionAsked) {
        if (permissionAsked != null) {
            boolean result = true;
            for (String onePermission : permissionAsked) {
                result = result && ActivityCompat.checkSelfPermission((Context)context, (String)onePermission) == 0;
            }
            return result;
        }
        return false;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissionAsked) {
        if (permissionAsked != null) {
            boolean result = true;
            for (String onePermission : permissionAsked) {
                result = result || ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)onePermission);
            }
            return result;
        }
        return false;
    }
}

