/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.os.Handler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class JavaHelper {
    private static final Random r = new Random();

    public static int getRandomInteger(int min, int max) {
        return r.nextInt(max - min) + min;
    }

    public static void delayAction(long delay, Runnable runnable) {
        new Handler().postDelayed(runnable, delay);
    }

    public static <T> Set<T> getSetIntersec(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>();
        for (T value : set1) {
            if (!set2.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static <T, E> Map<T, E> getMapIntersec(Map<T, E> map1, Map<T, E> map2) {
        return JavaHelper.getMapIntersec(map1, map2, false);
    }

    public static <T, E> Map<T, E> getMapIntersec(Map<T, E> map1, Map<T, E> map2, boolean map2Values) {
        HashMap<T, E> result = new HashMap<T, E>();
        if (map1 != null && map2 != null) {
            for (Map.Entry<T, E> entry1 : map1.entrySet()) {
                T key = entry1.getKey();
                if (!map2.containsKey(key)) continue;
                if (map2Values) {
                    result.put(key, map2.get(key));
                    continue;
                }
                result.put(key, map1.get(key));
            }
        }
        return result;
    }

    public static <T, E> Map<T, E> getMapReverseIntersec(Map<T, E> map1, Map<T, E> map2) {
        HashMap<T, E> result = new HashMap<T, E>();
        if (map1 != null && map2 != null) {
            T key;
            for (Map.Entry<T, E> entry1 : map1.entrySet()) {
                key = entry1.getKey();
                if (map2.containsKey(key)) continue;
                result.put(key, map1.get(key));
            }
            for (Map.Entry<T, E> entry2 : map2.entrySet()) {
                key = entry2.getKey();
                if (map1.containsKey(key)) continue;
                result.put(key, map2.get(key));
            }
        }
        return result;
    }
}

