/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.os.Build;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class CurrencyHelper {
    public static List<Currency> getCurrencyList() {
        if (Build.VERSION.SDK_INT >= 19) {
            return new ArrayList<Currency>(Currency.getAvailableCurrencies());
        }
        HashMap<String, Currency> currencyList = new HashMap<String, Currency>();
        for (Locale locale : Locale.getAvailableLocales()) {
            try {
                Currency currency = Currency.getInstance(locale);
                if (currencyList.containsKey(currency.getCurrencyCode())) continue;
                currencyList.put(currency.getCurrencyCode(), currency);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new ArrayList<Currency>(currencyList.values());
    }

    public static List<String> getCurrencyCodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Currency currency : CurrencyHelper.getCurrencyList()) {
            list.add(currency.getCurrencyCode());
        }
        return list;
    }

    public static List<String> getCurrencyNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Currency currency : CurrencyHelper.getCurrencyList()) {
            if (Build.VERSION.SDK_INT >= 19) {
                list.add(currency.getDisplayName(Locale.getDefault()));
                continue;
            }
            list.add(currency.getSymbol(Locale.getDefault()) + " (" + currency.getCurrencyCode() + ")");
        }
        return list;
    }
}

