/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.oracle;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Configuration;
import java.sql.Connection;
import java.util.function.Supplier;

public abstract class AbstractOracleQuery<T, C extends AbstractOracleQuery<T, C>>
extends AbstractSQLQuery<T, C> {
    protected static final String CONNECT_BY = "\nconnect by ";
    protected static final String CONNECT_BY_NOCYCLE_PRIOR = "\nconnect by nocycle prior ";
    protected static final String CONNECT_BY_PRIOR = "\nconnect by prior ";
    protected static final String ORDER_SIBLINGS_BY = "\norder siblings by ";
    protected static final String START_WITH = "\nstart with ";

    public AbstractOracleQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public AbstractOracleQuery(Supplier<Connection> connProvider, Configuration configuration, QueryMetadata metadata) {
        super(connProvider, configuration, metadata);
    }

    public C connectByPrior(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_PRIOR, (Expression)cond));
    }

    public C connectBy(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY, (Expression)cond));
    }

    public C connectByNocyclePrior(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_NOCYCLE_PRIOR, (Expression)cond));
    }

    public <A> C startWith(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, START_WITH, (Expression)cond));
    }

    public C orderSiblingsBy(Expression<?> path) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, ORDER_SIBLINGS_BY, (Expression)path));
    }
}

