/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.locationtech.jts;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.locationtech.jts.JTSGeometryExpressions;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;

public abstract class JTSGeometryExpression<T extends Geometry>
extends SimpleExpression<T> {
    private static final long serialVersionUID = -1183228394472681995L;
    @Nullable
    private volatile transient NumberExpression<Integer> dimension;
    @Nullable
    private volatile transient NumberExpression<Integer> coordinateDimension;
    @Nullable
    private volatile transient NumberExpression<Integer> spatialDimension;
    @Nullable
    private volatile transient NumberExpression<Integer> srid;
    @Nullable
    private volatile transient StringExpression geometryType;
    @Nullable
    private volatile transient StringExpression text;
    @Nullable
    private volatile transient JTSGeometryExpression<Geometry> envelope;
    @Nullable
    private volatile transient JTSGeometryExpression<Geometry> boundary;
    @Nullable
    private volatile transient JTSGeometryExpression<Geometry> convexHull;
    @Nullable
    private volatile transient BooleanExpression empty;
    @Nullable
    private volatile transient BooleanExpression simple;
    @Nullable
    private volatile transient BooleanExpression threed;
    @Nullable
    private volatile transient BooleanExpression measured;
    private volatile transient SimpleExpression<byte[]> binary;

    public JTSGeometryExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Integer> dimension() {
        if (this.dimension == null) {
            this.dimension = Expressions.numberOperation(Integer.class, (Operator)SpatialOps.DIMENSION, (Expression[])new Expression[]{this.mixin});
        }
        return this.dimension;
    }

    public StringExpression geometryType() {
        if (this.geometryType == null) {
            this.geometryType = Expressions.stringOperation((Operator)SpatialOps.GEOMETRY_TYPE, (Expression[])new Expression[]{this.mixin});
        }
        return this.geometryType;
    }

    public NumberExpression<Integer> srid() {
        if (this.srid == null) {
            this.srid = Expressions.numberOperation(Integer.class, (Operator)SpatialOps.SRID, (Expression[])new Expression[]{this.mixin});
        }
        return this.srid;
    }

    public JTSGeometryExpression<Geometry> envelope() {
        if (this.envelope == null) {
            this.envelope = JTSGeometryExpressions.geometryOperation(SpatialOps.ENVELOPE, this.mixin);
        }
        return this.envelope;
    }

    public StringExpression asText() {
        if (this.text == null) {
            this.text = Expressions.stringOperation((Operator)SpatialOps.AS_TEXT, (Expression[])new Expression[]{this.mixin});
        }
        return this.text;
    }

    public SimpleExpression<byte[]> asBinary() {
        if (this.binary == null) {
            this.binary = Expressions.operation(byte[].class, (Operator)SpatialOps.AS_BINARY, (Expression[])new Expression[]{this.mixin});
        }
        return this.binary;
    }

    public BooleanExpression isEmpty() {
        if (this.empty == null) {
            this.empty = Expressions.booleanOperation((Operator)SpatialOps.IS_EMPTY, (Expression[])new Expression[]{this.mixin});
        }
        return this.empty;
    }

    public BooleanExpression isSimple() {
        if (this.simple == null) {
            this.simple = Expressions.booleanOperation((Operator)SpatialOps.IS_SIMPLE, (Expression[])new Expression[]{this.mixin});
        }
        return this.simple;
    }

    public JTSGeometryExpression<Geometry> boundary() {
        if (this.boundary == null) {
            this.boundary = JTSGeometryExpressions.geometryOperation(SpatialOps.BOUNDARY, this.mixin);
        }
        return this.boundary;
    }

    public BooleanExpression eq(Geometry right) {
        return this.eq((Expression<? super T>)ConstantImpl.create((Object)right));
    }

    public BooleanExpression eq(Expression<? super T> right) {
        return Expressions.booleanOperation((Operator)SpatialOps.EQUALS, (Expression[])new Expression[]{this.mixin, right});
    }

    public BooleanExpression disjoint(Geometry geometry) {
        return this.disjoint((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression disjoint(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.DISJOINT, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression intersects(Geometry geometry) {
        return this.intersects((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression intersects(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.INTERSECTS, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression touches(Geometry geometry) {
        return this.touches((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression touches(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.TOUCHES, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression crosses(Geometry geometry) {
        return this.crosses((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression crosses(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.CROSSES, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression within(Geometry geometry) {
        return this.within((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression within(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.WITHIN, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression contains(Geometry geometry) {
        return this.contains((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression contains(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.CONTAINS, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression overlaps(Geometry geometry) {
        return this.overlaps((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public BooleanExpression overlaps(Expression<? extends Geometry> geometry) {
        return Expressions.booleanOperation((Operator)SpatialOps.OVERLAPS, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public BooleanExpression relate(Geometry geometry, String matrix) {
        return this.relate((Expression<Geometry>)ConstantImpl.create((Object)geometry), matrix);
    }

    public BooleanExpression relate(Expression<? extends Geometry> geometry, String matrix) {
        return Expressions.booleanOperation((Operator)SpatialOps.RELATE, (Expression[])new Expression[]{this.mixin, geometry, ConstantImpl.create((Object)matrix)});
    }

    public NumberExpression<Double> distance(Geometry geometry) {
        return this.distance((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public NumberExpression<Double> distance(Expression<? extends Geometry> geometry) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.DISTANCE, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public NumberExpression<Double> distanceSphere(Expression<? extends Geometry> geometry) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.DISTANCE_SPHERE, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public NumberExpression<Double> distanceSpheroid(Expression<? extends Geometry> geometry) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.DISTANCE_SPHEROID, (Expression[])new Expression[]{this.mixin, geometry});
    }

    public JTSGeometryExpression<Geometry> buffer(double distance) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.BUFFER, new Expression[]{this.mixin, ConstantImpl.create((Object)distance)});
    }

    public JTSGeometryExpression<Geometry> convexHull() {
        if (this.convexHull == null) {
            this.convexHull = JTSGeometryExpressions.geometryOperation(SpatialOps.CONVEXHULL, this.mixin);
        }
        return this.convexHull;
    }

    public JTSGeometryExpression<Geometry> intersection(Geometry geometry) {
        return this.intersection((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> intersection(Expression<? extends Geometry> geometry) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.INTERSECTION, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> union(Geometry geometry) {
        return this.union((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> union(Expression<? extends Geometry> geometry) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.UNION, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> difference(Geometry geometry) {
        return this.difference((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> difference(Expression<? extends Geometry> geometry) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.DIFFERENCE, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> symDifference(Geometry geometry) {
        return this.symDifference((Expression<Geometry>)ConstantImpl.create((Object)geometry));
    }

    public JTSGeometryExpression<Geometry> symDifference(Expression<? extends Geometry> geometry) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.SYMDIFFERENCE, this.mixin, geometry);
    }

    public JTSGeometryExpression<Geometry> transform(int srid) {
        return JTSGeometryExpressions.geometryOperation(SpatialOps.TRANSFORM, new Expression[]{this.mixin, ConstantImpl.create((int)srid)});
    }
}

