/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.jts;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.jts.JTSGeometryExpression;
import com.querydsl.spatial.jts.JTSGeometryExpressions;
import com.querydsl.spatial.jts.JTSPointExpression;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import javax.annotation.Nullable;

public abstract class JTSCurveExpression<T extends Geometry>
extends JTSGeometryExpression<T> {
    private static final long serialVersionUID = 6139188586728676033L;
    @Nullable
    private volatile transient NumberExpression<Double> length;
    @Nullable
    private volatile transient JTSPointExpression<Point> startPoint;
    @Nullable
    private volatile transient JTSPointExpression<Point> endPoint;
    @Nullable
    private volatile transient BooleanExpression closed;
    @Nullable
    private volatile transient BooleanExpression ring;

    public JTSCurveExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> length() {
        if (this.length == null) {
            this.length = Expressions.numberOperation(Double.class, (Operator)SpatialOps.LENGTH, (Expression[])new Expression[]{this.mixin});
        }
        return this.length;
    }

    public JTSPointExpression<Point> startPoint() {
        if (this.startPoint == null) {
            this.startPoint = JTSGeometryExpressions.pointOperation(SpatialOps.START_POINT, this.mixin);
        }
        return this.startPoint;
    }

    public JTSPointExpression<Point> endPoint() {
        if (this.endPoint == null) {
            this.endPoint = JTSGeometryExpressions.pointOperation(SpatialOps.END_POINT, this.mixin);
        }
        return this.endPoint;
    }

    public BooleanExpression isClosed() {
        if (this.closed == null) {
            this.closed = Expressions.booleanOperation((Operator)SpatialOps.IS_CLOSED, (Expression[])new Expression[]{this.mixin});
        }
        return this.closed;
    }

    public BooleanExpression isRing() {
        if (this.ring == null) {
            this.ring = Expressions.booleanOperation((Operator)SpatialOps.IS_RING, (Expression[])new Expression[]{this.mixin});
        }
        return this.ring;
    }
}

