/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.GeometryExpressions;
import com.querydsl.spatial.PolygonExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.SurfaceExpression;
import javax.annotation.Nullable;
import org.geolatte.geom.PolyHedralSurface;

public abstract class PolyhedralSurfaceExpression<T extends PolyHedralSurface>
extends SurfaceExpression<T> {
    private static final long serialVersionUID = -6732418858467327780L;
    @Nullable
    private volatile transient NumberExpression<Integer> numPatches;
    @Nullable
    private volatile transient BooleanExpression closed;

    public PolyhedralSurfaceExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Integer> numPatches() {
        if (this.numPatches == null) {
            this.numPatches = Expressions.numberOperation(Integer.class, (Operator)SpatialOps.NUM_SURFACES, (Expression[])new Expression[]{this.mixin});
        }
        return this.numPatches;
    }

    public PolygonExpression<?> patchN(int n) {
        return GeometryExpressions.polygonOperation(SpatialOps.SURFACE, new Expression[]{this.mixin, ConstantImpl.create((int)n)});
    }

    public BooleanExpression isClosed() {
        if (this.closed == null) {
            this.closed = Expressions.booleanOperation((Operator)SpatialOps.IS_CLOSED, (Expression[])new Expression[]{this.mixin});
        }
        return this.closed;
    }
}

