/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.GeometryCollectionExpression;
import com.querydsl.spatial.GeometryExpressions;
import com.querydsl.spatial.PointExpression;
import com.querydsl.spatial.SpatialOps;
import javax.annotation.Nullable;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.Point;

public abstract class MultiSurfaceExpression<T extends GeometryCollection>
extends GeometryCollectionExpression<T> {
    private static final long serialVersionUID = 4133386816772862010L;
    @Nullable
    private volatile transient PointExpression<Point> centroid;
    @Nullable
    private volatile transient PointExpression<Point> pointOnSurface;
    @Nullable
    private volatile transient NumberExpression<Double> area;

    public MultiSurfaceExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> area() {
        if (this.area == null) {
            this.area = Expressions.numberOperation(Double.class, (Operator)SpatialOps.AREA, (Expression[])new Expression[]{this.mixin});
        }
        return this.area;
    }

    public PointExpression<Point> centroid() {
        if (this.centroid == null) {
            this.centroid = GeometryExpressions.pointOperation(SpatialOps.CENTROID, this.mixin);
        }
        return this.centroid;
    }

    public PointExpression<Point> pointOnSurface() {
        if (this.pointOnSurface == null) {
            this.pointOnSurface = GeometryExpressions.pointOperation(SpatialOps.POINT_ON_SURFACE, this.mixin);
        }
        return this.pointOnSurface;
    }
}

