/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb.document;

import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Fetchable;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.mongodb.document.AbstractMongodbQuery;
import com.querydsl.mongodb.document.MongodbDocumentSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFetchableMongodbQuery<K, Q extends AbstractFetchableMongodbQuery<K, Q>>
extends AbstractMongodbQuery<Q>
implements Fetchable<K> {
    private final Function<Document, K> transformer;
    private final MongoCollection<Document> collection;

    public AbstractFetchableMongodbQuery(MongoCollection<Document> collection, Function<Document, K> transformer, MongodbDocumentSerializer serializer) {
        super(serializer);
        this.transformer = transformer;
        this.collection = collection;
    }

    public CloseableIterator<K> iterate(Path<?> ... paths) {
        this.getQueryMixin().setProjection(paths);
        return this.iterate();
    }

    public CloseableIterator<K> iterate() {
        FindIterable<Document> cursor = this.createCursor();
        final MongoCursor iterator = cursor.iterator();
        return new CloseableIterator<K>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public K next() {
                return AbstractFetchableMongodbQuery.this.transformer.apply(iterator.next());
            }

            public void remove() {
            }

            public void close() {
                iterator.close();
            }
        };
    }

    public List<K> fetch(Path<?> ... paths) {
        this.getQueryMixin().setProjection(paths);
        return this.fetch();
    }

    public List<K> fetch() {
        try {
            FindIterable<Document> cursor = this.createCursor();
            ArrayList<K> results = new ArrayList<K>();
            for (Document document : cursor) {
                results.add(this.transformer.apply(document));
            }
            return results;
        }
        catch (AbstractMongodbQuery.NoResults ex) {
            return Collections.emptyList();
        }
    }

    public K fetchFirst(Path<?> ... paths) {
        this.getQueryMixin().setProjection(paths);
        return this.fetchFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public K fetchFirst() {
        try {
            FindIterable c = this.createCursor().limit(1);
            try (MongoCursor iterator = c.iterator();){
                if (iterator.hasNext()) {
                    K k = this.transformer.apply((Document)iterator.next());
                    return k;
                }
                K k = null;
                return k;
            }
        }
        catch (AbstractMongodbQuery.NoResults ex) {
            return null;
        }
    }

    public K fetchOne(Path<?> ... paths) {
        this.getQueryMixin().setProjection(paths);
        return this.fetchOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public K fetchOne() {
        try {
            Long limit = this.getQueryMixin().getMetadata().getModifiers().getLimit();
            if (limit == null) {
                limit = 2L;
            }
            FindIterable c = this.createCursor().limit(limit.intValue());
            try (MongoCursor iterator = c.iterator();){
                if (iterator.hasNext()) {
                    K rv = this.transformer.apply((Document)iterator.next());
                    if (iterator.hasNext()) {
                        throw new NonUniqueResultException();
                    }
                    K k = rv;
                    return k;
                }
                K k = null;
                return k;
            }
        }
        catch (AbstractMongodbQuery.NoResults ex) {
            return null;
        }
    }

    public QueryResults<K> fetchResults(Path<?> ... paths) {
        this.getQueryMixin().setProjection(paths);
        return this.fetchResults();
    }

    public QueryResults<K> fetchResults() {
        try {
            long total = this.fetchCount();
            if (total > 0L) {
                return new QueryResults(this.fetch(), this.getQueryMixin().getMetadata().getModifiers(), total);
            }
            return QueryResults.emptyResults();
        }
        catch (AbstractMongodbQuery.NoResults ex) {
            return QueryResults.emptyResults();
        }
    }

    public long fetchCount() {
        try {
            Predicate filter = this.createFilter(this.getQueryMixin().getMetadata());
            return this.collection.count((Bson)this.createQuery(filter));
        }
        catch (AbstractMongodbQuery.NoResults ex) {
            return 0L;
        }
    }

    protected FindIterable<Document> createCursor() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        Predicate filter = this.createFilter(metadata);
        return this.createCursor(this.collection, filter, metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected FindIterable<Document> createCursor(MongoCollection<Document> collection, @Nullable Predicate where, Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        ReadPreference readPreference = this.getReadPreference();
        MongoCollection collectionToUse = readPreference != null ? collection.withReadPreference(readPreference) : collection;
        FindIterable cursor = collectionToUse.find((Bson)this.createQuery(where)).projection((Bson)this.createProjection(projection));
        Integer limit = modifiers.getLimitAsInteger();
        Integer offset = modifiers.getOffsetAsInteger();
        if (limit != null) {
            cursor = cursor.limit(limit.intValue());
        }
        if (offset != null) {
            cursor = cursor.skip(offset.intValue());
        }
        if (orderBy.size() > 0) {
            cursor = cursor.sort((Bson)this.getSerializer().toSort(orderBy));
        }
        return cursor;
    }

    protected abstract MongoCollection<Document> getCollection(Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Object> getIds(Class<?> targetType, Predicate condition) {
        MongoCollection<Document> collection = this.getCollection(targetType);
        FindIterable<Document> cursor = this.createCursor(collection, condition, null, QueryModifiers.EMPTY, Collections.emptyList());
        try (MongoCursor iterator = cursor.iterator();){
            if (iterator.hasNext()) {
                ArrayList<Object> ids = new ArrayList<Object>();
                for (Document obj : cursor) {
                    ids.add(obj.get((Object)"_id"));
                }
                Object object = ids;
                return object;
            }
            List<Object> list = Collections.emptyList();
            return list;
        }
    }
}

