/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Sets;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Templates;
import com.querydsl.jpa.DefaultQueryHandler;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.QueryHandler;
import java.util.Set;
import javax.annotation.Nullable;

public class JPQLTemplates
extends Templates {
    public static final char DEFAULT_ESCAPE = '!';
    protected static final Set<? extends Operator> OTHER_LIKE_CASES = Sets.immutableEnumSet((Enum)Ops.MATCHES, (Enum[])new Ops[]{Ops.MATCHES_IC, Ops.ENDS_WITH, Ops.ENDS_WITH_IC, Ops.LIKE_IC, Ops.LIKE_ESCAPE_IC, Ops.STARTS_WITH, Ops.STARTS_WITH_IC, Ops.STRING_CONTAINS, Ops.STRING_CONTAINS_IC});
    public static final JPQLTemplates DEFAULT = new JPQLTemplates();
    private final QueryHandler queryHandler;

    protected JPQLTemplates() {
        this('!', DefaultQueryHandler.DEFAULT);
    }

    protected JPQLTemplates(char escape) {
        this(escape, DefaultQueryHandler.DEFAULT);
    }

    protected JPQLTemplates(char escape, QueryHandler queryHandler) {
        super(escape);
        this.queryHandler = queryHandler;
        this.setPrecedence(50, new Operator[]{Ops.EQ, Ops.NE, Ops.EQ_IGNORE_CASE, Ops.BETWEEN, Ops.COL_IS_EMPTY});
        this.setPrecedence(50, OTHER_LIKE_CASES);
        this.add((Operator)Ops.CASE, "case {0} end");
        this.add((Operator)Ops.CASE_WHEN, "when {0} then {1} {2}", 0);
        this.add((Operator)Ops.CASE_ELSE, "else {0}", 0);
        this.add((Operator)Ops.AND, "{0} and {1}");
        this.add((Operator)Ops.NOT, "not {0}", 80);
        this.add((Operator)Ops.OR, "{0} or {1}");
        this.add((Operator)Ops.XNOR, "{0} xnor {1}");
        this.add((Operator)Ops.XOR, "{0} xor {1}");
        this.add((Operator)Ops.BETWEEN, "{0} between {1} and {2}");
        this.add((Operator)Ops.MathOps.SQRT, "sqrt({0})");
        this.add((Operator)Ops.MOD, "mod({0},{1})", -1);
        this.add((Operator)Ops.NE, "{0} <> {1}");
        this.add((Operator)Ops.IS_NULL, "{0} is null");
        this.add((Operator)Ops.IS_NOT_NULL, "{0} is not null");
        this.add(JPQLOps.CAST, "cast({0} as {1s})");
        this.add((Operator)Ops.NUMCAST, "cast({0} as {1s})");
        this.add(JPQLOps.MEMBER_OF, "{0} member of {1}", 50);
        this.add(JPQLOps.NOT_MEMBER_OF, "{0} not member of {1}", 50);
        this.add((Operator)Ops.IN, "{0} in {1}");
        this.add((Operator)Ops.NOT_IN, "{0} not in {1}");
        this.add((Operator)Ops.COL_IS_EMPTY, "{0} is empty");
        this.add((Operator)Ops.COL_SIZE, "size({0})");
        this.add((Operator)Ops.ARRAY_SIZE, "size({0})");
        this.add((Operator)Ops.LIKE, "{0} like {1} escape '" + escape + "'");
        this.add((Operator)Ops.CONCAT, "concat({0},{1})", -1);
        this.add((Operator)Ops.MATCHES, "{0} like {1}  escape '" + escape + "'");
        this.add((Operator)Ops.MATCHES_IC, "{0} like {1} escape '" + escape + "'");
        this.add((Operator)Ops.LOWER, "lower({0})");
        this.add((Operator)Ops.SUBSTR_1ARG, "substring({0},{1+'1's})", 40);
        this.add((Operator)Ops.SUBSTR_2ARGS, "substring({0},{1+'1's},{2-1s})", 40);
        this.add((Operator)Ops.TRIM, "trim({0})");
        this.add((Operator)Ops.UPPER, "upper({0})");
        this.add((Operator)Ops.EQ_IGNORE_CASE, "{0l} = {1l}");
        this.add((Operator)Ops.CHAR_AT, "cast(substring({0},{1+'1's},1) as char)", 40);
        this.add((Operator)Ops.STRING_IS_EMPTY, "length({0}) = 0");
        this.add((Operator)Ops.STRING_CONTAINS, "{0} like {%1%} escape '" + escape + "'");
        this.add((Operator)Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%} escape '" + escape + "'");
        this.add((Operator)Ops.ENDS_WITH, "{0} like {%1} escape '" + escape + "'");
        this.add((Operator)Ops.ENDS_WITH_IC, "{0l} like {%%1} escape '" + escape + "'");
        this.add((Operator)Ops.STARTS_WITH, "{0} like {1%} escape '" + escape + "'");
        this.add((Operator)Ops.STARTS_WITH_IC, "{0l} like {1%%} escape '" + escape + "'");
        this.add((Operator)Ops.INDEX_OF, "locate({1},{0})-1", 40);
        this.add((Operator)Ops.INDEX_OF_2ARGS, "locate({1},{0},{2+'1's})-1", 40);
        this.add((Operator)Ops.DateTimeOps.SYSDATE, "sysdate");
        this.add((Operator)Ops.DateTimeOps.CURRENT_DATE, "current_date");
        this.add((Operator)Ops.DateTimeOps.CURRENT_TIME, "current_time");
        this.add((Operator)Ops.DateTimeOps.CURRENT_TIMESTAMP, "current_timestamp");
        this.add((Operator)Ops.DateTimeOps.MILLISECOND, "0");
        this.add((Operator)Ops.DateTimeOps.SECOND, "second({0})");
        this.add((Operator)Ops.DateTimeOps.MINUTE, "minute({0})");
        this.add((Operator)Ops.DateTimeOps.HOUR, "hour({0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_MONTH, "day({0})");
        this.add((Operator)Ops.DateTimeOps.MONTH, "month({0})");
        this.add((Operator)Ops.DateTimeOps.YEAR, "year({0})");
        this.add((Operator)Ops.DateTimeOps.YEAR_MONTH, "year({0}) * 100 + month({0})", 40);
        this.add((Operator)Ops.DateTimeOps.YEAR_WEEK, "year({0}) * 100 + week({0})", 40);
        this.add((Operator)PathType.PROPERTY, "{0}.{1s}");
        this.add((Operator)PathType.VARIABLE, "{0s}");
        this.add((Operator)Ops.CASE_EQ, "case {1} end");
        this.add((Operator)Ops.CASE_EQ_WHEN, "when {0} = {1} then {2} {3}", 0);
        this.add((Operator)Ops.CASE_EQ_ELSE, "else {0}", 0);
        this.add((Operator)Ops.INSTANCE_OF, "type({0}) = {1}");
        this.add(JPQLOps.TYPE, "type({0})");
        this.add(JPQLOps.INDEX, "index({0})");
        this.add(JPQLOps.TREAT, "treat({0} as {1s})");
        this.add(JPQLOps.KEY, "key({0})");
        this.add(JPQLOps.VALUE, "value({0})");
    }

    public boolean wrapElements(Operator operator) {
        return false;
    }

    public String getTypeForCast(Class<?> cl) {
        return cl.getSimpleName().toLowerCase();
    }

    @Deprecated
    public boolean isEnumInPathSupported() {
        return true;
    }

    public boolean isPathInEntitiesSupported() {
        return true;
    }

    @Nullable
    public String getExistsProjection() {
        return null;
    }

    public boolean wrapConstant(Object constant) {
        return false;
    }

    public boolean isWithForOn() {
        return false;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public boolean isCaseWithLiterals() {
        return false;
    }

    public String asLiteral(Object constant) {
        if (constant instanceof Boolean) {
            return constant.toString();
        }
        if (constant instanceof Number) {
            return constant.toString();
        }
        if (constant instanceof String) {
            return "'" + this.escapeLiteral(constant.toString()) + "'";
        }
        if (constant instanceof Enum) {
            return constant.getClass().getName() + "." + ((Enum)constant).name();
        }
        return "'" + constant.toString() + "'";
    }

    private String escapeLiteral(String str) {
        StringBuilder builder = new StringBuilder();
        for (char ch : str.toCharArray()) {
            if (ch == '\n') {
                builder.append("\\n");
                continue;
            }
            if (ch == '\r') {
                builder.append("\\r");
                continue;
            }
            if (ch == '\'') {
                builder.append("''");
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

