/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ImmutableMap;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.jpa.DefaultQueryHandler;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.QueryHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class EclipseLinkTemplates
extends JPQLTemplates {
    private static final QueryHandler QUERY_HANDLER;
    public static final EclipseLinkTemplates DEFAULT;
    private final Map<Class<?>, String> typeNames;

    public EclipseLinkTemplates() {
        this('!');
    }

    public EclipseLinkTemplates(char escape) {
        super(escape, QUERY_HANDLER);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Short.class, (Object)"short");
        builder.put(Integer.class, (Object)"integer");
        builder.put(Long.class, (Object)"bigint");
        builder.put(BigInteger.class, (Object)"bigint");
        builder.put(Float.class, (Object)"float");
        builder.put(Double.class, (Object)"double");
        builder.put(BigDecimal.class, (Object)"double");
        this.typeNames = builder.build();
        this.add((Operator)Ops.CHAR_AT, "substring({0},{1}+1,1)");
        this.add(JPQLOps.CAST, "cast({0} {1s})");
        this.add((Operator)Ops.STRING_CAST, "trim(cast({0} char(128)))");
        this.add((Operator)Ops.NUMCAST, "cast({0} {1s})");
        this.add((Operator)Ops.DateTimeOps.MILLISECOND, "extract(millisecond from {0})");
        this.add((Operator)Ops.DateTimeOps.SECOND, "extract(second from {0})");
        this.add((Operator)Ops.DateTimeOps.MINUTE, "extract(minute from {0})");
        this.add((Operator)Ops.DateTimeOps.HOUR, "extract(hour from {0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_WEEK, "extract(day_of_week from {0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_MONTH, "extract(day from {0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_YEAR, "extract(day_of_year from {0})");
        this.add((Operator)Ops.DateTimeOps.WEEK, "extract(week from {0})");
        this.add((Operator)Ops.DateTimeOps.MONTH, "extract(month from {0})");
        this.add((Operator)Ops.DateTimeOps.YEAR, "extract(year from {0})");
        this.add((Operator)Ops.DateTimeOps.YEAR_MONTH, "extract(year from {0}) * 100 + extract(month from {0})");
        this.add((Operator)Ops.DateTimeOps.YEAR_WEEK, "extract(year from {0}) * 100 + extract(week from {0})");
    }

    @Override
    public String getTypeForCast(Class<?> cl) {
        return this.typeNames.get(cl);
    }

    @Override
    public boolean isPathInEntitiesSupported() {
        return false;
    }

    static {
        QueryHandler instance;
        try {
            instance = (QueryHandler)Class.forName("com.querydsl.jpa.EclipseLinkHandler").newInstance();
        }
        catch (NoClassDefFoundError e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        catch (Exception e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        QUERY_HANDLER = instance;
        DEFAULT = new EclipseLinkTemplates();
    }
}

