/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate.sql;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.AbstractSQLQuery;
import com.querydsl.jpa.FactoryExpressionTransformer;
import com.querydsl.jpa.NativeSQLSerializer;
import com.querydsl.jpa.ScrollableResultsIterator;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.hibernate.StatelessSessionHolder;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLSerializer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractHibernateSQLQuery<T, Q extends AbstractHibernateSQLQuery<T, Q>>
extends AbstractSQLQuery<T, Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateSQLQuery.class);
    protected Boolean cacheable;
    protected Boolean readOnly;
    protected String cacheRegion;
    protected int fetchSize = 0;
    private final SessionHolder session;
    protected int timeout = 0;

    public AbstractHibernateSQLQuery(Session session, Configuration conf) {
        this(new DefaultSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(StatelessSession session, Configuration conf) {
        this(new StatelessSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(SessionHolder session, Configuration conf, QueryMetadata metadata) {
        super(metadata, conf);
        this.session = session;
    }

    public Query createQuery() {
        return this.createQuery(false);
    }

    private Query createQuery(boolean forCount) {
        NativeSQLSerializer serializer = (NativeSQLSerializer)this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString, serializer.getConstantToLabel());
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((Query)query, serializer.getConstantToLabel(), this.queryMixin.getMetadata().getParams());
        if (!forCount) {
            ListMultimap<Expression<?>, String> aliases = serializer.getAliases();
            HashSet used = Sets.newHashSet();
            Expression projection = this.queryMixin.getMetadata().getProjection();
            if (projection instanceof FactoryExpression) {
                block0: for (Expression expr : ((FactoryExpression)projection).getArgs()) {
                    if (this.isEntityExpression(expr)) {
                        query.addEntity(this.extractEntityExpression(expr).toString(), expr.getType());
                        continue;
                    }
                    if (!aliases.containsKey((Object)expr)) continue;
                    for (String scalar : aliases.get((Object)expr)) {
                        if (used.contains(scalar)) continue;
                        query.addScalar(scalar);
                        used.add(scalar);
                        continue block0;
                    }
                }
            } else if (this.isEntityExpression(projection)) {
                query.addEntity(this.extractEntityExpression(projection).toString(), projection.getType());
            } else if (aliases.containsKey((Object)projection)) {
                for (String scalar : aliases.get((Object)projection)) {
                    if (used.contains(scalar)) continue;
                    query.addScalar(scalar);
                    used.add(scalar);
                    break;
                }
            }
            if (projection instanceof FactoryExpression) {
                query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection));
            }
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    protected SQLSerializer createSerializer() {
        return new NativeSQLSerializer(this.configuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> fetch() {
        try {
            List list = this.createQuery().list();
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<T> iterate() {
        try {
            Query query = this.createQuery();
            ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
            ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(results);
            return scrollableResultsIterator;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults<T> fetchResults() {
        try {
            Query query = this.createQuery(true);
            long total = ((Number)query.uniqueResult()).longValue();
            if (total > 0L) {
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                query = this.createQuery(false);
                List list = query.list();
                QueryResults queryResults = new QueryResults(list, modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        String normalizedQuery = queryString.replace('\n', ' ');
        MDC.put((String)"querydsl.query", (String)normalizedQuery);
        MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
        if (logger.isDebugEnabled()) {
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.cleanupMDC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fetchOne() {
        try {
            Query query = this.createQuery();
            Object object = this.uniqueResult(query);
            return (T)object;
        }
        finally {
            this.reset();
        }
    }

    @Nullable
    private Object uniqueResult(Query query) {
        try {
            return query.uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }

    protected void clone(Q query) {
        super.clone(query);
        this.cacheable = ((AbstractHibernateSQLQuery)((Object)query)).cacheable;
        this.cacheRegion = ((AbstractHibernateSQLQuery)((Object)query)).cacheRegion;
        this.fetchSize = ((AbstractHibernateSQLQuery)((Object)query)).fetchSize;
        this.readOnly = ((AbstractHibernateSQLQuery)((Object)query)).readOnly;
        this.timeout = ((AbstractHibernateSQLQuery)((Object)query)).timeout;
    }

    protected abstract Q clone(SessionHolder var1);

    public Q clone(Session session) {
        return this.clone(new DefaultSessionHolder(session));
    }

    public Q clone(StatelessSession statelessSession) {
        return this.clone(new StatelessSessionHolder(statelessSession));
    }

    public Q clone() {
        return this.clone(this.session);
    }
}

