/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.dsl.Param;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.ByteType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.Type;

public final class HibernateUtil {
    private static final Map<Class<?>, Type> TYPES = new HashMap();

    private HibernateUtil() {
    }

    public static void setConstants(Query query, Map<Object, String> constants, Map<ParamExpression<?>, Object> params) {
        for (Map.Entry<Object, String> entry : constants.entrySet()) {
            String key = entry.getValue();
            Object val = entry.getKey();
            if (Param.class.isInstance(val) && (val = params.get(val)) == null) {
                throw new ParamNotSetException((ParamExpression)((Param)entry.getKey()));
            }
            HibernateUtil.setValue(query, key, val);
        }
    }

    private static void setValue(Query query, String key, Object val) {
        if (val instanceof Collection) {
            query.setParameterList(key, (Collection)val);
        } else if (val.getClass().isArray()) {
            query.setParameterList(key, (Object[])val);
        } else if (TYPES.containsKey(val.getClass())) {
            query.setParameter(key, val, TYPES.get(val.getClass()));
        } else {
            query.setParameter(key, val);
        }
    }

    static {
        TYPES.put(Byte.class, (Type)new ByteType());
        TYPES.put(Short.class, (Type)new ShortType());
        TYPES.put(Integer.class, (Type)new IntegerType());
        TYPES.put(Long.class, (Type)new LongType());
        TYPES.put(BigInteger.class, (Type)new BigIntegerType());
        TYPES.put(Double.class, (Type)new DoubleType());
        TYPES.put(Float.class, (Type)new FloatType());
        TYPES.put(BigDecimal.class, (Type)new BigDecimalType());
    }
}

