/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Maps;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPQLOps;
import java.util.Map;
import javax.annotation.Nullable;

class JPAListAccessVisitor
extends ReplaceVisitor<Void> {
    private final QueryMetadata metadata;
    private final Map<Path<?>, Path<?>> replacements = Maps.newHashMap();

    public JPAListAccessVisitor(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.LISTVALUE || pathMetadata.getPathType() == PathType.LISTVALUE_CONSTANT) {
            Path replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path parent = pathMetadata.getParent();
                replacement = ExpressionUtils.path((Class)expr.getType(), (String)ExpressionUtils.createRootVariable((Path)parent, (int)this.replacements.size()));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as((Expression)parent, (Path)replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation(Integer.class, (Operator)JPQLOps.INDEX, (Expression[])new Expression[]{replacement}), (Expression)ExpressionUtils.toExpression((Object)pathMetadata.getElement())));
                this.replacements.put(expr, replacement);
            }
            return replacement;
        }
        return super.visit(expr, (Object)context);
    }
}

