/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Maps;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.ParameterizedExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPQLOps;
import java.util.Map;
import javax.annotation.Nullable;

class JPAMapAccessVisitor
extends ReplaceVisitor<Void> {
    private final QueryMetadata metadata;
    private final Map<Path<?>, Path<?>> replacements = Maps.newHashMap();

    public JPAMapAccessVisitor(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public Expression<?> visit(Operation<?> expr, @Nullable Void context) {
        if (expr.getOperator() == Ops.CONTAINS_KEY) {
            ParameterizedExpression map = (ParameterizedExpression)expr.getArg(0);
            Expression key = expr.getArg(1);
            Path replacement = ExpressionUtils.path((Class)map.getParameter(1), (String)ExpressionUtils.createRootVariable((Path)((Path)map), (int)Math.abs(expr.hashCode())));
            this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as((Expression)map, (Path)replacement));
            this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation((Class)map.getParameter(0), (Operator)JPQLOps.KEY, (Expression[])new Expression[]{replacement}), (Expression)key));
            return ExpressionUtils.isNotNull((Expression)replacement);
        }
        if (expr.getOperator() == Ops.CONTAINS_VALUE) {
            ParameterizedExpression map = (ParameterizedExpression)expr.getArg(0);
            Expression value = expr.getArg(1);
            return Expressions.predicate((Operator)JPQLOps.MEMBER_OF, (Expression[])new Expression[]{value, map});
        }
        return super.visit(expr, (Object)context);
    }

    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.MAPVALUE || pathMetadata.getPathType() == PathType.MAPVALUE_CONSTANT) {
            Path replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path parent = pathMetadata.getParent();
                ParameterizedExpression parExpr = (ParameterizedExpression)parent;
                replacement = ExpressionUtils.path((Class)parExpr.getParameter(1), (String)ExpressionUtils.createRootVariable((Path)parent, (int)this.replacements.size()));
                this.metadata.addJoin(JoinType.LEFTJOIN, ExpressionUtils.as((Expression)parent, (Path)replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation((Class)parExpr.getParameter(0), (Operator)JPQLOps.KEY, (Expression[])new Expression[]{replacement}), (Expression)ExpressionUtils.toExpression((Object)pathMetadata.getElement())));
                this.replacements.put(expr, replacement);
            }
            return replacement;
        }
        return super.visit(expr, (Object)context);
    }
}

