/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group.guava;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.FetchableQuery;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTransformer;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.GroupImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Projections;

public class GroupByMultimap<K, V, R extends Multimap<K, V>>
extends AbstractGroupByTransformer<K, R> {
    GroupByMultimap(Expression<K> key, Expression<?> ... expressions) {
        super(key, expressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R transform(FetchableQuery<?, ?> query) {
        LinkedHashMultimap groups = LinkedHashMultimap.create();
        FactoryExpression expr = FactoryExpressionUtils.wrap((FactoryExpression)Projections.tuple((Expression[])this.expressions));
        boolean hasGroups = false;
        for (Expression e : expr.getArgs()) {
            hasGroups |= e instanceof GroupExpression;
        }
        if (hasGroups) {
            expr = GroupByMultimap.withoutGroupExpressions((FactoryExpression)expr);
        }
        try (CloseableIterator iter = query.select((Expression)expr).iterate();){
            while (iter.hasNext()) {
                Object[] row = ((Tuple)iter.next()).toArray();
                Object groupId = row[0];
                GroupImpl group = new GroupImpl(this.groupExpressions, this.maps);
                groups.put(groupId, (Object)group);
                group.add(row);
            }
        }
        return this.transform((Multimap<K, Group>)groups);
    }

    protected R transform(Multimap<K, Group> groups) {
        return (R)groups;
    }
}

