/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.SubQueryExpressionImpl;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ExpressionUtilsTest {
    private static final StringPath str = Expressions.stringPath((String)"str");
    private static final StringPath str2 = Expressions.stringPath((String)"str2");

    @Test
    public void likeToRegex() {
        Assert.assertEquals((Object)".*", (Object)this.regex((Expression<String>)ConstantImpl.create((Object)"%")));
        Assert.assertEquals((Object)"^abc.*", (Object)this.regex((Expression<String>)ConstantImpl.create((Object)"abc%")));
        Assert.assertEquals((Object)".*abc$", (Object)this.regex((Expression<String>)ConstantImpl.create((Object)"%abc")));
        Assert.assertEquals((Object)"^.$", (Object)this.regex((Expression<String>)ConstantImpl.create((Object)"_")));
        StringPath path = Expressions.stringPath((String)"path");
        Assert.assertEquals((Object)"path + .*", (Object)this.regex((Expression<String>)path.append("%")));
        Assert.assertEquals((Object)".* + path", (Object)this.regex((Expression<String>)path.prepend("%")));
        Assert.assertEquals((Object)"path + .", (Object)this.regex((Expression<String>)path.append("_")));
        Assert.assertEquals((Object)". + path", (Object)this.regex((Expression<String>)path.prepend("_")));
    }

    @Test
    @Ignore
    public void likeToRegexSpeed() {
        StringPath path = Expressions.stringPath((String)"path");
        int iterations = 1000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            this.regex((Expression<String>)ConstantImpl.create((Object)"%"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"abc%"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"%abc"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"_"));
            this.regex((Expression<String>)path.append("%"));
            this.regex((Expression<String>)path.prepend("%"));
            this.regex((Expression<String>)path.append("_"));
            this.regex((Expression<String>)path.prepend("_"));
        }
        long duration = System.currentTimeMillis() - start;
        System.err.println(duration);
    }

    @Test
    public void likeToRegex_escape() {
        Assert.assertEquals((Object)"^\\.$", (Object)this.regex((Expression<String>)ConstantImpl.create((Object)".")));
    }

    @Test
    public void regexToLike() {
        Assert.assertEquals((Object)"%", (Object)this.like((Expression<String>)ConstantImpl.create((Object)".*")));
        Assert.assertEquals((Object)"_", (Object)this.like((Expression<String>)ConstantImpl.create((Object)".")));
        Assert.assertEquals((Object)".", (Object)this.like((Expression<String>)ConstantImpl.create((Object)"\\.")));
        StringPath path = Expressions.stringPath((String)"path");
        Assert.assertEquals((Object)"path + %", (Object)this.like((Expression<String>)path.append(".*")));
        Assert.assertEquals((Object)"% + path", (Object)this.like((Expression<String>)path.prepend(".*")));
        Assert.assertEquals((Object)"path + _", (Object)this.like((Expression<String>)path.append(".")));
        Assert.assertEquals((Object)"_ + path", (Object)this.like((Expression<String>)path.prepend(".")));
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail() {
        this.like((Expression<String>)ConstantImpl.create((Object)"a*"));
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail2() {
        this.like((Expression<String>)ConstantImpl.create((Object)"\\d"));
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail3() {
        this.like((Expression<String>)ConstantImpl.create((Object)"[ab]"));
    }

    @Test
    @Ignore
    public void regexToLikeSpeed() {
        StringPath path = Expressions.stringPath((String)"path");
        int iterations = 1000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            this.like((Expression<String>)ConstantImpl.create((Object)".*"));
            this.like((Expression<String>)ConstantImpl.create((Object)"."));
            this.like((Expression<String>)path.append(".*"));
            this.like((Expression<String>)path.prepend(".*"));
            this.like((Expression<String>)path.append("."));
            this.like((Expression<String>)path.prepend("."));
        }
        long duration = System.currentTimeMillis() - start;
        System.err.println(duration);
    }

    private String regex(Expression<String> expr) {
        return ExpressionUtils.likeToRegex(expr).toString();
    }

    private String like(Expression<String> expr) {
        return ExpressionUtils.regexToLike(expr).toString();
    }

    @Test
    public void count() {
        Assert.assertEquals((Object)"count(str)", (Object)ExpressionUtils.count((Expression)str).toString());
    }

    @Test
    public void eqConst() {
        Assert.assertEquals((Object)"str = X", (Object)ExpressionUtils.eqConst((Expression)str, (Object)"X").toString());
    }

    @Test
    public void eq() {
        Assert.assertEquals((Object)"str = str2", (Object)ExpressionUtils.eq((Expression)str, (Expression)str2).toString());
    }

    @Test
    public void in() {
        Assert.assertEquals((Object)"str in [a, b, c]", (Object)ExpressionUtils.in((Expression)str, Arrays.asList("a", "b", "c")).toString());
    }

    @Test
    public void in_subQuery() {
        String s = ExpressionUtils.in((Expression)str, (SubQueryExpression)new SubQueryExpressionImpl(String.class, (QueryMetadata)new DefaultQueryMetadata())).toString();
        Assert.assertTrue((boolean)s.startsWith("str in com.querydsl.core.DefaultQueryMetadata@c"));
    }

    @Test
    public void inAny() {
        List<List> of = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("d", "e", "f"));
        Assert.assertEquals((Object)"str in [a, b, c] || str in [d, e, f]", (Object)ExpressionUtils.inAny((Expression)str, of).toString());
    }

    @Test
    public void isNull() {
        Assert.assertEquals((Object)"str is null", (Object)ExpressionUtils.isNull((Expression)str).toString());
    }

    @Test
    public void isNotNull() {
        Assert.assertEquals((Object)"str is not null", (Object)ExpressionUtils.isNotNull((Expression)str).toString());
    }

    @Test
    public void neConst() {
        Assert.assertEquals((Object)"str != X", (Object)ExpressionUtils.neConst((Expression)str, (Object)"X").toString());
    }

    @Test
    public void ne() {
        Assert.assertEquals((Object)"str != str2", (Object)ExpressionUtils.ne((Expression)str, (Expression)str2).toString());
    }

    @Test
    public void notInAny() {
        List<List> of = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("d", "e", "f"));
        Assert.assertEquals((Object)"str not in [a, b, c] && str not in [d, e, f]", (Object)ExpressionUtils.notInAny((Expression)str, of).toString());
    }

    @Test
    public void notIn_subQuery() {
        String s = ExpressionUtils.notIn((Expression)str, (SubQueryExpression)new SubQueryExpressionImpl(String.class, (QueryMetadata)new DefaultQueryMetadata())).toString();
        Assert.assertTrue((boolean)s.startsWith("str not in com.querydsl.core.DefaultQueryMetadata@c"));
    }
}

