/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.querydsl.collections.CollQueryFunctions;
import com.querydsl.core.types.JavaTemplates;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.PathType;

public class CollQueryTemplates
extends JavaTemplates {
    public static final CollQueryTemplates DEFAULT = new CollQueryTemplates();

    protected CollQueryTemplates() {
        String functions = CollQueryFunctions.class.getName();
        this.add((Operator)Ops.EQ, functions + ".equals({0}, {1})");
        this.add((Operator)Ops.NE, "!" + functions + ".equals({0}, {1})");
        this.add((Operator)Ops.INSTANCE_OF, "{1}.isInstance({0})");
        this.add((Operator)Ops.GT, functions + ".compareTo({0}, {1}) > 0");
        this.add((Operator)Ops.LT, functions + ".compareTo({0}, {1}) < 0");
        this.add((Operator)Ops.GOE, functions + ".compareTo({0}, {1}) >= 0");
        this.add((Operator)Ops.LOE, functions + ".compareTo({0}, {1}) <= 0");
        this.add((Operator)Ops.BETWEEN, functions + ".between({0}, {1}, {2})");
        this.add((Operator)Ops.STRING_CAST, "String.valueOf({0})");
        this.add((Operator)Ops.MathOps.COT, functions + ".cot({0})");
        this.add((Operator)Ops.MathOps.COTH, functions + ".coth({0})");
        this.add((Operator)Ops.MathOps.DEG, functions + ".degrees({0})");
        this.add((Operator)Ops.MathOps.LN, "Math.log({0})");
        this.add((Operator)Ops.MathOps.LOG, functions + ".log({0},{1})");
        this.add((Operator)Ops.MathOps.RAD, functions + ".radians({0})");
        this.add((Operator)Ops.MathOps.SIGN, "{0} > 0 ? 1 : -1");
        this.add((Operator)Ops.ADD, "{0}.add({1})");
        this.add((Operator)Ops.SUB, "{0}.subtract({1})");
        this.add((Operator)Ops.MULT, "{0}.multiply({1})");
        this.add((Operator)Ops.DIV, "{0}.divide({1})");
        this.add((Operator)Ops.DateTimeOps.YEAR, functions + ".getYear({0})");
        this.add((Operator)Ops.DateTimeOps.MONTH, functions + ".getMonth({0})");
        this.add((Operator)Ops.DateTimeOps.WEEK, functions + ".getWeek({0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_WEEK, functions + ".getDayOfWeek({0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_MONTH, functions + ".getDayOfMonth({0})");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_YEAR, functions + ".getDayOfYear({0})");
        this.add((Operator)Ops.DateTimeOps.HOUR, functions + ".getHour({0})");
        this.add((Operator)Ops.DateTimeOps.MINUTE, functions + ".getMinute({0})");
        this.add((Operator)Ops.DateTimeOps.SECOND, functions + ".getSecond({0})");
        this.add((Operator)Ops.DateTimeOps.MILLISECOND, functions + ".getMilliSecond({0})");
        this.add((Operator)Ops.DateTimeOps.YEAR_MONTH, functions + ".getYearMonth({0})");
        this.add((Operator)Ops.DateTimeOps.YEAR_WEEK, functions + ".getYearWeek({0})");
        this.add((Operator)Ops.LIKE, functions + ".like({0},{1})");
        this.add((Operator)Ops.LIKE_ESCAPE, functions + ".like({0},{1},{2})");
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.MAPVALUE_CONSTANT}) {
            this.add((Operator)type, "{0}.get({1})");
        }
        this.add((Operator)PathType.LISTVALUE_CONSTANT, "{0}.get({1})");
        this.add((Operator)PathType.ARRAYVALUE, "{0}[{1}]");
        this.add((Operator)PathType.ARRAYVALUE_CONSTANT, "{0}[{1}]");
        this.add((Operator)PathType.COLLECTION_ANY, "{0}_any");
        this.add((Operator)Ops.COALESCE, functions + ".coalesce({0})");
        this.add((Operator)Ops.NULLIF, functions + ".nullif({0}, {1})");
    }
}

