/*
 * Copyright 2010, Mysema Ltd
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.querydsl.codegen.utils;

/**
 * Defines general String constants
 * 
 * @author tiwe
 * 
 */
public final class Symbols {

    public static final String ASSIGN = " = ";

    public static final String COMMA = ", ";

    public static final String DOT = ".";

    public static final String DOT_CLASS = ".class";

    public static final String EMPTY = "";

    public static final String NEW = "new ";

    public static final String NEWLINE = "\n";

    public static final String QUOTE = "\"";

    public static final String RETURN = "return ";

    public static final String SEMICOLON = ";";

    public static final String SERIAL = "serial";

    public static final String SPACE = " ";

    public static final String STAR = "*";

    public static final String SUPER = "super";

    public static final String THIS = "this";

    public static final String UNCHECKED = "unchecked";

    private Symbols() {
    }
}
