/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSClient;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSResponse;
import com.qualys.plugins.wasPlugin.util.Helper;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.File;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;

@Extension
public class ReportAction
implements Action {
    private String scanId;
    private String status;
    private String scanReference;
    private String targetUrl;
    private String webAppId;
    private String scanName;
    private boolean isFailConditionsConfigured;
    private JsonObject evaluationResult;
    private String portalUrl;
    private String reportUrl;
    private String apiServer;
    private String apiUser;
    private Secret apiPass;
    private boolean useProxy;
    private String proxyServer;
    private int proxyPort;
    private String proxyUsername;
    private Secret proxyPassword;
    private JSONObject scanResult;
    private Run<?, ?> run;
    private static final Logger logger = Helper.getLogger(ReportAction.class.getName());

    public ReportAction() {
    }

    public ReportAction(Run<?, ?> run, String scanId, String webAppId, String scanName, String apiServer, String apiUser, Secret apiPass, boolean useProxy, String proxyServer, int proxyPort, String proxyUsername, Secret proxyPassword, String portalUrl) {
        this.scanId = scanId;
        this.scanName = scanName;
        this.webAppId = webAppId;
        this.apiServer = apiServer;
        this.apiUser = apiUser;
        this.apiPass = apiPass;
        this.useProxy = useProxy;
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.portalUrl = portalUrl;
        this.reportUrl = (portalUrl.endsWith("/") ? portalUrl : portalUrl + "/") + "portal-front/module/was/#forward=/module/was/&scan-report=" + scanId;
        this.run = run;
    }

    public String getScanId() {
        return this.scanId;
    }

    public String getWebAppId() {
        return this.webAppId;
    }

    public String getScanName() {
        return this.scanName;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public JSONObject getScanResult() {
        this.scanResult = new JSONObject();
        try {
            JSONObject obj;
            JsonElement respEl;
            JsonObject respObj;
            String filename = this.run.getArtifactsDir().getAbsolutePath() + File.separator + "qualys_" + this.scanId + ".json";
            File f = new File(filename);
            Gson gson = new Gson();
            if (f.exists()) {
                String resultStr = FileUtils.readFileToString((File)f);
                respObj = (JsonObject)gson.fromJson(resultStr, JsonObject.class);
            } else {
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass.getPlainText());
                if (this.useProxy) {
                    auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword.getPlainText());
                }
                QualysCSClient qualysClient = new QualysCSClient(auth, System.out);
                QualysCSResponse response = qualysClient.getScanResult(this.scanId);
                respObj = response.response;
            }
            if (respObj.has("evaluationResult") && !respObj.get("evaluationResult").isJsonNull()) {
                this.scanResult.put("isEvaluationResult", (Object)1);
                respEl = respObj.get("evaluationResult");
                JsonObject evalresult = respEl.getAsJsonObject();
                GsonBuilder builder = new GsonBuilder();
                Gson gsonObject = builder.serializeNulls().create();
                String sevVulnsJson = gsonObject.toJson((JsonElement)evalresult);
                JsonElement sevVulnsElement = (JsonElement)gsonObject.fromJson(sevVulnsJson, JsonElement.class);
                this.scanResult.put("evaluationResult", (Object)JSONObject.fromObject((Object)gsonObject.toJson(sevVulnsElement)));
            } else {
                this.scanResult.put("isEvaluationResult", (Object)0);
                this.scanResult.put("evaluationResult", (Object)JSONObject.fromObject((Object)"{}"));
            }
            respEl = respObj.get("ServiceResponse");
            JsonObject serviceResp = respEl.getAsJsonObject();
            JsonElement respCodeObj = serviceResp.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equalsIgnoreCase("SUCCESS")) {
                JsonObject respErr = serviceResp.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            String[] summaryAttrs = new String[]{"linksCrawled", "nbRequests", "resultsStatus", "authStatus"};
            JsonArray dataArr = serviceResp.get("data").getAsJsonArray();
            JsonObject scanObj = dataArr.get(0).getAsJsonObject().get("WasScan").getAsJsonObject();
            JsonObject summary = scanObj.get("summary").getAsJsonObject();
            for (int i = 0; i < summaryAttrs.length; ++i) {
                try {
                    this.scanResult.put(summaryAttrs[i], (Object)summary.get(summaryAttrs[i]).getAsString());
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], (Object)" - ");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], (Object)("Exception: " + exc.getMessage()));
                }
            }
            try {
                String scanDuration = scanObj.get("scanDuration").getAsString();
                long secondsL = Long.parseLong(scanDuration, 10);
                String readableTime = Helper.secondsToReadableTime(secondsL);
                this.scanResult.put("scanDuration", (Object)readableTime);
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", (Object)("Exception: " + exc.getMessage()));
            }
            try {
                String scanRef = scanObj.get("reference").getAsString();
                this.scanResult.put("reference", (Object)scanRef);
                this.scanReference = scanRef;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", (Object)("Exception: " + exc.getMessage()));
            }
            try {
                JsonObject target = scanObj.get("target").getAsJsonObject();
                JsonObject webapp = target.get("webApp").getAsJsonObject();
                String url = webapp.get("url").getAsString();
                this.scanResult.put("targetUrl", (Object)url);
                this.targetUrl = url;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", (Object)("Exception: " + exc.getMessage()));
            }
            this.scanResult.put("vulnsBySeverity", (Object)JSONObject.fromObject((Object)"{\"1\": 0,\"2\": 0,\"3\": 0,\"4\": 0,\"5\": 0}"));
            try {
                JsonObject stats = scanObj.get("stats").getAsJsonObject();
                JsonObject global = stats.get("global").getAsJsonObject();
                obj = new JSONObject();
                for (int i = 1; i <= 5; ++i) {
                    obj.put("" + i, (Object)global.get("nbVulnsLevel" + i).getAsString());
                }
                this.scanResult.put("vulnsBySeverity", (Object)obj);
            }
            catch (NullPointerException exc) {
                exc.printStackTrace();
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", (Object)("Exception: " + exc.getMessage()));
            }
            this.scanResult.put("vulnsTable", (Object)JSONObject.fromObject((Object)"{list:[]}"));
            String[] vulnsSummary = new String[]{"vulns", "sensitiveContents", "igs"};
            for (int i = 0; i < vulnsSummary.length; ++i) {
                try {
                    obj = scanObj.get(vulnsSummary[i]).getAsJsonObject();
                    String count = obj.get("count").getAsString();
                    this.scanResult.put(vulnsSummary[i], (Object)count);
                    if (!vulnsSummary[i].equals("vulns") || Integer.parseInt(count) <= 0) continue;
                    this.scanResult.put("vulnsTable", (Object)JSONObject.fromObject((Object)gson.toJson((JsonElement)obj)));
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], (Object)"Couldn't find the value in API Response.");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], (Object)("Exception: " + exc.getMessage()));
                }
            }
        }
        catch (Exception e) {
            logger.info("Error parsing scan Result: " + e.getMessage());
            this.scanResult.put("error", (Object)e.getMessage());
            e.printStackTrace();
        }
        return this.scanResult;
    }

    public JSONObject getStatus() {
        JSONObject statusDetails = new JSONObject();
        try {
            if (this.status != null && this.status.equals("FINISHED")) {
                statusDetails.put("value", (Object)"FINISHED");
                statusDetails.put("cssClass", (Object)"success");
                statusDetails.put("targetUrl", (Object)this.targetUrl);
                statusDetails.put("reference", (Object)this.scanReference);
            } else {
                statusDetails = this.parseScanStatus(this.scanId);
                if (statusDetails.get("value") == "FINISHED") {
                    this.status = "FINISHED";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            statusDetails.put("value", (Object)e.getMessage());
            statusDetails.put("cssClass", (Object)"error");
        }
        return statusDetails;
    }

    public JSONObject parseScanStatus(String scanId) throws Exception {
        JSONObject statusObj = new JSONObject();
        JsonObject result = new JsonObject();
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass.getPlainText());
        if (this.useProxy) {
            auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword.getPlainText());
        }
        QualysCSClient qualysClient = new QualysCSClient(auth, System.out);
        QualysCSResponse resp = qualysClient.getScanDetails(scanId);
        result = resp.response;
        JsonElement respEl = result.get("ServiceResponse");
        JsonObject respObj = respEl.getAsJsonObject();
        JsonElement respCodeObj = respObj.get("responseCode");
        if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
            JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
            logger.info("Server Response: " + respErr.toString());
            String reason = respErr.get("errorMessage").getAsString();
            throw new Exception(reason);
        }
        JsonArray dataArr = respObj.getAsJsonArray("data");
        for (int i = 0; i < dataArr.size(); ++i) {
            JsonElement resultsStatusObj;
            String status;
            JsonObject wasObj;
            block9: {
                JsonObject obj = dataArr.get(i).getAsJsonObject();
                wasObj = obj.getAsJsonObject("WasScan");
                status = wasObj.get("status").getAsString();
                try {
                    String reference = wasObj.get("reference").getAsString();
                    JsonObject targetObj = wasObj.getAsJsonObject("target");
                    JsonObject webObj = targetObj.getAsJsonObject("webApp");
                    String targetUrl = webObj.get("url").getAsString();
                    statusObj.put("reference", (Object)reference);
                    statusObj.put("targetUrl", (Object)targetUrl);
                }
                catch (Exception e) {
                    if (statusObj.get("reference") != null) {
                        statusObj.put("reference", (Object)"");
                    }
                    if (statusObj.get("targetUrl") == null) break block9;
                    statusObj.put("targetUrl", (Object)"");
                }
            }
            if (status.equals("FINISHED") || status.equals("COMPLETED")) {
                statusObj.put("value", (Object)"FINISHED");
                statusObj.put("cssClass", (Object)"success");
                continue;
            }
            statusObj.put("value", (Object)status);
            statusObj.put("cssClass", (Object)"info");
            JsonObject summaryObj = wasObj.getAsJsonObject("summary");
            if (summaryObj == null || summaryObj.isJsonNull() || (resultsStatusObj = summaryObj.get("resultsStatus")) == null || resultsStatusObj.isJsonNull()) continue;
            statusObj.put("resultsStatus", (Object)resultsStatusObj.getAsString());
        }
        return statusObj;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Qualys WAS Scan Status";
    }

    public String getUrlName() {
        return "qualys_was_scan_status.html";
    }
}

