/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSClient;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSResponse;
import com.qualys.plugins.wasPlugin.WASScanNotifier;
import com.qualys.plugins.wasPlugin.util.Helper;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class WASScanBuildStep
extends AbstractStepImpl {
    private String platform;
    private String apiServer;
    private String credsId;
    private String webAppId;
    private String scanName;
    private String scanType;
    private String authRecord;
    private String optionProfile;
    private String cancelOptions;
    private String cancelHours;
    private String optionProfileId;
    private String authRecordId;
    private String proxyServer;
    private int proxyPort;
    private String proxyCredentialsId;
    private boolean useProxy = false;
    private String pollingInterval;
    private String vulnsTimeout;
    private int severity1Limit;
    private int severity2Limit;
    private int severity3Limit;
    private int severity4Limit;
    private int severity5Limit;
    private boolean isSev1Vulns = false;
    private boolean isSev2Vulns = false;
    private boolean isSev3Vulns = false;
    private boolean isSev4Vulns = false;
    private boolean isSev5Vulns = false;
    private boolean isFailOnQidFound;
    private String qidList;
    private boolean failOnScanError = true;
    private static final String SCAN_NAME = "[job_name]_jenkins_build_[build_number]";
    private static final int PROXY_PORT = 80;
    private static final Logger logger = Helper.getLogger(WASScanBuildStep.class.getName());
    private static final String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getApiServer() {
        return this.apiServer;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    @DataBoundSetter
    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public String getVulnsTimeout() {
        return this.vulnsTimeout;
    }

    @DataBoundSetter
    public void setVulnsTimeout(String vulnsTimeout) {
        this.vulnsTimeout = vulnsTimeout;
    }

    @DataBoundSetter
    public void setApiServer(String apiServer) {
        if (apiServer != null && apiServer.endsWith("/")) {
            apiServer = apiServer.substring(0, apiServer.length() - 1);
        }
        this.apiServer = apiServer;
    }

    public boolean getIsFailOnQidFound() {
        return this.isFailOnQidFound;
    }

    @DataBoundSetter
    public void setIsFailOnQidFound(boolean isFailOnQidFound) {
        this.isFailOnQidFound = isFailOnQidFound;
    }

    public String getQidList() {
        return this.qidList;
    }

    @DataBoundSetter
    public void setQidList(String qidList) {
        this.qidList = qidList;
    }

    @DataBoundSetter
    public void setSeverity1Limit(int severity1Limit) {
        this.severity1Limit = severity1Limit;
    }

    public int getSeverity1Limit() {
        return this.severity1Limit;
    }

    @DataBoundSetter
    public void setSeverity2Limit(int severity2Limit) {
        this.severity2Limit = severity2Limit;
    }

    public int getSeverity2Limit() {
        return this.severity2Limit;
    }

    @DataBoundSetter
    public void setSeverity3Limit(int severity3Limit) {
        this.severity3Limit = severity3Limit;
    }

    public int getSeverity3Limit() {
        return this.severity3Limit;
    }

    @DataBoundSetter
    public void setSeverity4Limit(int severity4Limit) {
        this.severity4Limit = severity4Limit;
    }

    public int getSeverity4Limit() {
        return this.severity4Limit;
    }

    @DataBoundSetter
    public void setSeverity5Limit(int severity5Limit) {
        this.severity5Limit = severity5Limit;
    }

    public int getSeverity5Limit() {
        return this.severity5Limit;
    }

    @DataBoundSetter
    public void setIsSev1Vulns(boolean isSev1Vulns) {
        this.isSev1Vulns = isSev1Vulns;
    }

    public boolean getIsSev1Vulns() {
        return this.isSev1Vulns;
    }

    @DataBoundSetter
    public void setIsSev2Vulns(boolean isSev2Vulns) {
        this.isSev2Vulns = isSev2Vulns;
    }

    public boolean getIsSev2Vulns() {
        return this.isSev2Vulns;
    }

    @DataBoundSetter
    public void setIsSev3Vulns(boolean isSev3Vulns) {
        this.isSev3Vulns = isSev3Vulns;
    }

    public boolean getIsSev3Vulns() {
        return this.isSev3Vulns;
    }

    @DataBoundSetter
    public void setIsSev4Vulns(boolean isSev4Vulns) {
        this.isSev4Vulns = isSev4Vulns;
    }

    public boolean getIsSev4Vulns() {
        return this.isSev4Vulns;
    }

    @DataBoundSetter
    public void setIsSev5Vulns(boolean isSev5Vulns) {
        this.isSev5Vulns = isSev5Vulns;
    }

    public boolean getIsSev5Vulns() {
        return this.isSev5Vulns;
    }

    @DataBoundSetter
    public void setCredsId(String cred) {
        this.credsId = cred;
    }

    public String getCredsId() {
        return this.credsId;
    }

    public String getWebAppId() {
        return this.webAppId;
    }

    @DataBoundSetter
    public void setWebAppId(String webAppId) {
        this.webAppId = webAppId;
    }

    @DataBoundSetter
    public void setScanName(String scanName) {
        this.scanName = scanName = StringUtils.isBlank((String)scanName) ? SCAN_NAME : scanName;
    }

    public String getScanName() {
        return this.scanName;
    }

    @DataBoundSetter
    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    public String getScanType() {
        return this.scanType;
    }

    @DataBoundSetter
    public void setAuthRecord(String authRecord) {
        this.authRecord = authRecord;
    }

    public String getAuthRecord() {
        return this.authRecord;
    }

    @DataBoundSetter
    public void setOptionProfile(String optionProfile) {
        this.optionProfile = optionProfile;
    }

    public String getOptionProfile() {
        return this.optionProfile;
    }

    @DataBoundSetter
    public void setCancelOptions(String cancelOptions) {
        this.cancelOptions = cancelOptions;
    }

    public String getCancelOptions() {
        return this.cancelOptions;
    }

    @DataBoundSetter
    public void setCancelHours(String cancelHours) {
        this.cancelHours = cancelHours;
    }

    public String getCancelHours() {
        return this.cancelHours;
    }

    @DataBoundSetter
    public void setOptionProfileId(String optionProfileId) {
        this.optionProfileId = optionProfileId;
    }

    public String getOptionProfileId() {
        return this.optionProfileId;
    }

    @DataBoundSetter
    public void setAuthRecordId(String authRecordId) {
        this.authRecordId = authRecordId;
    }

    public String getAuthRecordId() {
        return this.authRecordId;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    @DataBoundSetter
    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort = proxyPort <= 0 ? 80 : proxyPort;
    }

    public String getProxyCredentialsId() {
        return this.proxyCredentialsId;
    }

    @DataBoundSetter
    public void setProxyCredentialsId(String proxyCredentialsId) {
        this.proxyCredentialsId = proxyCredentialsId;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @DataBoundSetter
    public void setFailOnScanError(boolean failOnScanError) {
        this.failOnScanError = failOnScanError;
    }

    public boolean getFailOnScanError() {
        return this.failOnScanError;
    }

    @DataBoundConstructor
    public WASScanBuildStep(String apiServer, String credsId, String webAppId, String scanName, String scanType, String authRecord, String optionProfile, String cancelOptions, String cancelHours, String optionProfileId, String authRecordId, String proxyServer, int proxyPort, String proxyCredentialsId, boolean useProxy, String pollingInterval, String vulnsTimeout, int severity1Limit, int severity2Limit, int severity3Limit, int severity4Limit, int severity5Limit, boolean isSev1Vulns, boolean isSev2Vulns, boolean isSev3Vulns, boolean isSev4Vulns, boolean isSev5Vulns, boolean isFailOnQidFound, String qidList, String platform, boolean failOnScanError) {
        this.platform = platform;
        if (platform.equalsIgnoreCase("pcp")) {
            this.apiServer = apiServer;
        }
        this.credsId = credsId;
        this.webAppId = webAppId;
        this.scanName = scanName;
        this.scanType = scanType;
        this.authRecord = authRecord;
        if (authRecord != null && authRecord.equalsIgnoreCase("other")) {
            this.authRecordId = authRecordId;
        }
        this.optionProfile = optionProfile;
        if (optionProfile != null && optionProfile.equalsIgnoreCase("other")) {
            this.optionProfileId = optionProfileId;
        }
        this.cancelOptions = cancelOptions;
        if (cancelOptions != null && cancelOptions.equalsIgnoreCase("xhours")) {
            this.cancelHours = cancelHours;
        }
        this.useProxy = useProxy;
        if (this.useProxy) {
            this.proxyServer = proxyServer;
            this.proxyPort = proxyPort;
            this.proxyCredentialsId = proxyCredentialsId;
        }
        this.pollingInterval = pollingInterval;
        this.vulnsTimeout = vulnsTimeout;
        if (isSev1Vulns) {
            this.isSev1Vulns = isSev1Vulns;
            this.severity1Limit = severity1Limit;
        }
        if (isSev2Vulns) {
            this.isSev2Vulns = isSev2Vulns;
            this.severity2Limit = severity2Limit;
        }
        if (isSev3Vulns) {
            this.isSev3Vulns = isSev3Vulns;
            this.severity3Limit = severity3Limit;
        }
        if (isSev4Vulns) {
            this.isSev4Vulns = isSev4Vulns;
            this.severity4Limit = severity4Limit;
        }
        if (isSev5Vulns) {
            this.isSev5Vulns = isSev5Vulns;
            this.severity5Limit = severity5Limit;
        }
        if (isFailOnQidFound) {
            this.isFailOnQidFound = isFailOnQidFound;
            this.qidList = qidList;
        }
        this.failOnScanError = failOnScanError;
    }

    public static final class WASScanBuildExecution
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient WASScanBuildStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener taskListener;

        protected String run() throws Exception {
            WASScanNotifier notifier = new WASScanNotifier(this.step.getApiServer(), this.step.getCredsId());
            notifier.setWebAppId(this.step.getWebAppId());
            notifier.setScanName(this.step.getScanName());
            notifier.setScanType(this.step.getScanType());
            notifier.setAuthRecord(this.step.getAuthRecord());
            notifier.setOptionProfile(this.step.getOptionProfile());
            notifier.setCancelOptions(this.step.getCancelOptions());
            notifier.setAuthRecordId(this.step.getAuthRecordId());
            notifier.setOptionProfileId(this.step.getOptionProfileId());
            notifier.setCancelHours(this.step.getCancelHours());
            notifier.setUseProxy(this.step.getUseProxy());
            notifier.setProxyServer(this.step.getProxyServer());
            notifier.setProxyPort(this.step.getProxyPort());
            notifier.setProxyCredentialsId(this.step.getProxyCredentialsId());
            notifier.setIsFailOnQidFound(this.step.getIsFailOnQidFound());
            notifier.setQidList(this.step.getQidList());
            notifier.setSeverity1Limit(this.step.getSeverity1Limit());
            notifier.setSeverity2Limit(this.step.getSeverity2Limit());
            notifier.setSeverity3Limit(this.step.getSeverity3Limit());
            notifier.setSeverity4Limit(this.step.getSeverity4Limit());
            notifier.setSeverity5Limit(this.step.getSeverity5Limit());
            notifier.setIsSev1Vulns(this.step.getIsSev1Vulns());
            notifier.setIsSev2Vulns(this.step.getIsSev2Vulns());
            notifier.setIsSev3Vulns(this.step.getIsSev3Vulns());
            notifier.setIsSev4Vulns(this.step.getIsSev4Vulns());
            notifier.setIsSev5Vulns(this.step.getIsSev5Vulns());
            notifier.setPollingInterval(this.step.getPollingInterval());
            notifier.setVulnsTimeout(this.step.getVulnsTimeout());
            notifier.setPlatform(this.step.getPlatform());
            notifier.setFailOnScanError(this.step.getFailOnScanError());
            notifier.perform(this.run, this.ws, this.launcher, this.taskListener);
            return "SUCCESS";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        private final String URL_REGEX = "^(https)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        private final String PROXY_REGEX = "^((https?)://)?[-a-zA-Z0-9+&@#/%?=~_|!,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        private final String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";

        public DescriptorImpl() {
            super(WASScanBuildExecution.class);
        }

        public String getFunctionName() {
            return "qualysWASScan";
        }

        public String getDisplayName() {
            return "Scan web applications with Qualys WAS";
        }

        public boolean isNonUTF8String(String string) {
            if (string != null && !string.isEmpty()) {
                try {
                    byte[] byArray = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return true;
                }
            }
            return false;
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String pollingInterval) {
            try {
                String pollingIntervalVal = pollingInterval.trim();
                if (pollingIntervalVal.equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile("^(\\d+[*]?)*(?<!\\*)$");
                Matcher matcher = patt.matcher(pollingIntervalVal);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + pollingInterval + ", reason = " + e));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVulnsTimeout(@QueryParameter String vulnsTimeout) {
            String vulnsTimeoutVal = vulnsTimeout.trim();
            try {
                if (vulnsTimeoutVal.equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile("^(\\d+[*]?)*(?<!\\*)$");
                Matcher matcher = patt.matcher(vulnsTimeoutVal);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + vulnsTimeout + ", reason = " + e));
            }
        }

        public FormValidation doCheckApiServer(@QueryParameter String apiServer) {
            if (this.isNonUTF8String(apiServer)) {
                return FormValidation.error((String)"Please provide valid UTF-8 string value.");
            }
            try {
                String server = apiServer != null ? apiServer.trim() : "";
                Pattern patt = Pattern.compile("^(https)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                Matcher matcher = patt.matcher(server);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Server name is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckCredsId(@QueryParameter String credsId) {
            try {
                if (credsId.trim().equals("")) {
                    return FormValidation.error((String)"API Credentials cannot be empty.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public ListBoxModel doFillCredsIdItems(@AncestorInPath Item item, @QueryParameter String credsId) {
            item.checkPermission(Item.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Item.CONFIGURE) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(credsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)credsId), (IdCredentials[])new StandardCredentials[0]);
        }

        @POST
        public ListBoxModel doFillProxyCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String proxyCredentialsId) {
            item.checkPermission(Item.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Item.CONFIGURE) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(proxyCredentialsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)proxyCredentialsId), (IdCredentials[])new StandardCredentials[0]);
        }

        public QualysCSClient getQualysClient(String apiServer, String credsId, boolean useProxy, String proxyServer, String proxyPort, String proxyCredentialsId, Item item) {
            StandardUsernamePasswordCredentials c;
            String apiUser = "";
            String apiPass = "";
            String proxyUsername = "";
            String proxyPassword = "";
            if (StringUtils.isNotEmpty((String)credsId)) {
                c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credsId));
                apiUser = c != null ? c.getUsername() : "";
                String string = apiPass = c != null ? c.getPassword().getPlainText() : "";
            }
            if (StringUtils.isNotEmpty((String)proxyCredentialsId)) {
                c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)proxyCredentialsId));
                proxyUsername = c != null ? c.getUsername() : "";
                String string = proxyPassword = c != null ? c.getPassword().getPlainText() : "";
            }
            if (StringUtils.isNotBlank((String)apiServer) && StringUtils.isNotBlank((String)apiUser) && StringUtils.isNotBlank((String)apiPass)) {
                if (apiServer.endsWith("/")) {
                    apiServer = apiServer.substring(0, apiServer.length() - 1);
                }
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(apiServer, apiUser, apiPass);
                if (useProxy) {
                    int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                    auth.setProxyCredentials(proxyServer, proxyPortInt, proxyUsername, proxyPassword);
                }
                QualysCSClient client = new QualysCSClient(auth, System.out);
                return client;
            }
            return null;
        }

        @POST
        public ListBoxModel doFillOptionProfileItems() {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            ListBoxModel model = new ListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("Other", "other");
            ListBoxModel.Option e2 = new ListBoxModel.Option("Use Default", "useDefault");
            model.add((Object)e2);
            model.add((Object)e1);
            return model;
        }

        @POST
        public ListBoxModel doFillCancelHoursItems() {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            ListBoxModel model = new ListBoxModel();
            for (int i = 1; i <= 24; ++i) {
                ListBoxModel.Option e = new ListBoxModel.Option(Integer.toString(i), Integer.toString(i));
                model.add((Object)e);
            }
            return model;
        }

        @POST
        public ListBoxModel doFillScanTypeItems() {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            ListBoxModel model = new ListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("VULNERABILITY", "VULNERABILITY");
            ListBoxModel.Option e2 = new ListBoxModel.Option("DISCOVERY", "DISCOVERY");
            model.add((Object)e1);
            model.add((Object)e2);
            return model;
        }

        @POST
        public ListBoxModel doFillCancelOptionsItems() {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            ListBoxModel model = new ListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("None", "none");
            ListBoxModel.Option e2 = new ListBoxModel.Option("Cancel After X Hours", "xhours");
            model.add((Object)e1);
            model.add((Object)e2);
            return model;
        }

        @POST
        public ListBoxModel doFillAuthRecordItems() {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            ListBoxModel model = new ListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("None", "none");
            ListBoxModel.Option e2 = new ListBoxModel.Option("Use Default", "useDefault");
            ListBoxModel.Option e3 = new ListBoxModel.Option("Other", "other");
            model.add((Object)e1);
            model.add((Object)e2);
            model.add((Object)e3);
            return model;
        }

        public QualysCSResponse callAPIs(String api, QualysCSClient client, String id) {
            String xmlReqData;
            QualysCSResponse resp = null;
            String string = xmlReqData = id == null ? null : "<ServiceRequest> <filters> <Criteria field=\"id\" operator=\"GREATER\">" + id + "</Criteria> </filters> </ServiceRequest>";
            if (client != null) {
                switch (api) {
                    case "webAppList": {
                        resp = client.listWebApps(xmlReqData);
                        break;
                    }
                    case "authRecordList": {
                        resp = client.listAuthRecords(xmlReqData);
                        break;
                    }
                    case "profileList": {
                        resp = client.listOptionProfiles(xmlReqData);
                    }
                }
            }
            return resp;
        }

        public JsonArray getDataList(String api, QualysCSClient client) {
            boolean hasMoreRecords = true;
            int page = 0;
            String lastId = null;
            JsonArray dataList = new JsonArray();
            try {
                while (hasMoreRecords) {
                    for (int retry = 0; retry < 3; ++retry) {
                        JsonObject response;
                        JsonObject serviceResp;
                        String responseCode;
                        if (retry > 0) {
                            logger.info("Retrying " + api + " call: " + retry);
                        }
                        QualysCSResponse resp = this.callAPIs(api, client, lastId);
                        logger.info("Response code received for API " + api + " call [page=" + page + "]: " + resp.responseCode);
                        hasMoreRecords = false;
                        if (resp == null || resp.responseCode != 200 || !(responseCode = (serviceResp = (response = resp.response).getAsJsonObject("ServiceResponse")).get("responseCode").getAsString()).equalsIgnoreCase("success")) continue;
                        int count = serviceResp.get("count").getAsInt();
                        if (count <= 0) break;
                        hasMoreRecords = serviceResp.get("hasMoreRecords").getAsBoolean();
                        lastId = hasMoreRecords ? serviceResp.get("lastId").getAsString() : null;
                        JsonArray arr = serviceResp.get("data").getAsJsonArray();
                        dataList.addAll(arr);
                        break;
                    }
                    ++page;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return dataList;
        }

        @POST
        public ListBoxModel doFillWebAppIdItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy) {
            item.checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            try {
                if (this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                    }
                    QualysCSClient client = this.getQualysClient(server, credsId, useProxy, proxyServer, proxyPort, proxyCredentialsId, item);
                    logger.info("Fetching web applications list ... ");
                    JsonArray dataList = this.getDataList("webAppList", client);
                    for (JsonElement webapp : dataList) {
                        JsonObject obj = webapp.getAsJsonObject();
                        JsonObject webAppObj = obj.getAsJsonObject("WebApp");
                        String id = webAppObj.get("id").getAsString();
                        String name = webAppObj.get("name").getAsString();
                        String label = name.replaceAll(WASScanBuildStep.xml10pattern, "*");
                        ListBoxModel.Option e = new ListBoxModel.Option(label, id);
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            model.sort(Helper.OptionItemmsComparator);
            return model.withEmptySelection();
        }

        @POST
        public ListBoxModel doFillAuthRecordIdItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy) {
            item.checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            try {
                if (this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                    }
                    QualysCSClient client = this.getQualysClient(server, credsId, useProxy, proxyServer, proxyPort, proxyCredentialsId, item);
                    logger.info("Fetching Auth Records list ... ");
                    JsonArray dataList = this.getDataList("authRecordList", client);
                    for (JsonElement webapp : dataList) {
                        JsonObject obj = webapp.getAsJsonObject();
                        JsonObject webAppObj = obj.getAsJsonObject("WebAppAuthRecord");
                        String id = webAppObj.get("id").getAsString();
                        String name = webAppObj.get("name").getAsString();
                        Charset charset = Charset.forName("UTF-8");
                        String label = name.replaceAll(WASScanBuildStep.xml10pattern, "*");
                        ListBoxModel.Option e = new ListBoxModel.Option(label, id);
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            model.sort(Helper.OptionItemmsComparator);
            return model.withEmptySelection();
        }

        @POST
        public ListBoxModel doFillOptionProfileIdItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy) {
            item.checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            try {
                if (this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                    }
                    QualysCSClient client = this.getQualysClient(server, credsId, useProxy, proxyServer, proxyPort, proxyCredentialsId, item);
                    logger.info("Fetching Option Profiles list ... ");
                    JsonArray dataList = this.getDataList("profileList", client);
                    for (JsonElement webapp : dataList) {
                        JsonObject obj = webapp.getAsJsonObject();
                        JsonObject webAppObj = obj.getAsJsonObject("OptionProfile");
                        String id = webAppObj.get("id").getAsString();
                        String name = webAppObj.get("name").getAsString();
                        Charset charset = Charset.forName("UTF-8");
                        String label = name.replaceAll(WASScanBuildStep.xml10pattern, "*");
                        ListBoxModel.Option e = new ListBoxModel.Option(label, id);
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            model.sort(Helper.OptionItemmsComparator);
            return model.withEmptySelection();
        }

        public boolean filledInputs(String platform, String apiServer, String credsId, boolean useProxy, String proxyServer, String proxyPort) {
            if (platform.equalsIgnoreCase("pcp") && StringUtils.isBlank((String)apiServer)) {
                return false;
            }
            if (StringUtils.isBlank((String)credsId)) {
                return false;
            }
            return !useProxy || !StringUtils.isBlank((String)proxyServer);
        }

        public FormValidation doCheckWebAppId(@QueryParameter String webAppId) {
            block4: {
                try {
                    if (webAppId != null && StringUtils.isNotBlank((String)webAppId)) {
                        int webAppIdInt = Integer.parseInt(webAppId);
                        if (webAppIdInt < 1) {
                            return FormValidation.error((String)"Please select a valid web application");
                        }
                        break block4;
                    }
                    return FormValidation.error((String)"Please select a valid web application");
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Enter valid web application!");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScanName(@QueryParameter String scanName) {
            if (this.isNonUTF8String(scanName)) {
                return FormValidation.error((String)"Please provide valid UTF-8 string value.");
            }
            try {
                if (scanName.trim().equals("")) {
                    return FormValidation.error((String)"Scan Name cannot be empty.");
                }
                if (scanName.length() > 256) {
                    return FormValidation.error((String)"Scan Name length must be of 256 or less characters.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckCancelHours(@QueryParameter String cancelHours) {
            try {
                int hoursInputInt;
                if (!(cancelHours == null || cancelHours.isEmpty() || (hoursInputInt = Integer.parseInt(cancelHours)) >= 1 && hoursInputInt <= 24)) {
                    return FormValidation.error((String)"Please enter a number between range 1 to 24.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckConnection(@QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            try {
                String server;
                int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                String apiUser = "";
                String apiPass = "";
                String string = server = apiServer != null ? apiServer.trim() : "";
                if (!platform.equalsIgnoreCase("pcp")) {
                    Map<String, String> platformObj = Helper.platformsList.get(platform);
                    server = platformObj.get("url");
                    logger.info("Using qualys API Server URL: " + apiServer);
                }
                if (StringUtils.isNotEmpty((String)credsId)) {
                    StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credsId));
                    apiUser = c != null ? c.getUsername() : "";
                    apiPass = c != null ? c.getPassword().getPlainText() : "";
                }
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(server, apiUser, apiPass);
                if (useProxy) {
                    String proxyUsername = "";
                    String proxyPassword = "";
                    if (StringUtils.isNotEmpty((String)proxyCredentialsId)) {
                        StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)proxyCredentialsId));
                        proxyUsername = c != null ? c.getUsername() : "";
                        proxyPassword = c != null ? c.getPassword().getPlainText() : "";
                    }
                    auth.setProxyCredentials(proxyServer, proxyPortInt, proxyUsername, proxyPassword);
                }
                QualysCSClient client = new QualysCSClient(auth, System.out);
                client.testConnection();
                return FormValidation.ok((String)"Connection test successful!");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Connection test failed. (Reason: " + e.getMessage() + ")"));
            }
        }

        public FormValidation doCheckProxyServer(@QueryParameter String proxyServer) {
            if (this.isNonUTF8String(proxyServer)) {
                return FormValidation.error((String)"Please provide valid UTF-8 string value.");
            }
            try {
                Pattern patt = Pattern.compile("^((https?)://)?[-a-zA-Z0-9+&@#/%?=~_|!,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                Matcher matcher = patt.matcher(proxyServer);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Enter valid server url!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckProxyPort(@QueryParameter String proxyPort) {
            block4: {
                try {
                    if (proxyPort != null && !proxyPort.isEmpty() && proxyPort.trim().length() > 0) {
                        int proxyPortInt = Integer.parseInt(proxyPort);
                        if (proxyPortInt < 1 || proxyPortInt > 65535) {
                            return FormValidation.error((String)"Please enter a valid port number!");
                        }
                        break block4;
                    }
                    return FormValidation.error((String)"Please enter a valid port number!");
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Enter valid port number!");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity1Limit(@QueryParameter String severity1Limit) {
            try {
                int severity1LimitInt;
                if (severity1Limit != null && !severity1Limit.isEmpty() && (severity1LimitInt = Integer.parseInt(severity1Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity2Limit(@QueryParameter String severity2Limit) {
            try {
                int severity2LimitInt;
                if (severity2Limit != null && !severity2Limit.isEmpty() && (severity2LimitInt = Integer.parseInt(severity2Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity3Limit(@QueryParameter String severity3Limit) {
            try {
                int severity3LimitInt;
                if (severity3Limit != null && !severity3Limit.isEmpty() && (severity3LimitInt = Integer.parseInt(severity3Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity4Limit(@QueryParameter String severity4Limit) {
            try {
                int severity4LimitInt;
                if (severity4Limit != null && !severity4Limit.isEmpty() && (severity4LimitInt = Integer.parseInt(severity4Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity5Limit(@QueryParameter String severity5Limit) {
            try {
                int severity5LimitInt;
                if (severity5Limit != null && !severity5Limit.isEmpty() && (severity5LimitInt = Integer.parseInt(severity5Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQidList(@QueryParameter String qidList) {
            if (qidList == null || qidList.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                String[] qidsString;
                for (String qid : qidsString = qidList.split(",")) {
                    if (qid.contains("-")) {
                        int lastInRange;
                        String[] range = qid.split("-");
                        int firstInRange = Integer.parseInt(range[0].trim());
                        if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                        return FormValidation.error((String)"Enter valid QID range");
                    }
                    int n = Integer.parseInt(qid.trim());
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid QID range/numbers");
            }
            return FormValidation.ok();
        }

        public List<Map<String, String>> getPlatforms() {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> platform : Helper.platformsList.entrySet()) {
                Map<String, String> obj = platform.getValue();
                result.add(obj);
            }
            return result;
        }
    }
}

