/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.pc.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.pc.auth.QualysAuth;
import com.qualys.plugins.pc.client.QualysPCClient;
import hudson.EnvVars;
import hudson.model.Item;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class Helper {
    private static final Logger logger = Logger.getLogger(Helper.class.getName());
    public static final Map<String, Map<String, String>> platformsList;
    private static Comparator<ListBoxModel.Option> OptionItemmsComparator;

    public QualysPCClient getClient(boolean useProxy, String server, String credsId, String proxyServer, int proxyPortInt, String proxyCredentialsId, Item item) {
        QualysAuth auth = new QualysAuth();
        try {
            auth = this.getQualysAuth(useProxy, server, credsId, proxyServer, proxyPortInt, proxyCredentialsId, item);
        }
        catch (Exception e) {
            logger.info("Exception while getting Client. Error: " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
        return new QualysPCClient(auth, System.out);
    }

    public QualysAuth getQualysAuth(boolean useProxy, String server, String credsId, String proxyServer, int proxyPortInt, String proxyCredentialsId, Item item) {
        QualysAuth auth;
        block5: {
            auth = new QualysAuth();
            String user = null;
            String pass = null;
            String proxyUser = null;
            String proxyPass = null;
            try {
                ArrayList<String> cred = Helper.getCredentails(credsId, item);
                if (cred != null && !cred.isEmpty()) {
                    user = cred.get(0);
                    pass = cred.get(1);
                }
                auth.setQualysCredentials(server, user, pass);
                if (!useProxy) break block5;
                ArrayList<String> proxCreds = Helper.getCredentails(proxyCredentialsId, item);
                if (proxCreds != null && !proxCreds.isEmpty()) {
                    proxyUser = proxCreds.get(0);
                    proxyPass = proxCreds.get(1);
                }
                auth.setProxyCredentials(proxyServer, proxyPortInt, proxyUser, proxyPass, useProxy);
            }
            catch (Exception e) {
                logger.info("Exception while getting Qualys auth. Error: " + e.getMessage());
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
            }
        }
        return auth;
    }

    public static ArrayList<String> getCredentails(String credentialsId, Item item) {
        ArrayList<String> list;
        block3: {
            list = new ArrayList<String>();
            try {
                if (!StringUtils.isNotEmpty((String)credentialsId)) break block3;
                StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
                list.add(c != null ? c.getUsername() : "");
                list.add(c != null ? c.getPassword().getPlainText() : "");
            }
            catch (Exception e) {
                logger.info("Exception while getting Credentails. Error: " + e.getMessage());
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
            }
        }
        return list;
    }

    public static boolean isValidCidList(String cidList) {
        int cid = 0;
        if (cidList != null && !StringUtils.isBlank((String)cidList)) {
            String[] cidL;
            cidList = cidList.replace(" ", "");
            for (String q : cidL = cidList.split(",")) {
                int lastInRange;
                String[] range;
                int firstInRange;
                if (!(q.contains("-") ? (firstInRange = Integer.parseInt((range = q.split("-"))[0].trim())) > (lastInRange = Integer.parseInt(range[1].trim())) : (cid = Integer.parseInt(q)) < 0)) continue;
                return false;
            }
        }
        return true;
    }

    public static String secondsToReadableTime(long duration) {
        long days = TimeUnit.SECONDS.toDays(duration);
        long hours = TimeUnit.SECONDS.toHours(duration -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(duration -= TimeUnit.HOURS.toSeconds(hours));
        long seconds = TimeUnit.SECONDS.toSeconds(duration -= TimeUnit.MINUTES.toSeconds(minutes));
        StringBuilder msg = new StringBuilder();
        if (days != 0L) {
            msg.append(days + "day(s) ");
        }
        if (hours != 0L) {
            msg.append(hours + " hr ");
        }
        if (minutes != 0L) {
            msg.append(minutes + " min ");
        }
        if (seconds != 0L) {
            msg.append(seconds + " s ");
        }
        return msg.toString();
    }

    public static Logger getLogger(String loggerName) {
        Logger pluginLogger = Logger.getLogger(loggerName);
        try {
            pluginLogger.setUseParentHandlers(false);
            QualysLogFormatter formatter = new QualysLogFormatter();
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            pluginLogger.addHandler(handler);
        }
        catch (Exception e) {
            logger.info("Error while formatting logger, reason: " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
        return pluginLogger;
    }

    public static void createNewFile(String rootDir, String filename, String content, PrintStream buildLogger) {
        String error;
        File f = new File(rootDir + File.separator + filename + ".json");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            try {
                f.createNewFile();
                logger.info("JSON file created: " + f.toString());
            }
            catch (Exception e) {
                error = " Failed creating file " + filename + ", reason =" + e.getMessage();
                buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
                logger.info(error);
            }
        }
        try {
            File dir = new File(f.getParentFile(), f.getName());
            PrintWriter writer = new PrintWriter(dir);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            error = " Failed writing file " + filename + ", reason =" + e.getMessage();
            buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
            logger.info(error);
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
    }

    public static void copyEvaluationResultToFile(String rootDir, String filename, PrintStream buildLogger, JsonObject evalresult) throws IOException {
        Gson gson = new Gson();
        File f = new File(rootDir + File.separator + filename + ".json");
        if (f.exists()) {
            Helper.createGlEnVar("RESULT_FILENAME", f.toString());
            String contentStr = FileUtils.readFileToString((File)f);
            JsonObject respObj = (JsonObject)gson.fromJson(contentStr, JsonObject.class);
            GsonBuilder builder = new GsonBuilder();
            gson = builder.serializeNulls().create();
            String sevVulnsJson = gson.toJson((JsonElement)evalresult);
            JsonElement sevVulnsElement = (JsonElement)gson.fromJson(sevVulnsJson, JsonElement.class);
            respObj.add("evaluationResult", sevVulnsElement);
            String final_content = gson.toJson((JsonElement)respObj);
            try {
                File dir = new File(f.getParentFile(), f.getName());
                PrintWriter writer = new PrintWriter(dir);
                writer.print(final_content);
                writer.close();
            }
            catch (FileNotFoundException e) {
                String error = " Failed writing to file " + filename + ", reason =" + e.getMessage();
                logger.info(error);
                buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
            }
        }
    }

    public static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw new UnsupportedOperationException(e);
        }
    }

    public static String intListToString(ArrayList<Integer> numbers) {
        if (!numbers.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (Integer nextN : numbers) {
                buffer.append(nextN).append(" ");
            }
            return buffer.toString();
        }
        return "";
    }

    public static String stringListToString(ArrayList<String> strings) {
        if (!strings.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            for (String nextS : strings) {
                buffer.append(nextS).append(", ");
            }
            return buffer.toString();
        }
        return "";
    }

    public static void createGlEnVar(String key, String value) throws IOException {
        try {
            Jenkins instance = Jenkins.getInstance();
            DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
            List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
            EnvironmentVariablesNodeProperty newEnvVarsNodeProperty = null;
            EnvVars envVars = null;
            if (envVarsNodePropertyList == null || envVarsNodePropertyList.size() == 0) {
                newEnvVarsNodeProperty = new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[0]);
                globalNodeProperties.add((Object)newEnvVarsNodeProperty);
                envVars = newEnvVarsNodeProperty.getEnvVars();
            } else {
                envVars = ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
            }
            envVars.put(key, value);
            logger.info(envVars.toString());
            instance.save();
        }
        catch (Exception e) {
            logger.info("Exception while getting Global Environment Variables. Error: " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
    }

    public static String longToTime(long millis) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }

    public static Comparator<ListBoxModel.Option> getOptionItemmsComparator() {
        return OptionItemmsComparator;
    }

    public static void setOptionItemmsComparator(Comparator<ListBoxModel.Option> optionItemmsComparator) {
        OptionItemmsComparator = optionItemmsComparator;
    }

    static {
        LinkedHashMap aList = new LinkedHashMap();
        HashMap<String, String> platform1 = new HashMap<String, String>();
        platform1.put("name", "US Platform 1");
        platform1.put("code", "US_PLATFORM_1");
        platform1.put("url", "https://qualysapi.qualys.com");
        platform1.put("portal", "https://qualysguard.qualys.com");
        aList.put("US_PLATFORM_1", platform1);
        HashMap<String, String> platform2 = new HashMap<String, String>();
        platform2.put("name", "US Platform 2");
        platform2.put("code", "US_PLATFORM_2");
        platform2.put("url", "https://qualysapi.qg2.apps.qualys.com");
        platform2.put("portal", "https://qualysguard.qg2.apps.qualys.com");
        aList.put("US_PLATFORM_2", platform2);
        HashMap<String, String> platform3 = new HashMap<String, String>();
        platform3.put("name", "US Platform 3");
        platform3.put("code", "US_PLATFORM_3");
        platform3.put("url", "https://qualysapi.qg3.apps.qualys.com");
        platform3.put("portal", "https://qualysguard.qg3.apps.qualys.com");
        aList.put("US_PLATFORM_3", platform3);
        HashMap<String, String> platform5 = new HashMap<String, String>();
        platform5.put("name", "EU Platform 1");
        platform5.put("code", "EU_PLATFORM_1");
        platform5.put("url", "https://qualysapi.qualys.eu");
        platform5.put("portal", "https://qualysguard.qualys.eu");
        aList.put("EU_PLATFORM_1", platform5);
        HashMap<String, String> platform6 = new HashMap<String, String>();
        platform6.put("name", "EU Platform 2");
        platform6.put("code", "EU_PLATFORM_2");
        platform6.put("url", "https://qualysapi.qg2.apps.qualys.eu");
        platform6.put("portal", "https://qualysguard.qg2.apps.qualys.eu");
        aList.put("EU_PLATFORM_2", platform6);
        HashMap<String, String> platform7 = new HashMap<String, String>();
        platform7.put("name", "INDIA Platform");
        platform7.put("code", "INDIA_PLATFORM");
        platform7.put("url", "https://qualysapi.qg1.apps.qualys.in");
        platform7.put("portal", "https://qualysguard.qg1.apps.qualys.in");
        aList.put("INDIA_PLATFORM", platform7);
        HashMap<String, String> platform8 = new HashMap<String, String>();
        platform8.put("name", "CANADA Platform");
        platform8.put("code", "CANADA_PLATFORM");
        platform8.put("url", "https://qualysapi.qg1.apps.qualys.ca");
        platform8.put("portal", "https://qualysguard.qg1.apps.qualys.ca");
        aList.put("CANADA_PLATFORM", platform8);
        HashMap<String, String> platform9 = new HashMap<String, String>();
        platform9.put("name", "Private Cloud Platform");
        platform9.put("code", "PCP");
        platform9.put("url", "");
        aList.put("PCP", platform9);
        platformsList = Collections.unmodifiableMap(aList);
        OptionItemmsComparator = new Comparator<ListBoxModel.Option>(){

            @Override
            public int compare(ListBoxModel.Option e1, ListBoxModel.Option e2) {
                return e1.name.toLowerCase().compareTo(e2.name.toLowerCase());
            }
        };
    }

    public static class QualysLogFormatter
    extends Formatter {
        private final DateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
            builder.append("[").append(record.getSourceClassName()).append(".");
            builder.append(record.getSourceMethodName()).append("] - ");
            builder.append(record.getLevel()).append(": ");
            builder.append(this.formatMessage(record));
            builder.append("\n");
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }
}

