/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.pc.report;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.qualys.plugins.pc.util.Helper;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Extension
public class ReportAction
implements Action {
    private String scanId;
    private String scanRef;
    private String excludedCids;
    private String scanName;
    private String scanTarget;
    private Run<?, ?> run;
    private boolean buildStatus;
    private String ipAddress;
    private String scanStatustUrl;
    private String platformUrl;
    private String scanDuration;
    private String scanLaunchDate;
    private String authRecord;
    private JSONObject scanResult;
    private List<String> policyIds;
    private List<String> policyNames;
    private boolean excludedCriteria;
    private String failCriteria;
    private static final Logger logger = Helper.getLogger(ReportAction.class.getName());

    public ReportAction() {
    }

    public ReportAction(Run<?, ?> run, String scanId, String scanName, String scanRef, String scanDuration, String scanLaunchDate, String authRecord, String ipAddress, String apiServer, String platformUrl, String apiUser, Secret apiPass, boolean useProxy, String proxyServer, int proxyPort, String proxyUsername, Secret proxyPassword, boolean buildStatus, List<String> policyIds, List<String> policyNames, String excludedCids, boolean excludedCriteria, String failCriteria) {
        this.ipAddress = ipAddress;
        this.buildStatus = buildStatus;
        this.scanDuration = scanDuration;
        this.scanLaunchDate = scanLaunchDate;
        this.policyIds = policyIds;
        this.policyNames = policyNames;
        this.excludedCids = excludedCids;
        this.excludedCriteria = excludedCriteria;
        this.failCriteria = failCriteria;
        this.scanId = scanId;
        this.scanRef = scanRef;
        this.scanName = scanName;
        this.platformUrl = platformUrl;
        this.authRecord = authRecord;
        this.scanTarget = ipAddress;
        this.scanStatustUrl = "/fo/report/compliance_scan_result.php?id=" + scanId;
        this.run = run;
    }

    public String getScanId() {
        return this.scanId;
    }

    public String getExcludedControls() {
        if (this.excludedCriteria) {
            return this.excludedCids;
        }
        return "";
    }

    public String getPolicyList() {
        String strPolicy = "";
        for (String policy : this.policyNames) {
            strPolicy = strPolicy + "\"" + policy + "\",";
        }
        strPolicy = strPolicy.substring(0, strPolicy.length() - 1);
        return strPolicy;
    }

    public List<JSONObject> getControlsList() {
        ArrayList<JSONObject> controlList = new ArrayList<JSONObject>();
        for (int i = 0; i < this.scanResult.size(); ++i) {
            String policyName = this.scanResult.names().getString(i);
            JSONObject policyValue = (JSONObject)this.scanResult.get(policyName);
            JSONObject pValue = new JSONObject();
            pValue = (JSONObject)policyValue.get("controls");
            for (int j = 0; j < pValue.size(); ++j) {
                JSONObject control = new JSONObject();
                String cId = pValue.names().getString(j);
                JSONObject cValue = (JSONObject)pValue.get(cId);
                control.put("pName", (Object)policyName);
                control.put("cid", (Object)cId);
                control.put("status", cValue.get("status"));
                control.put("statement", cValue.get("statement"));
                control.put("criticality", cValue.get("criticality"));
                control.put("unexpected_values", cValue.get("unexpected_values"));
                control.put("missing_values", cValue.get("missing_values"));
                controlList.add(control);
            }
        }
        return controlList;
    }

    public String getAuthRecord() {
        if (this.authRecord != null) {
            return this.authRecord;
        }
        return "-";
    }

    public String getScanRef() {
        return this.scanRef;
    }

    public String getScanTarget() {
        return this.ipAddress;
    }

    public String getScanName() {
        return this.scanName;
    }

    public String getScanDuration() {
        return this.scanDuration;
    }

    public String getScanLaunchDate() {
        return this.scanLaunchDate;
    }

    public String getScanStatusUrl() {
        return this.platformUrl + this.scanStatustUrl;
    }

    public String getFailCriteria() {
        return this.failCriteria;
    }

    public String getBuildStatus() {
        if (this.buildStatus) {
            return "FAILED";
        }
        return "PASSED";
    }

    @JavaScriptMethod
    public JSONObject getScanResults() {
        JSONObject result = new JSONObject();
        this.scanResult = new JSONObject();
        if (this.policyIds != null) {
            for (String policy : this.policyIds) {
                JSONObject respObj = null;
                try {
                    String resultStr;
                    String filename = this.run.getArtifactsDir().getAbsolutePath() + File.separator + "qualys_" + policy + ".json";
                    File f = new File(filename);
                    Gson gson = new Gson();
                    if (!f.exists()) continue;
                    String resultStrClean = resultStr = FileUtils.readFileToString((File)f);
                    JsonReader jr = new JsonReader((Reader)new StringReader(resultStrClean.trim()));
                    jr.setLenient(true);
                    respObj = (JSONObject)gson.fromJson(jr, JSONObject.class);
                    int pos = this.policyIds.indexOf(policy);
                    result.put(this.policyNames.get(pos), (Object)respObj);
                }
                catch (Exception e) {
                    logger.info("Error parsing scan Result for policy: " + e.getMessage());
                    this.scanResult.put("error", (Object)e.getMessage());
                }
            }
        }
        this.scanResult = result;
        return this.scanResult;
    }

    public String getIconFileName() {
        return "/plugin/qualys-pc/images/tinyLogo.png";
    }

    public String getDisplayName() {
        return "Qualys PC Scan Report for " + this.scanTarget.toString();
    }

    public String getUrlName() {
        return "qualys_pc_scan_report_" + this.scanTarget.toString() + ".html";
    }
}

