/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.pc.auth;

import hudson.util.Secret;
import java.util.ArrayList;
import java.util.List;

public class QualysAuth {
    private String server;
    private String username;
    private Secret password;
    private String authKey;
    private String proxyServer;
    private String proxyUsername;
    private boolean useProxy = false;
    private Secret proxyPassword;
    private int proxyPort;
    private String gatewayURL = null;
    public static List<String> serverPlatformURL = new ArrayList<String>();
    public static List<String> serverApiURL = new ArrayList<String>();
    public static List<String> serverGatewayURL = new ArrayList<String>();

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setProxyPassword(Secret proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getServer() {
        if (this.server == null) {
            return "https://qualysapi.qualys.com";
        }
        return this.server.replace("qualysguard", "qualysapi");
    }

    public String getServerPlatformUrl() {
        if (this.gatewayURL == null) {
            int pos;
            if (this.server.endsWith("/")) {
                this.server = this.server.substring(0, this.server.length() - 1);
            }
            if ((pos = serverPlatformURL.indexOf(this.server)) == -1) {
                pos = serverApiURL.indexOf(this.server);
            }
            if (pos == -1) {
                pos = serverGatewayURL.indexOf(this.server);
            }
            this.gatewayURL = pos == -1 ? this.server : serverPlatformURL.get(pos);
        }
        return this.gatewayURL;
    }

    public String getServerForTestConnection() {
        if (this.gatewayURL == null) {
            int pos;
            if (this.server.endsWith("/")) {
                this.server = this.server.substring(0, this.server.length() - 1);
            }
            if ((pos = serverPlatformURL.indexOf(this.server)) == -1) {
                pos = serverApiURL.indexOf(this.server);
            }
            if (pos == -1) {
                pos = serverGatewayURL.indexOf(this.server);
            }
            this.gatewayURL = pos == -1 ? this.server.replace("https://qualysapi.", "https://qualysgateway.") : serverGatewayURL.get(pos);
        }
        return this.gatewayURL;
    }

    public String getUsername() {
        if (this.username == null) {
            return "";
        }
        return this.username;
    }

    public Secret getPassword() {
        if (this.password == null) {
            return Secret.fromString((String)"");
        }
        return this.password;
    }

    public String getProxyServer() {
        if (this.proxyServer == null) {
            return "";
        }
        return this.proxyServer;
    }

    public String getProxyUsername() {
        if (this.proxyUsername == null) {
            return "";
        }
        return this.proxyUsername;
    }

    public Secret getProxyPassword() {
        if (this.proxyPassword == null) {
            return Secret.fromString((String)"");
        }
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public boolean getUseProxy() {
        if (this.useProxy) {
            return true;
        }
        return this.useProxy;
    }

    public void setQualysCredentials(String server, String username, String password) {
        this.server = server;
        this.username = username;
        this.password = Secret.fromString((String)password);
    }

    public void setProxyCredentials(String proxyServer, int proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.useProxy = useProxy;
        this.proxyUsername = proxyUsername != null ? proxyUsername : null;
        this.proxyPassword = proxyPassword != null ? Secret.fromString((String)proxyPassword) : null;
    }

    static {
        serverPlatformURL.add("https://qualysguard.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg2.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg3.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qg4.apps.qualys.com");
        serverPlatformURL.add("https://qualysguard.qualys.eu");
        serverPlatformURL.add("https://qualysguard.qg2.apps.qualys.eu");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.in");
        serverPlatformURL.add("https://qualysguard.qg1.apps.qualys.ca");
        serverApiURL.add("https://qualysapi.qualys.com");
        serverApiURL.add("https://qualysapi.qg2.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qg3.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qg4.apps.qualys.com");
        serverApiURL.add("https://qualysapi.qualys.eu");
        serverApiURL.add("https://qualysapi.qg2.apps.qualys.eu");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.in");
        serverApiURL.add("https://qualysapi.qg1.apps.qualys.ca");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg2.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg3.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg4.apps.qualys.com");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.eu");
        serverGatewayURL.add("https://gateway.qg2.apps.qualys.eu");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.in");
        serverGatewayURL.add("https://gateway.qg1.apps.qualys.ca");
    }
}

