/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.pc;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qualys.plugins.pc.PCScanEc2ConnectorLauncher;
import com.qualys.plugins.pc.PCScanLauncher;
import com.qualys.plugins.pc.auth.QualysAuth;
import com.qualys.plugins.pc.client.QualysPCClient;
import com.qualys.plugins.pc.client.QualysPCResponse;
import com.qualys.plugins.pc.util.Helper;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jenkinsci.Symbol;
import org.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PCScanNotifier
extends Notifier
implements SimpleBuildStep {
    private String apiServer;
    private String credsId;
    private String hostIp;
    private String ec2Id;
    private String ec2ConnDetails;
    private String ec2ConnName;
    private String ec2ConnAccountId;
    private String ec2ConnId;
    private String scanName;
    private String scannerName;
    private String optionProfile;
    private String proxyServer;
    private int proxyPort;
    private String proxyCredentialsId;
    private boolean useProxy = false;
    private boolean useHost = false;
    private boolean useEc2 = false;
    private boolean runConnector = false;
    private String pluginName = "Qualys PC Scanning Connector";
    private String pollingInterval;
    private String vulnsTimeout;
    private String selectedPolicies;
    private String excludedCids;
    private boolean failByAuth;
    private boolean criticalityMinimal;
    private boolean criticalityMedium;
    private boolean criticalityCritical;
    private boolean criticalityUrgent;
    private boolean criticalitySerious;
    private boolean stateExceptions;
    private boolean stateError;
    private boolean stateFail;
    private String optionProfileName;
    private String unixAndWindowsCredentialsId;
    private boolean createAuthRecord = false;
    private JSONObject selectedPoliciesJson;
    private String unixAndWindowsCredentials;
    private boolean failByStateAndCriticality;
    private boolean excludedCriteria;
    private String platform;
    private String hostIpValue;
    private String ec2IdValue;
    private static final String SCAN_NAME = "[job_name]_jenkins_build_[build_number]";
    private static final int PROXY_PORT = 80;
    private static QualysPCResponse optionProfileRawData;
    private static final Logger logger;

    public PCScanNotifier() {
    }

    public String getCredsId() {
        return this.credsId;
    }

    @DataBoundSetter
    public void setCredsId(String cred) {
        this.credsId = cred;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    @DataBoundSetter
    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public String getVulnsTimeout() {
        return this.vulnsTimeout;
    }

    @DataBoundSetter
    public void setVulnsTimeout(String vulnsTimeout) {
        this.vulnsTimeout = vulnsTimeout;
    }

    public String getApiServer() {
        return this.apiServer;
    }

    @DataBoundSetter
    public void setApiServer(String apiServer) {
        if (apiServer != null && apiServer.endsWith("/")) {
            apiServer = apiServer.substring(0, apiServer.length() - 1);
        }
        this.apiServer = apiServer;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    @DataBoundSetter
    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getEc2Id() {
        return this.ec2Id;
    }

    @DataBoundSetter
    public void setEc2Id(String ec2Id) {
        this.ec2Id = ec2Id;
    }

    public String getEc2ConnDetails() {
        return this.ec2ConnDetails;
    }

    @DataBoundSetter
    public void setEc2ConnDetails(String ec2ConnDetails) {
        this.ec2ConnDetails = ec2ConnDetails;
    }

    public String getEc2ConnName() {
        return this.ec2ConnName;
    }

    @DataBoundSetter
    public void setEc2ConnName(String ec2ConnName) {
        this.ec2ConnName = ec2ConnName;
    }

    public String getEc2ConnAccountId() {
        return this.ec2ConnAccountId;
    }

    @DataBoundSetter
    public void setEc2ConnAccountId(String ec2ConnAccountId) {
        this.ec2ConnAccountId = ec2ConnAccountId;
    }

    public String getEc2ConnId() {
        return this.ec2ConnId;
    }

    @DataBoundSetter
    public void setEc2ConnId(String ec2ConnId) {
        this.ec2ConnId = ec2ConnId;
    }

    public boolean getRunConnector() {
        return this.runConnector;
    }

    @DataBoundSetter
    public void setRunConnector(boolean runConnector) {
        this.runConnector = runConnector;
    }

    public String getScannerName() {
        return this.scannerName;
    }

    @DataBoundSetter
    public void setScannerName(String scannerName) {
        this.scannerName = scannerName;
    }

    public String getScanName() {
        return this.scanName;
    }

    @DataBoundSetter
    public void setScanName(String scanName) {
        this.scanName = scanName = StringUtils.isBlank((String)scanName) ? SCAN_NAME : scanName;
    }

    public String getOptionProfile() {
        return this.optionProfile;
    }

    @DataBoundSetter
    public void setOptionProfile(String optionProfile) {
        this.optionProfile = optionProfile;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    @DataBoundSetter
    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort = proxyPort <= 0 ? 80 : proxyPort;
    }

    public String getProxyCredentialsId() {
        return this.proxyCredentialsId;
    }

    @DataBoundSetter
    public void setProxyCredentialsId(String proxyCredentialsId) {
        this.proxyCredentialsId = proxyCredentialsId;
    }

    public String getUnixAndWindowsCredentialsId() {
        return this.unixAndWindowsCredentialsId;
    }

    @DataBoundSetter
    public void setUnixAndWindowsCredentialsId(String unixAndWindowsCredentialsId) {
        this.unixAndWindowsCredentialsId = unixAndWindowsCredentialsId;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public boolean getUseHost() {
        return this.useHost;
    }

    @DataBoundSetter
    public void setUseHost(boolean useHost) {
        this.useHost = useHost;
    }

    public boolean getUseEc2() {
        return this.useEc2;
    }

    @DataBoundSetter
    public void setUseEc2(boolean useEc2) {
        this.useEc2 = useEc2;
    }

    public boolean getStateFail() {
        return this.stateFail;
    }

    @DataBoundSetter
    public void setStateFail(boolean stateFail) {
        this.stateFail = stateFail;
    }

    public boolean getStateError() {
        return this.stateError;
    }

    @DataBoundSetter
    public void setStateError(boolean stateError) {
        this.stateError = stateError;
    }

    public boolean getStateExceptions() {
        return this.stateExceptions;
    }

    @DataBoundSetter
    public void setStateExceptions(boolean stateExceptions) {
        this.stateExceptions = stateExceptions;
    }

    public boolean getCriticalitySerious() {
        return this.criticalitySerious;
    }

    @DataBoundSetter
    public void setCriticalitySerious(boolean criticalitySerious) {
        this.criticalitySerious = criticalitySerious;
    }

    public boolean getCriticalityUrgent() {
        return this.criticalityUrgent;
    }

    @DataBoundSetter
    public void setCriticalityUrgent(boolean criticalityUrgent) {
        this.criticalityUrgent = criticalityUrgent;
    }

    public boolean getCriticalityCritical() {
        return this.criticalityCritical;
    }

    @DataBoundSetter
    public void setCriticalityCritical(boolean criticalityCritical) {
        this.criticalityCritical = criticalityCritical;
    }

    public boolean getCriticalityMedium() {
        return this.criticalityMedium;
    }

    @DataBoundSetter
    public void setCriticalityMedium(boolean criticalityMedium) {
        this.criticalityMedium = criticalityMedium;
    }

    public boolean getCriticalityMinimal() {
        return this.criticalityMinimal;
    }

    @DataBoundSetter
    public void setCriticalityMinimal(boolean criticalityMinimal) {
        this.criticalityMinimal = criticalityMinimal;
    }

    public boolean getFailByAuth() {
        return this.failByAuth;
    }

    @DataBoundSetter
    public void setFailByAuth(boolean failByAuth) {
        this.failByAuth = failByAuth;
    }

    public String getExcludedCids() {
        return this.excludedCids;
    }

    @DataBoundSetter
    public void setExcludedCids(String excludedCids) {
        this.excludedCids = excludedCids;
    }

    public String getSelectedPolicies() {
        return this.selectedPolicies;
    }

    @DataBoundSetter
    public void setSelectedPolicies(String selectedPolicies) {
        this.selectedPolicies = selectedPolicies;
    }

    public boolean getFailByStateAndCriticality() {
        return this.failByStateAndCriticality;
    }

    @DataBoundSetter
    public void setFailByStateAndCriticality(boolean failByStateAndCriticality) {
        this.failByStateAndCriticality = failByStateAndCriticality;
    }

    public boolean getCreateAuthRecord() {
        return this.createAuthRecord;
    }

    @DataBoundSetter
    public void setCreateAuthRecord(boolean createAuthRecord) {
        this.createAuthRecord = createAuthRecord;
    }

    public String getUnixAndWindowsCredentials() {
        return this.unixAndWindowsCredentials;
    }

    @DataBoundSetter
    public void setUnixAndWindowsCredentials(String unixAndWindowsCredentials) {
        this.unixAndWindowsCredentials = unixAndWindowsCredentials;
    }

    public boolean getExcludedCriteria() {
        return this.excludedCriteria;
    }

    public String getPlatform() {
        return this.platform;
    }

    @DataBoundSetter
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @DataBoundSetter
    public void setExcludedCriteria(boolean excludedCriteria) {
        this.excludedCriteria = excludedCriteria;
    }

    @DataBoundConstructor
    public PCScanNotifier(String apiServer, String credsId, boolean useProxy, boolean createAuthRecord, String proxyServer, int proxyPort, String proxyCredentialsId, String unixAndWindowsCredentialsId, String scanName, boolean useHost, String hostIp, boolean useEc2, String ec2Id, String ec2ConnDetails, boolean runConnector, String optionProfile, String scannerName, String selectedPolicies, boolean stateFail, boolean stateError, boolean stateExceptions, boolean criticalitySerious, boolean criticalityUrgent, boolean criticalityCritical, boolean criticalityMedium, boolean criticalityMinimal, boolean failByAuth, String excludedCids, String pollingInterval, String vulnsTimeout, String unixAndWindowsCredentials, boolean failByStateAndCriticality, boolean excludedCriteria, String platform) {
        this.platform = platform;
        if (platform != null && platform.equalsIgnoreCase("pcp")) {
            this.apiServer = apiServer;
        }
        this.credsId = credsId;
        this.scanName = scanName;
        this.optionProfile = optionProfile;
        this.createAuthRecord = createAuthRecord;
        this.failByStateAndCriticality = failByStateAndCriticality;
        this.excludedCriteria = excludedCriteria;
        JsonParser jsonParser = new JsonParser();
        this.scannerName = scannerName;
        if (useProxy) {
            this.useProxy = useProxy;
            this.proxyServer = proxyServer;
            this.proxyPort = proxyPort;
            this.proxyCredentialsId = proxyCredentialsId;
        }
        if (useHost) {
            this.useHost = useHost;
            this.hostIp = hostIp;
        }
        if (useEc2) {
            this.useEc2 = useEc2;
            this.ec2Id = ec2Id;
            this.runConnector = runConnector;
            this.ec2ConnDetails = ec2ConnDetails == null || ec2ConnDetails.isEmpty() ? "{\"NoConnectorSelected\":{\"awsAccountId\":0,\"id\":0,\"connectorState\":0}}" : ec2ConnDetails;
            JsonObject jo = (JsonObject)jsonParser.parse(this.ec2ConnDetails);
            this.ec2ConnName = jo.keySet().toString().replaceAll("\\[|\\]", "");
            JsonObject i = jo.get(this.ec2ConnName).getAsJsonObject();
            this.ec2ConnAccountId = i.get("awsAccountId").getAsString();
            this.ec2ConnId = i.get("id").getAsString();
        }
        if (createAuthRecord) {
            this.unixAndWindowsCredentials = unixAndWindowsCredentials;
            this.unixAndWindowsCredentialsId = unixAndWindowsCredentialsId;
        }
        this.pollingInterval = pollingInterval;
        this.vulnsTimeout = vulnsTimeout;
        this.selectedPolicies = selectedPolicies;
        if (failByStateAndCriticality) {
            this.stateFail = stateFail;
            this.stateError = stateError;
            this.stateExceptions = stateExceptions;
            this.criticalitySerious = criticalitySerious;
            this.criticalityUrgent = criticalityUrgent;
            this.criticalityCritical = criticalityCritical;
            this.criticalityMedium = criticalityMedium;
            this.criticalityMinimal = criticalityMinimal;
        }
        this.failByAuth = failByAuth;
        if (excludedCriteria) {
            this.excludedCids = excludedCids;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getPluginVersion() {
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = new File("pom.xml").exists() ? reader.read((Reader)new FileReader("pom.xml")) : reader.read((Reader)new InputStreamReader(PCScanNotifier.class.getResourceAsStream("/META-INF/maven/com.qualys.plugins/qualys-pc/pom.xml")));
            return model.getVersion();
        }
        catch (Exception e) {
            logger.info("Exception while reading plugin version; Reason :" + e.getMessage());
            return "unknown";
        }
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        long startTime = System.currentTimeMillis();
        Job project = null;
        logger.info("Triggered build #" + run.number);
        try {
            String version = this.getPluginVersion();
            taskListener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " " + this.pluginName + " scan task started (version-" + version + ").");
            logger.info(this.pluginName + " (version-" + version + ") started.");
        }
        catch (Exception e) {
            taskListener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " " + this.pluginName + " scan task - Started.");
            logger.info(this.pluginName + " started.");
        }
        this.extractEnvVariables(run.getEnvironment(taskListener), taskListener);
        if (this.useHost && StringUtils.isNotBlank((String)this.hostIp) || this.useEc2 && StringUtils.isNotBlank((String)this.ec2Id)) {
            try {
                project = run.getParent();
                this.launchHostScan(run, taskListener, (Item)project);
            }
            catch (Exception e) {
                if (e.toString().equalsIgnoreCase("java.lang.Exception")) {
                    throw new AbortException("Exception in " + this.pluginName + " scan result. Finishing the build.");
                }
                if (e.getMessage().equalsIgnoreCase("sleep interrupted")) {
                    logger.log(Level.SEVERE, "Error: User Aborted");
                    throw new AbortException("Exception in " + this.pluginName + " scan result: User Aborted");
                }
                logger.log(Level.SEVERE, "Error: " + e.getMessage());
                throw new AbortException("Exception in " + this.pluginName + " scan result: Finishing the build. Reason: " + e.getMessage());
            }
            finally {
                long endTime = System.currentTimeMillis();
                long time = endTime - startTime;
                taskListener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Total time taken to complete the build: " + Helper.longToTime(time));
                logger.info("Total time taken to complete the build: " + Helper.longToTime(time));
            }
        } else {
            taskListener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " No Host IP or EC2 Instance Id Configured.");
            throw new AbortException("Host IP or EC2 Instance Id can't be set to null or empty.");
        }
    }

    public void launchHostScan(Run<?, ?> run, TaskListener listener, Item project) throws Exception {
        JsonObject connectorState = new JsonObject();
        connectorState.addProperty("state", Boolean.valueOf(true));
        JsonObject instanceState = new JsonObject();
        instanceState.addProperty("endpoint", "Unknown");
        Helper h = new Helper();
        QualysAuth auth = new QualysAuth();
        String instanceStatus = new String();
        Map<String, String> platformObj = Helper.platformsList.get(this.platform);
        String portalUrl = this.apiServer;
        if (!this.platform.equalsIgnoreCase("pcp")) {
            this.setApiServer(platformObj.get("url"));
            logger.info("Using qualys API Server URL: " + this.apiServer);
        }
        listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Qualys Platform: " + this.platform + ". Using Qualys API server: " + this.apiServer);
        QualysPCClient client = h.getClient(this.useProxy, this.apiServer, this.credsId, this.proxyServer, this.proxyPort, this.proxyCredentialsId, project);
        try {
            String log = " Testing connection with Qualys API Server...";
            String string = " Test connection successful.";
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + log);
            logger.info(log);
            if (this.platform.equalsIgnoreCase("pcp")) {
                client.testConnection();
            } else {
                client.testConnectionUsingGatewayAPI();
            }
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + string);
            logger.info(string);
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Test connection failed. Reason: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        try {
            auth = h.getQualysAuth(this.useProxy, this.apiServer, this.credsId, this.proxyServer, this.proxyPort, this.proxyCredentialsId, project);
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Error while setting Qualys Credentials. Reason: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        try {
            if (this.useEc2) {
                PCScanEc2ConnectorLauncher ctor = new PCScanEc2ConnectorLauncher(run, listener, this.pollingInterval, this.vulnsTimeout, auth, this.useEc2, this.ec2ConnId, this.ec2ConnName);
                listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Checking the state of instance(" + this.ec2IdValue + ") with instance account(" + this.ec2ConnAccountId + ")");
                instanceState = ctor.checkInstanceState(this.ec2IdValue, this.ec2ConnAccountId);
                instanceStatus = instanceState.get("instanceState").getAsString();
                if (instanceState.get("count").getAsInt() == 0) {
                    listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Checking the state of connector: " + this.ec2ConnName);
                    String string = ctor.getCtorStatus(this.ec2ConnId, true);
                    String logMsg = " Run connector checkbox: " + (this.runConnector ? "checked" : "unchecked");
                    logger.info(logMsg);
                    listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + logMsg);
                    boolean recheckInstanceState = false;
                    if (!this.runConnector && !instanceStatus.equalsIgnoreCase("RUNNING")) {
                        throw new Exception("Instance state is: " + instanceStatus + ". Could not find the provided instance ID with a given EC2 configuration. The user might have provided the wrong instance/connector/scanner details. Re-check the EC2 details provided for the scan.");
                    }
                    if (this.runConnector && this.runCtorDecision(string, listener)) {
                        logger.info(this.pluginName + " task - Started running the Ec2 Connector: " + this.ec2ConnName);
                        ctor.runCtor();
                        logger.info(this.pluginName + " task - Finished running Ec2 Connector: " + this.ec2ConnName);
                        recheckInstanceState = true;
                    } else if (this.runConnector && !this.runCtorDecision(string, listener)) {
                        ctor.ctorPolling(this.ec2ConnId, false);
                        recheckInstanceState = true;
                    }
                    if (recheckInstanceState) {
                        listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Checking the state of instance(" + this.ec2IdValue + ") with instance account(" + this.ec2ConnAccountId + ")");
                        instanceState = ctor.checkInstanceState(this.ec2IdValue, this.ec2ConnAccountId);
                        instanceStatus = instanceState.get("instanceState").getAsString();
                        if (!instanceStatus.equalsIgnoreCase("RUNNING")) {
                            throw new Exception("Instance state is: " + instanceStatus + ". Could not find the provided instance ID with a given EC2 configuration. The user might have provided the wrong instance/connector/scanner details. Re-check the EC2 details provided for the scan.");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Error while checking ec2 details. Reason: " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw new Exception(e.getMessage());
        }
        try {
            JSONObject jSONObject;
            String ec2PrivateIpAddress = "";
            if (this.useEc2) {
                ec2PrivateIpAddress = instanceState.get("ec2PrivateIpAddress").getAsString();
            }
            if (this.selectedPolicies != null && !this.selectedPolicies.isEmpty()) {
                jSONObject = new JSONObject();
                String[] allPolicy = this.selectedPolicies.split(",,");
                for (int i = 0; i < allPolicy.length; ++i) {
                    String[] policyDetails = allPolicy[i].split("::");
                    jSONObject.put(policyDetails[0], (Object)policyDetails[1]);
                }
            } else {
                throw new Exception("No policies are selected for the scan or there are no policies present in the selected option profile.");
            }
            this.selectedPoliciesJson = jSONObject;
            JsonParser jsonParser = new JsonParser();
            if (!this.optionProfile.trim().equals("")) {
                JsonObject optionProfileJson = (JsonObject)jsonParser.parse(this.optionProfile);
                this.optionProfileName = optionProfileJson.get("optionProfileName").getAsString();
            }
            PCScanLauncher launcher = new PCScanLauncher(run, listener, this.hostIpValue, this.ec2IdValue, this.ec2ConnName, instanceState.get("endpoint").getAsString(), ec2PrivateIpAddress, this.scannerName, this.scanName, this.optionProfileName, this.pollingInterval, this.vulnsTimeout, this.useHost, this.useEc2, auth, this.selectedPoliciesJson, this.stateFail, this.stateError, this.stateExceptions, this.criticalitySerious, this.criticalityUrgent, this.criticalityCritical, this.criticalityMedium, this.criticalityMinimal, this.failByAuth, this.excludedCids, this.unixAndWindowsCredentialsId, this.unixAndWindowsCredentials, this.failByStateAndCriticality, this.excludedCriteria);
            launcher.addHost();
            if (this.createAuthRecord) {
                launcher.addAuthRecord();
            }
            launcher.addAssetGroup();
            launcher.updatePoliciesWithAssetGroup();
            boolean scanResult = launcher.getLaunchScanResult();
            if (scanResult) {
                launcher.getAndProcessLaunchReport();
            }
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " " + this.pluginName + " scan task - Finished.");
            logger.info(this.pluginName + " task - Finished.");
        }
        catch (Exception e) {
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Build stopped. Reason: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    public boolean runCtorDecision(String ec2ConnState, TaskListener listener) throws Exception {
        boolean run = false;
        ArrayList<String> conRunList = new ArrayList<String>();
        ArrayList<String> conNoRunList = new ArrayList<String>();
        conRunList.add("FINISHED_ERRORS");
        conRunList.add("ERROR");
        conRunList.add("INCOMPLETE");
        conRunList.add("FINISHED_SUCCESS");
        conRunList.add("SUCCESS");
        conNoRunList.add("RUNNING");
        conNoRunList.add("PENDING");
        conNoRunList.add("QUEUED");
        conNoRunList.add("PROCESSING");
        if (ec2ConnState.equalsIgnoreCase("DISABLED")) {
            logger.warning("Connector is in " + ec2ConnState + " state. Aborting!!");
            throw new Exception("Connector is in " + ec2ConnState + " state. Aborting!!");
        }
        if (conNoRunList.contains(ec2ConnState)) {
            logger.warning("Connector state is " + ec2ConnState + ". Not running the connector!");
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Connector state is " + ec2ConnState + ". Not running the connector!");
            run = false;
        } else if (conRunList.contains(ec2ConnState)) {
            logger.warning("Connector state is " + ec2ConnState + ". Running the connector!");
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Connector state is " + ec2ConnState + ". Running the connector!");
            run = true;
        }
        return run;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractEnvVariables(EnvVars envVars, TaskListener listener) throws AbortException {
        if (this.useHost && this.hostIp != null && !this.hostIp.isEmpty()) {
            if (this.hostIp.startsWith("env.") && envVars != null && !envVars.isEmpty()) {
                String envHostIpKey = this.hostIp.replaceFirst("env.", "");
                this.hostIpValue = (String)envVars.get((Object)envHostIpKey);
                if (this.hostIpValue == null || this.hostIpValue.isEmpty()) throw new AbortException("Host IP - Environment variable " + envHostIpKey + " is missing !!");
                logger.info("Host IP value from environment variable is - " + this.hostIpValue);
                listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " Host IP value from environment variable is - " + this.hostIpValue);
            } else {
                this.hostIpValue = this.hostIp;
            }
        }
        if (!this.useEc2 || this.ec2Id == null || this.ec2Id.isEmpty()) return;
        if (this.ec2Id.startsWith("env.") && envVars != null && !envVars.isEmpty()) {
            String envEc2IdKey = this.ec2Id.replaceFirst("env.", "");
            this.ec2IdValue = (String)envVars.get((Object)envEc2IdKey);
            if (this.ec2IdValue == null || this.ec2IdValue.isEmpty()) throw new AbortException("Host IP - Environment variable " + envEc2IdKey + " is missing !!");
            logger.info("ec2Id value from environment variable is - " + this.ec2IdValue);
            listener.getLogger().println(new Timestamp(System.currentTimeMillis()) + " ec2Id value from environment variable is - " + this.ec2IdValue);
            return;
        } else {
            this.ec2IdValue = this.ec2Id;
        }
    }

    static {
        logger = Helper.getLogger(PCScanNotifier.class.getName());
    }

    @Symbol(value={"qualysPolicyComplianceScanner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String DISPLAY_NAME = "Scan host/instances with Qualys PC";
        private static final String URL_REGEX = "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        private static final String PROXY_REGEX = "^((https?)://)?[-a-zA-Z0-9+&@#/%?=~_|!,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        private static final String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";
        private static final String HOST_IP = "^\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
        private static final String awsAccountId = "awsAccountId";
        private static final String utf8Error = "Provide valid UTF-8 string value.";
        private static final String displayName = "Scan host/instances with Qualys PC";
        static JsonObject ctorNameList = new JsonObject();
        Helper h = new Helper();

        public FormValidation doCheckName(@QueryParameter String value, @QueryParameter boolean useFrench) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Scan host/instances with Qualys PC";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckApiServer(@QueryParameter String apiServer) {
            if (this.isNonUTF8String(apiServer)) {
                return FormValidation.error((String)utf8Error);
            }
            try {
                if (apiServer == null || apiServer.trim().equals("")) {
                    return FormValidation.error((String)"Server Name cannot be empty");
                }
                String server = apiServer.trim();
                Pattern patt = Pattern.compile(URL_REGEX);
                Matcher matcher = patt.matcher(server);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Server name is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckCredsId(@QueryParameter String credsId) {
            try {
                if (credsId.trim().equals("")) {
                    return FormValidation.error((String)"API Credentials cannot be empty.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public ListBoxModel doFillCredsIdItems(@AncestorInPath Item item, @QueryParameter String credsId) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(credsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)credsId), (IdCredentials[])new StandardCredentials[0]);
        }

        @POST
        public ListBoxModel doFillUnixAndWindowsCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String unixAndWindowsCredentialsId) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(unixAndWindowsCredentialsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)unixAndWindowsCredentialsId), (IdCredentials[])new StandardCredentials[0]);
        }

        public FormValidation doCheckProxyServer(@QueryParameter String proxyServer) {
            if (this.isNonUTF8String(proxyServer)) {
                return FormValidation.error((String)utf8Error);
            }
            try {
                if (proxyServer == null || proxyServer.trim().equals("")) {
                    return FormValidation.error((String)"Proxy server URL cannot be empty");
                }
                String server = proxyServer.trim();
                Pattern patt = Pattern.compile(PROXY_REGEX);
                Matcher matcher = patt.matcher(server);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Enter valid server url!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckProxyPort(@QueryParameter String proxyPort) {
            block4: {
                try {
                    if (proxyPort != null && !proxyPort.trim().isEmpty()) {
                        int proxyPortInt = Integer.parseInt(proxyPort);
                        if (proxyPortInt < 1 || proxyPortInt > 65535) {
                            return FormValidation.error((String)"Enter a valid port number!");
                        }
                        break block4;
                    }
                    return FormValidation.error((String)"Port number cannot be empty");
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Enter valid port number!");
                }
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillProxyCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String proxyCredentialsId) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(proxyCredentialsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)proxyCredentialsId), (IdCredentials[])new StandardCredentials[0]);
        }

        public FormValidation doCheckHostIp(@QueryParameter String hostIp) {
            try {
                if (hostIp != null && StringUtils.isNotBlank((String)hostIp)) {
                    if (hostIp.startsWith("env.")) {
                        return FormValidation.ok();
                    }
                    Pattern patt = Pattern.compile(HOST_IP);
                    Matcher matcher = patt.matcher(hostIp);
                    if (!matcher.matches()) {
                        return FormValidation.error((String)"Host IP is not in valid format!");
                    }
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Provide a valid Host IP.");
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid Host Ip!");
            }
        }

        public FormValidation doCheckScanName(@QueryParameter String scanName) {
            if (this.isNonUTF8String(scanName)) {
                return FormValidation.error((String)utf8Error);
            }
            try {
                if (scanName.trim().equals("")) {
                    return FormValidation.error((String)"Scan Name cannot be empty.");
                }
                if (scanName.length() > 256) {
                    return FormValidation.error((String)"Scan Name length must be of 256 or less characters.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckEc2Id(@QueryParameter String ec2Id) {
            if (this.isNonUTF8String(ec2Id)) {
                return FormValidation.error((String)"Provide valid EC2 Instance Id.");
            }
            try {
                if (ec2Id.trim().equals("")) {
                    return FormValidation.error((String)"EC2 Instance Id cannot be empty.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckOptionProfile(@QueryParameter String optionProfile) {
            try {
                if (optionProfile.trim().equals("")) {
                    return FormValidation.error((String)"Select a Option Profile.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckFailByStateAndCriticality(@QueryParameter boolean failByStateAndCriticality, @QueryParameter boolean stateFail, @QueryParameter boolean stateError, @QueryParameter boolean stateExceptions, @QueryParameter boolean criticalitySerious, @QueryParameter boolean criticalityUrgent, @QueryParameter boolean criticalityCritical, @QueryParameter boolean criticalityMedium, @QueryParameter boolean criticalityMinimal) {
            try {
                if (failByStateAndCriticality) {
                    if (!(stateFail || stateError || stateExceptions)) {
                        return FormValidation.error((String)"Select at least one state");
                    }
                    if (!(criticalitySerious || criticalityUrgent || criticalityCritical || criticalityMedium || criticalityMinimal)) {
                        return FormValidation.error((String)"Select at least one criticality");
                    }
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckExcludedCids(@QueryParameter String excludedCids) {
            if (excludedCids == null || excludedCids.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                if (!Helper.isValidCidList(excludedCids)) {
                    return FormValidation.error((String)"Enter valid CID range/numbers!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Enter valid CID range/numbers! Error:" + e.getMessage()));
            }
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String pollingInterval) {
            try {
                String pollingIntervalVal = pollingInterval.trim();
                if (pollingIntervalVal.equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile(TIMEOUT_PERIOD_REGEX);
                Matcher matcher = patt.matcher(pollingIntervalVal);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + pollingInterval + ", reason = " + e));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVulnsTimeout(@QueryParameter String vulnsTimeout) {
            String vulnsTimeoutVal = vulnsTimeout.trim();
            try {
                if (vulnsTimeoutVal.equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile(TIMEOUT_PERIOD_REGEX);
                Matcher matcher = patt.matcher(vulnsTimeoutVal);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + vulnsTimeout + ", reason = " + e));
            }
        }

        @POST
        public FormValidation doCheckConnection(@QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy, @AncestorInPath Item item) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            try {
                String server;
                int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                String string = server = apiServer != null ? apiServer.trim() : "";
                if (!platform.equalsIgnoreCase("pcp")) {
                    Map<String, String> platformObj = Helper.platformsList.get(platform);
                    server = platformObj.get("url");
                    logger.info("Using qualys API Server URL: " + server);
                }
                QualysPCClient client = this.h.getClient(useProxy, server, credsId, proxyServer, proxyPortInt, proxyCredentialsId, item);
                if (platform.equalsIgnoreCase("pcp")) {
                    client.testConnection();
                } else {
                    client.testConnectionUsingGatewayAPI();
                }
                return FormValidation.ok((String)"Connection test successful!");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Connection test failed. (Reason: " + e.getMessage() + ")"));
            }
        }

        @POST
        public ListBoxModel doFillUnixAndWindowsCredentialsItems() {
            StandardListBoxModel model = new StandardListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("Windows", "windows");
            model.add((Object)e1);
            e1 = new ListBoxModel.Option("Unix", "unix");
            model.add((Object)e1);
            return model;
        }

        @POST
        public ListBoxModel doFillScannerNameItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy, @QueryParameter boolean useEc2, @QueryParameter boolean useHost) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            JsonObject scannerList = new JsonObject();
            ListBoxModel.Option e1 = new ListBoxModel.Option("Select the scanner appliance (Default - External)", "External");
            model.add((Object)e1);
            try {
                if (this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                        logger.info("Using qualys API Server URL: " + server);
                    }
                    QualysPCClient client = this.h.getClient(useProxy, server, credsId, proxyServer, proxyPortInt, proxyCredentialsId, item);
                    scannerList = useEc2 ? client.scannerName(false) : client.scannerName(true);
                    for (String name : scannerList.keySet()) {
                        ListBoxModel.Option e;
                        JsonObject jk = scannerList.get(name).getAsJsonObject();
                        String scanStatus = jk.get("status").getAsString();
                        String scanAccId = jk.get("accountId").getAsString();
                        if (useEc2) {
                            e = new ListBoxModel.Option(name + " (Account Id: " + scanAccId + " | Status: " + scanStatus + ")", name);
                            model.add((Object)e);
                            continue;
                        }
                        e = new ListBoxModel.Option(name + " (Status: " + scanStatus + ")", name);
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.warning("Error to get scanner list. " + e.getMessage());
                ListBoxModel.Option ee = new ListBoxModel.Option(e.getMessage(), "");
                model.add((Object)ee);
                return model;
            }
            model.sort(Helper.getOptionItemmsComparator());
            return model;
        }

        public ListBoxModel doFillPlatformItems() {
            ListBoxModel model = new ListBoxModel();
            for (Map<String, String> platform : this.getPlatforms()) {
                ListBoxModel.Option e = new ListBoxModel.Option(platform.get("name"), platform.get("code"));
                model.add((Object)e);
            }
            return model;
        }

        @POST
        public ListBoxModel doFillOptionProfileItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            Set<Object> nameList = new HashSet();
            ListBoxModel.Option e1 = new ListBoxModel.Option("Select the Option Profile", "");
            model.add((Object)e1);
            try {
                if (this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                        logger.info("Using qualys API Server URL: " + server);
                    }
                    QualysPCClient client = this.h.getClient(useProxy, server, credsId, proxyServer, proxyPortInt, proxyCredentialsId, item);
                    logger.info("Fetching Option Profiles list ... ");
                    optionProfileRawData = client.optionProfiles();
                    nameList = client.optionProfilesSet(optionProfileRawData.getResponseXml(), optionProfileRawData.getResponseCode(), "Option Profile PC");
                    for (String string2 : nameList) {
                        JSONObject jsonOptionDetails = new JSONObject();
                        String[] nameAndID = string2.split(":");
                        JSONObject jsonPolicyDetails = this.allPolicies(nameAndID[0]);
                        jsonOptionDetails.put("optionProfileName", (Object)nameAndID[0]);
                        jsonOptionDetails.put("optionProfileID", (Object)nameAndID[1]);
                        jsonOptionDetails.put("policyDetails", (Object)jsonPolicyDetails);
                        ListBoxModel.Option e = new ListBoxModel.Option(nameAndID[0], String.valueOf(jsonOptionDetails));
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.warning("Error to get option profile list. " + e.getMessage());
                ListBoxModel.Option ee = new ListBoxModel.Option(e.getMessage(), "");
                model.add((Object)ee);
                return model;
            }
            model.sort(Helper.getOptionItemmsComparator());
            return model;
        }

        public JSONObject allPolicies(String optionProfile) {
            JSONObject jsonPolicyDetails = new JSONObject();
            if (optionProfileRawData != null) {
                Document resp = optionProfileRawData.getResponseXml();
                NodeList opList = resp.getElementsByTagName("OPTION_PROFILE");
                try {
                    for (int i = 0; i < opList.getLength(); ++i) {
                        Node nNode = opList.item(i);
                        if (nNode.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode;
                        NodeList pList = eElement.getElementsByTagName("POLICY");
                        if (!optionProfile.toLowerCase().equals(eElement.getElementsByTagName("GROUP_NAME").item(0).getTextContent().toLowerCase())) continue;
                        for (int j = 0; j < pList.getLength(); ++j) {
                            Node pNode = pList.item(j);
                            Element pElement = (Element)pNode;
                            jsonPolicyDetails.put(pElement.getElementsByTagName("TITLE").item(0).getTextContent(), (Object)pElement.getElementsByTagName("ID").item(0).getTextContent());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warning("Error to get policy list. " + e.getMessage());
                }
            }
            return jsonPolicyDetails;
        }

        @POST
        public ListBoxModel doFillEc2ConnDetailsItems(@AncestorInPath Item item, @QueryParameter String platform, @QueryParameter String apiServer, @QueryParameter String credsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy, @QueryParameter boolean useEc2) {
            Jenkins.getInstance().checkPermission(Item.CONFIGURE);
            StandardListBoxModel model = new StandardListBoxModel();
            ListBoxModel.Option e1 = new ListBoxModel.Option("--select--", "");
            model.add((Object)e1);
            try {
                if (useEc2 && this.filledInputs(platform, apiServer, credsId, useProxy, proxyServer, proxyPort)) {
                    String server;
                    int proxyPortInt = this.doCheckProxyPort(proxyPort) == FormValidation.ok() ? Integer.parseInt(proxyPort) : 80;
                    String string = server = apiServer != null ? apiServer.trim() : "";
                    if (!platform.equalsIgnoreCase("pcp")) {
                        Map<String, String> platformObj = Helper.platformsList.get(platform);
                        server = platformObj.get("url");
                        logger.info("Using qualys API Server URL: " + server);
                    }
                    QualysPCClient client = this.h.getClient(useProxy, server, credsId, proxyServer, proxyPortInt, proxyCredentialsId, item);
                    logger.info("Fetching Ec2 connector name list ... ");
                    ctorNameList = client.getConnector();
                    for (String name : ctorNameList.keySet()) {
                        JsonObject jk = ctorNameList.get(name).getAsJsonObject();
                        JsonObject ConName = new JsonObject();
                        JsonObject ConNameDetails = new JsonObject();
                        String accId = jk.get(awsAccountId).getAsString();
                        String connectorState = jk.get("connectorState").getAsString();
                        ConNameDetails.addProperty(awsAccountId, accId);
                        ConNameDetails.addProperty("id", jk.get("id").getAsString());
                        ConName.add(name, (JsonElement)ConNameDetails);
                        ListBoxModel.Option e = new ListBoxModel.Option(name + " (Account Id:" + accId + " | State:" + connectorState + ")", ConName.toString());
                        model.add((Object)e);
                    }
                }
            }
            catch (Exception e) {
                ListBoxModel.Option e2 = new ListBoxModel.Option(e.getMessage(), "");
                model.add((Object)e2);
                logger.warning("There is an error while fetching the connectors list. " + e);
                return model;
            }
            model.sort(Helper.getOptionItemmsComparator());
            return model;
        }

        public boolean isNonUTF8String(String string) {
            if (string != null && !string.isEmpty()) {
                try {
                    byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }

        public boolean filledInputs(String platform, String apiServer, String credsId, boolean useProxy, String proxyServer, String proxyPort) {
            if (platform.equalsIgnoreCase("pcp") && StringUtils.isBlank((String)apiServer)) {
                return false;
            }
            if (StringUtils.isBlank((String)credsId)) {
                return false;
            }
            return !useProxy || !StringUtils.isBlank((String)proxyServer);
        }

        public List<Map<String, String>> getPlatforms() {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> platform : Helper.platformsList.entrySet()) {
                Map<String, String> obj = platform.getValue();
                result.add(obj);
            }
            return result;
        }
    }
}

