/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.pc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.pc.PCScanLauncher;
import com.qualys.plugins.pc.auth.QualysAuth;
import com.qualys.plugins.pc.client.APIResponseException;
import com.qualys.plugins.pc.client.QualysPCClient;
import com.qualys.plugins.pc.util.Helper;
import com.qualys.plugins.pc.util.TimeOutException;
import hudson.AbortException;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class PCScanEc2ConnectorLauncher {
    private PrintStream buildLogger;
    private String connId;
    private String ec2ConnName;
    private int pollingIntervalForVulns;
    private int vulnsTimeout;
    private QualysPCClient apiClient;
    private static final Logger logger = Helper.getLogger(PCScanLauncher.class.getName());
    private static final int DEFAULT_POLLING_INTERVAL_FOR_VULNS = 2;
    private static final int DEFAULT_TIMEOUT_FOR_VULNS = 60;
    private List<String> errorList;
    private List<String> successList;

    public PCScanEc2ConnectorLauncher(Run<?, ?> run, TaskListener listener, String pollingIntervalStr, String vulnsTimeoutStr, QualysAuth auth, boolean useEc2, String connId, String ec2ConnName) {
        this.buildLogger = listener.getLogger();
        this.connId = connId;
        this.ec2ConnName = ec2ConnName;
        this.apiClient = new QualysPCClient(auth, System.out);
        this.pollingIntervalForVulns = this.setTimeoutInMinutes("pollingInterval", 2, pollingIntervalStr, listener);
        this.vulnsTimeout = this.setTimeoutInMinutes("vulnsTimeout", 60, vulnsTimeoutStr, listener);
        this.errorList = new ArrayList<String>();
        this.errorList.add("FINISHED_ERRORS");
        this.errorList.add("ERROR");
        this.errorList.add("INCOMPLETE");
        this.errorList.add("DISABLED");
        this.successList = new ArrayList<String>();
        this.successList.add("FINISHED_SUCCESS");
        this.successList.add("SUCCESS");
    }

    private int setTimeoutInMinutes(String timeoutType, int defaultTimeoutInMins, String timeout, TaskListener listener) {
        if (timeout != null && !timeout.isEmpty()) {
            try {
                String[] numbers = timeout.split("\\*");
                int timeoutInMins = 1;
                for (int i = 0; i < numbers.length; ++i) {
                    timeoutInMins = (int)((long)timeoutInMins * Long.parseLong(numbers[i]));
                }
                return timeoutInMins;
            }
            catch (Exception e) {
                this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Invalid " + timeoutType + " time value. Cannot parse -" + e.getMessage() + "\n" + new Timestamp(System.currentTimeMillis()) + " Using default period of " + (timeoutType.equals("vulnsTimeout") ? "60" : Integer.valueOf(defaultTimeoutInMins)) + " minutes for " + timeoutType + ".");
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
            }
        }
        return defaultTimeoutInMins;
    }

    public void runCtor() throws Exception {
        try {
            JsonObject connectorRunState = this.apiClient.runConnector(this.connId);
            JsonElement connectorState = connectorRunState.get("connectorState");
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Making GET Request: " + connectorRunState.get("request").getAsString());
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Current connector state is: " + connectorRunState.get("connectorState").getAsString());
            if (connectorState == null || connectorState.isJsonNull() || connectorState.getAsString().isEmpty()) {
                throw new Exception("API error. Could not run the connector.");
            }
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Polling started!");
            this.ctorPolling(this.connId, false);
        }
        catch (AbortException e) {
            logger.info("AbortException while running connector. " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw new AbortException(e.getMessage());
        }
        catch (Exception e) {
            logger.info("Exception while running connector. " + e.getMessage());
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw new Exception(e.getMessage());
        }
    }

    public void ctorPolling(String connId, boolean sendToNotifier) throws Exception {
        String runStatus = null;
        long startTime = System.currentTimeMillis();
        long vulnsTimeoutInMillis = TimeUnit.MINUTES.toMillis(this.vulnsTimeout);
        long pollingInMillis = TimeUnit.MINUTES.toMillis(this.pollingIntervalForVulns);
        try {
            while ((runStatus = this.getCtorStatus(connId, sendToNotifier)) == null) {
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > vulnsTimeoutInMillis) {
                    this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Failed to get state result; timeout of " + this.vulnsTimeout + " minutes reached.");
                    throw new TimeOutException("Timeout reached.");
                }
                if (runStatus != null) continue;
                this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Waiting for " + this.pollingIntervalForVulns + " minute(s) before making next attempt for connector state of " + this.ec2ConnName + "(" + this.connId + ")");
                Thread.sleep(pollingInMillis);
            }
            if (runStatus != null && this.errorList.contains(runStatus)) {
                throw new AbortException("Aborting the build as the connector (" + this.ec2ConnName + ") state is: " + runStatus);
            }
        }
        catch (TimeOutException e) {
            String error = " Exception: Timeout reached.";
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
            logger.info(error);
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw e;
        }
        catch (Exception e) {
            String error = " Build Aborted!!\n";
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
            logger.info(error);
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            throw e;
        }
    }

    public String getCtorStatus(String connId2, boolean sendToNotifier) {
        JsonObject connectorState = null;
        String connectorStatus = null;
        try {
            connectorState = this.apiClient.getConnectorStatus(connId2);
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " " + connectorState.get("request").getAsString());
            JsonElement ctorState = connectorState.get("connectorState");
            if (ctorState != null && !ctorState.isJsonNull() && !ctorState.getAsString().isEmpty()) {
                connectorStatus = connectorState.get("connectorState").getAsString();
            }
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Current connector state is: " + connectorStatus);
            if (sendToNotifier) {
                return connectorStatus;
            }
        }
        catch (Exception e) {
            String error = " Exception while getting connector status. " + e.getMessage();
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + error);
            logger.info(error);
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
        }
        ArrayList<String> newList = new ArrayList<String>(this.errorList);
        newList.addAll(this.successList);
        if (connectorStatus != null && newList.contains(connectorStatus)) {
            return connectorStatus;
        }
        return null;
    }

    public JsonObject checkInstanceState(String ec2Id, String accountId) throws Exception {
        JsonObject instanceDetails = new JsonObject();
        try {
            instanceDetails = this.apiClient.getInstanceState(ec2Id, accountId);
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Making POST Request: " + instanceDetails.get("request").getAsString());
            if (instanceDetails.get("requestBody").getAsString() != null) {
                this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " API POST request body: " + instanceDetails.get("requestBody").getAsString());
            }
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Current instance state is: " + instanceDetails.get("instanceState").getAsString());
            if (instanceDetails.has("apiError")) {
                throw new APIResponseException("API response: " + instanceDetails.get("apiError").getAsString() + ". Check EC2 details provided to launch the scan.");
            }
        }
        catch (Exception e) {
            if (instanceDetails.has("apiError")) {
                throw e;
            }
            this.buildLogger.println(new Timestamp(System.currentTimeMillis()) + " Error getting instance state: " + e.getMessage());
        }
        if (instanceDetails.get("instanceState").getAsString().equalsIgnoreCase("RUNNING")) {
            instanceDetails.addProperty("state", Boolean.valueOf(true));
            return instanceDetails;
        }
        instanceDetails.addProperty("state", Boolean.valueOf(false));
        return instanceDetails;
    }
}

