/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms.test;

import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptor;
import de.zalando.spring.cloud.config.aws.kms.test.DecryptProperties;
import de.zalando.spring.cloud.config.aws.kms.test.EncryptProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class EncryptionCLI
implements CommandLineRunner {
    private final KmsTextEncryptor kmsTextEncryptor;
    private final EncryptProperties encrypt;
    private final DecryptProperties decrypt;

    @Autowired
    public EncryptionCLI(KmsTextEncryptor kmsTextEncryptor, EncryptProperties encrypt, DecryptProperties decrypt) {
        this.kmsTextEncryptor = kmsTextEncryptor;
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    private void printUsage() {
        System.out.println("Usage:\nMake sure that AWS credentials and region are set, either in ~/.aws/config, ~/.aws/credentials\nor via environment variables, e.g. `export AWS_REGION=eu-central-1`\n\nthen do\n./run.sh --encrypt.plaintext='Hello World!' --aws.kms.keyId='9d9fca31-54c5-4df5-ba4f-127dfb9a5031'\n./run.sh --decrypt.ciphertext='CiA47hYvQqWFFGq3TLtzQO5ArcwDkjq69Q=='");
    }

    public void run(String ... args) {
        String plaintext = this.encrypt.getPlaintext();
        String ciphertext = this.decrypt.getCiphertext();
        try {
            if (StringUtils.hasText((String)plaintext)) {
                System.out.println(this.kmsTextEncryptor.encrypt(plaintext));
            } else if (StringUtils.hasText((String)ciphertext)) {
                System.out.println(this.kmsTextEncryptor.decrypt(ciphertext));
            } else {
                this.printUsage();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.printUsage();
        }
    }
}

