/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.mvc.provider;

import com.qsyout.sdk.annotation.JsonResult;
import com.qsyout.sdk.mvc.provider.JsonResultResolver;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class JsonExceptionResolver
implements HandlerExceptionResolver {
    JsonResultResolver resolver;

    public JsonExceptionResolver(JsonResultResolver resolver) {
        this.resolver = resolver;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (handler instanceof HandlerMethod) {
            try {
                if (((HandlerMethod)handler).hasMethodAnnotation(JsonResult.class)) {
                    response.setStatus(HttpStatus.OK.value());
                    this.resolver.handleReturnValue(ex, ((HandlerMethod)handler).getReturnType(), null, (NativeWebRequest)new ServletWebRequest(request, response));
                } else if (((HandlerMethod)handler).hasMethodAnnotation(ResponseBody.class)) {
                    if (response.getStatus() == 200) {
                        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                    }
                    HashMap<String, Object> result = new HashMap<String, Object>(2);
                    result.put("status", 500);
                    result.put("message", ex.getMessage());
                    this.resolver.write(result, MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
                }
                return new ModelAndView();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return null;
    }
}

