/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk;

import com.qsyout.sdk.dao.IbatisDaoImpl;
import com.qsyout.sdk.declare.AuthInterceptor;
import com.qsyout.sdk.declare.ExceptionViewHandler;
import com.qsyout.sdk.declare.FileService;
import com.qsyout.sdk.declare.IbatisDao;
import com.qsyout.sdk.declare.MyMessageResolver;
import com.qsyout.sdk.intercept.LogRecord;
import com.qsyout.sdk.intercept.WebInterceptor;
import com.qsyout.sdk.mvc.provider.JsonExceptionResolver;
import com.qsyout.sdk.mvc.provider.JsonResultHandlerAdapter;
import com.qsyout.sdk.mvc.provider.JsonResultResolver;
import com.qsyout.sdk.mvc.provider.ViewExceptionResolver;
import com.qsyout.sdk.mvc.provider.XmlDefineHandlerMapping;
import com.qsyout.sdk.service.AsyncQueryDao;
import com.qsyout.sdk.service.LocaleFileService;
import com.qsyout.sdk.util.MailUtil;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.beetl.core.misc.BeetlUtil;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class WebSdkAutoConfiguration
implements WebMvcConfigurer {
    private WebInterceptor interceptor = new WebInterceptor();
    @Autowired
    Environment env;

    @PostConstruct
    public void init() {
        MailUtil.setEnv(this.env);
    }

    @Bean
    public SqlSessionFactory getSqlSessionFactoryBean(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setMapperLocations(resolver.getResources("classpath*:/sqlmap/**/*.xml"));
        return factory.getObject();
    }

    @Bean
    public IbatisDao getIbatisDao(SqlSessionFactory sqlSessionFactory) {
        IbatisDaoImpl ibatisDao = new IbatisDaoImpl();
        ibatisDao.setSqlSessionFactory(sqlSessionFactory);
        return ibatisDao;
    }

    @Bean
    public WebInterceptor createQsInterceptor(@Autowired(required=false) AuthInterceptor authInterceptor, @Autowired(required=false) LogRecord record) {
        this.interceptor.setAuthInterceptor(authInterceptor);
        this.interceptor.setRecord(record);
        this.interceptor.setDev("dev".equals(this.env.getProperty("spring.profiles.active")));
        this.interceptor.setAdminMail(this.env.getProperty("com.qsyout.sdk.mail.admin"));
        return this.interceptor;
    }

    @Bean
    public JsonResultResolver createJsonParameterResultResolver(@Autowired(required=false) MyMessageResolver resolver) {
        return new JsonResultResolver(resolver);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptor);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/", "file:" + BeetlUtil.getWebRoot() + "/"});
    }

    @Bean
    public JsonResultHandlerAdapter createFastJsonHandlerAdapter(RequestMappingHandlerAdapter adapter, JsonResultResolver resolver) {
        return new JsonResultHandlerAdapter(adapter.getApplicationContext(), resolver);
    }

    @Bean
    public XmlDefineHandlerMapping createXmlDefineHandlerMapping(ApplicationContext applicationContext) {
        return new XmlDefineHandlerMapping(applicationContext);
    }

    @Bean
    public JsonExceptionResolver createExceptionResolver(JsonResultResolver resolver) {
        return new JsonExceptionResolver(resolver);
    }

    @Bean
    @ConditionalOnBean(value={ExceptionViewHandler.class})
    public ViewExceptionResolver createViewExceptionResolver(ExceptionViewHandler handler) {
        return new ViewExceptionResolver(handler);
    }

    @Bean
    @ConditionalOnMissingBean(value={FileService.class})
    public FileService createFileService() {
        return new LocaleFileService(String.valueOf(BeetlUtil.getWebRoot()) + "/");
    }

    @Bean
    public AsyncQueryDao createAsyncQuerySqlService(IbatisDao ibatisDao) {
        int threads = 10;
        try {
            threads = Integer.valueOf(this.env.getProperty("com.qsyout.sdk.sync.dao.threads"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AsyncQueryDao(threads, ibatisDao);
    }
}

