/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.mvc.provider;

import com.qsyout.sdk.declare.BaseService;
import com.qsyout.sdk.mvc.method.DefinitionHandlerMethod;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class XmlDefineHandlerMapping
implements HandlerMapping,
InitializingBean,
Ordered {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HandlerInterceptor[] interceptors;
    private ApplicationContext applicationContext;
    private Map<String, DefinitionHandlerMethod> urls = new HashMap<String, DefinitionHandlerMethod>();

    public XmlDefineHandlerMapping(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new ApplicationContextException("Invalid application context: needs to be of type [" + this.requiredContextClass().getName() + "]");
        }
        Map mappedInterceptors = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, HandlerInterceptor.class, (boolean)true, (boolean)false);
        this.interceptors = new HandlerInterceptor[mappedInterceptors.size()];
        int i = 0;
        for (Map.Entry entry : mappedInterceptors.entrySet()) {
            this.interceptors[i] = (HandlerInterceptor)entry.getValue();
            ++i;
        }
        this.applicationContext = applicationContext;
    }

    private Class<?> requiredContextClass() {
        return ApplicationContext.class;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        DefinitionHandlerMethod handler = this.urls.get(this.urlPathHelper.getLookupPathForRequest(request));
        if (handler == null) {
            return null;
        }
        return new HandlerExecutionChain((Object)handler, this.interceptors);
    }

    public void afterPropertiesSet() throws Exception {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath*:/receives/**/*.xml");
        int i = 0;
        while (i < resources.length) {
            this.pathResolver(resources[i]);
            ++i;
        }
    }

    private void pathResolver(Resource resource) {
        try {
            String url = resource.getURL().toString();
            String xml = null;
            if (url.startsWith("jar")) {
                xml = url.substring(url.lastIndexOf("!") + 10);
                url = String.valueOf(url.substring(url.lastIndexOf("!") + 10, url.length() - 3)) + "do";
            } else {
                xml = url.substring(url.lastIndexOf("classes") + 16);
                url = String.valueOf(url.substring(url.lastIndexOf("classes") + 16, url.length() - 3)) + "do";
            }
            try {
                BaseService service = (BaseService)this.applicationContext.getBean(String.valueOf(url.substring(url.lastIndexOf("/") + 1, url.length() - 3)) + "Service", BaseService.class);
                try {
                    this.urls.put(url, new DefinitionHandlerMethod(service, new HandlerMethod((Object)service, "execute", new Class[]{Map.class}), xml));
                    this.logger.info("Registered fast api[{}] for {}.", (Object)url, (Object)service.getClass().getSimpleName());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getOrder() {
        return 1;
    }
}

