/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.mvc.provider;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.qsyout.sdk.annotation.JsonResult;
import com.qsyout.sdk.declare.BaseException;
import com.qsyout.sdk.declare.MyMessageResolver;
import com.qsyout.sdk.util.SubjectUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class JsonResultResolver
extends FastJsonHttpMessageConverter
implements HandlerMethodReturnValueHandler {
    private MyMessageResolver resolver;

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.hasMethodAnnotation(JsonResult.class);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        LinkedHashMap<String, Object> returnVal = new LinkedHashMap<String, Object>();
        boolean info = false;
        String message = "\u64cd\u4f5c\u6210\u529f";
        int status = 1200;
        Object data = null;
        if (returnValue instanceof BaseException) {
            info = true;
            message = this.resolver != null ? this.resolver.resolve(((BaseException)returnValue).getKey(), ((BaseException)returnValue).getMessage()) : ((BaseException)returnValue).getMessage();
            status = ((BaseException)returnValue).getStatus();
        } else if (returnValue instanceof Exception) {
            info = true;
            message = "\u7cfb\u7edf\u9519\u8bef";
            status = 2500;
        } else {
            data = returnValue;
            JsonResult result = (JsonResult)returnType.getMethodAnnotation(JsonResult.class);
            if (result != null) {
                info = result.info();
                message = result.message();
            }
            message = SubjectUtil.message() == null ? message : SubjectUtil.message();
        }
        returnVal.put("info", info);
        returnVal.put("message", message);
        returnVal.put("status", status);
        if (data != null) {
            returnVal.put("data", data);
        }
        if (mavContainer != null) {
            mavContainer.setRequestHandled(true);
        }
        super.writeInternal(returnVal, (HttpOutputMessage)new ServletServerHttpResponse((HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class)));
    }

    public JsonResultResolver(MyMessageResolver resolver) {
        this.resolver = resolver;
        ArrayList<MediaType> fastMediaTypes = new ArrayList<MediaType>();
        fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastMediaTypes.add(MediaType.APPLICATION_JSON);
        super.setSupportedMediaTypes(fastMediaTypes);
        super.setCharset(Charset.forName("UTF-8"));
        super.setDateFormat("yyyy-MM-dd HH:mm:ss");
        super.setFeatures(new SerializerFeature[]{SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.DisableCircularReferenceDetect});
    }
}

