/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.mvc.provider;

import com.qsyout.sdk.annotation.JsonResult;
import com.qsyout.sdk.ex.ParamsValidateException;
import com.qsyout.sdk.mvc.method.DefinitionHandlerMethod;
import com.qsyout.sdk.mvc.provider.JsonResultResolver;
import com.qsyout.validate.ex.ParameterCastException;
import com.qsyout.validate.ex.ParameterValidateException;
import com.qsyout.validate.resolvers.XmlDefinitionArgumentResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

public class JsonResultHandlerAdapter
extends AbstractHandlerMethodAdapter {
    private RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter(){

        protected ServletInvocableHandlerMethod createInvocableHandlerMethod(HandlerMethod handlerMethod) {
            return new FastJsonInvocableHandlerMethod(handlerMethod);
        }
    };

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public JsonResultHandlerAdapter(ApplicationContext context, JsonResultResolver resolver) {
        this.adapter.setApplicationContext(context);
        this.adapter.afterPropertiesSet();
        ArrayList<XmlDefinitionArgumentResolver> resolvers = new ArrayList<XmlDefinitionArgumentResolver>();
        resolvers.add(new XmlDefinitionArgumentResolver());
        resolvers.addAll(this.adapter.getArgumentResolvers());
        ArrayList<JsonResultResolver> returnValueHandlers = new ArrayList<JsonResultResolver>();
        returnValueHandlers.add(resolver);
        this.adapter.setArgumentResolvers(resolvers);
        this.adapter.setReturnValueHandlers(returnValueHandlers);
    }

    protected boolean supportsInternal(HandlerMethod handlerMethod) {
        return handlerMethod.hasMethodAnnotation(JsonResult.class);
    }

    protected ModelAndView handleInternal(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        response.setContentType(MediaType.APPLICATION_JSON_UTF8.toString());
        return this.adapter.handle(request, response, (Object)handlerMethod);
    }

    protected long getLastModifiedInternal(HttpServletRequest request, HandlerMethod handlerMethod) {
        return -1L;
    }

    public class FastJsonInvocableHandlerMethod
    extends ServletInvocableHandlerMethod {
        private HandlerMethod handlerMethod;

        public FastJsonInvocableHandlerMethod(HandlerMethod handlerMethod) {
            super(handlerMethod);
            this.handlerMethod = handlerMethod;
        }

        public void invokeAndHandle(ServletWebRequest webRequest, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
            try {
                Object result;
                if (this.handlerMethod instanceof DefinitionHandlerMethod) {
                    LinkedHashMap params = (LinkedHashMap)((HandlerMethodArgumentResolver)JsonResultHandlerAdapter.this.adapter.getArgumentResolvers().get(0)).resolveArgument(this.handlerMethod.getMethodParameters()[0], mavContainer, (NativeWebRequest)webRequest, null);
                    if (params == null) {
                        params = new LinkedHashMap();
                    }
                    result = ((DefinitionHandlerMethod)this.handlerMethod).getService().execute(params);
                } else {
                    result = this.invokeForRequest((NativeWebRequest)webRequest, mavContainer, providedArgs);
                }
                ((HandlerMethodReturnValueHandler)JsonResultHandlerAdapter.this.adapter.getReturnValueHandlers().get(0)).handleReturnValue(result, this.getReturnType(), mavContainer, (NativeWebRequest)webRequest);
            }
            catch (ParameterCastException | ParameterValidateException e) {
                e.printStackTrace();
                throw new ParamsValidateException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

