/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.service;

import com.qsyout.sdk.declare.FileService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class LocaleFileService
implements FileService {
    private String basePath;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public File makeFile(String path, String fileName) {
        return new File(this.notExistFolder(path), fileName);
    }

    @Override
    public File saveFile(String path, String fileName, MultipartFile file) throws IllegalStateException, IOException {
        File dest = this.makeFile(path, fileName);
        this.logger.info("\u4e0a\u4f20\u540e\u6587\u4ef6\u8def\u5f84\uff1a" + dest.getAbsolutePath());
        file.transferTo(dest);
        return dest;
    }

    @Override
    public File getFile(String filePath) throws IOException {
        File file = new File(this.excutePath(filePath));
        if (!file.exists()) {
            throw new IOException("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return file;
    }

    @Override
    public File getFile(String path, String fileName) throws IOException {
        return this.getFile(String.valueOf(path) + "/" + fileName);
    }

    @Override
    public boolean delFile(String path, String fileName) {
        try {
            return this.getFile(path, fileName).delete();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private File notExistFolder(String path) {
        File parent = new File(this.excutePath(path));
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return parent;
    }

    public String excutePath(String path) {
        return String.valueOf(this.basePath) + "/" + path;
    }

    public LocaleFileService(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public File saveFile(String path, String fileName, InputStream is) throws IOException {
        File dest = this.makeFile(path, fileName);
        this.logger.info("\u4e0a\u4f20\u540e\u6587\u4ef6\u8def\u5f84\uff1a" + dest.getAbsolutePath());
        FileOutputStream os = new FileOutputStream(dest);
        byte[] b = new byte[1024];
        int count = 0;
        while ((count = is.read(b)) != -1) {
            ((OutputStream)os).write(b, 0, count);
        }
        os.flush();
        ((OutputStream)os).close();
        is.close();
        return dest;
    }
}

