/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.util;

import com.qsyout.sdk.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    private static final DateTimeFormatter sdf_yMdHms_ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter sdf_yMd = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String getCurrentTime() {
        return sdf_yMdHms_.format(ZonedDateTime.now());
    }

    public static String formatDay(Date day) {
        return sdf_yMd.format(LocalDateTime.ofInstant(day.toInstant(), ZoneId.systemDefault()));
    }

    public static String getCurrentDay() {
        return sdf_yMd.format(ZonedDateTime.now());
    }

    public static Date parse(String date) throws ParseException {
        return Date.from(LocalDate.parse(date, sdf_yMdHms_).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date parseDay(String date) throws ParseException {
        return Date.from(LocalDate.parse(date, sdf_yMd).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String format(Date day) {
        return sdf_yMdHms_.format(LocalDateTime.ofInstant(day.toInstant(), ZoneId.systemDefault()));
    }

    public static Date parse(String date, String format) throws ParseException {
        return new SimpleDateFormat(format).parse(date);
    }

    public static boolean compare(Date bigger, Date smaller) {
        return bigger.after(smaller);
    }

    public static int maxDayOfMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                boolean isRunYear = year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
                return isRunYear ? 29 : 28;
            }
        }
        return 31;
    }

    public static Date parseDate(String dateStr, String format) throws ParseException {
        if (StringUtil.isBlank(dateStr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(dateStr);
    }

    public static Date parseDate(String dateStr, SimpleDateFormat format) throws ParseException {
        if (StringUtil.isBlank(dateStr)) {
            return null;
        }
        return format.parse(dateStr);
    }

    public static Date beforeDate(Date date, int days) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        ((Calendar)c).add(6, -days);
        return c.getTime();
    }

    public static Date getNextDay(int day) {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(6, day);
        return c.getTime();
    }

    public static Date getLastWeek() {
        return DateUtil.getNextDay(-7);
    }

    public static int getWeekNumOfYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(3);
    }

    public static int getWeekNumOfYearDay(String strDate) throws ParseException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtil.parseDay(strDate));
        int iWeekNum = calendar.get(3);
        return iWeekNum;
    }

    public static String getWeekFirstDay(int yearNum, int weekNum) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, yearNum);
        cal.set(3, weekNum);
        cal.set(7, 2);
        String tempYear = Integer.toString(yearNum);
        String tempMonth = Integer.toString(cal.get(2) + 1);
        String tempDay = Integer.toString(cal.get(5));
        return String.valueOf(tempYear) + "-" + tempMonth + "-" + tempDay;
    }

    public static String getWeekEndDay(int yearNum, int weekNum) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, yearNum);
        cal.set(3, weekNum + 1);
        cal.set(7, 1);
        String tempMonth = Integer.toString(cal.get(2) + 1);
        String tempDay = Integer.toString(cal.get(5));
        return String.valueOf(cal.get(1)) + "-" + tempMonth + "-" + tempDay;
    }

    public static String getNextWeekDay(String dateStr, int weekday) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.parseDay(dateStr));
        int weekNum = cal.get(3);
        cal.set(3, weekNum + 1);
        cal.set(7, weekday + 1);
        return DateUtil.formatDay(cal.getTime());
    }

    public static String getCurrWeekDay(String dateStr, int weekday) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.parseDay(dateStr));
        cal.set(7, weekday + 1);
        return DateUtil.formatDay(cal.getTime());
    }

    public static String getCurrMonthDay(String dateStr, int day) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.parseDay(dateStr));
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        int endDay = DateUtil.maxDayOfMonth(year, month);
        int valDay = day;
        if (day > endDay) {
            valDay = endDay;
        }
        cal.set(5, valDay);
        return DateUtil.formatDay(cal.getTime());
    }

    public static String getNextMonthDay(String dateStr, int day) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.parseDay(dateStr));
        int month = cal.get(2) + 2;
        cal.set(2, month - 1);
        int year = cal.get(1);
        int endDay = DateUtil.maxDayOfMonth(year, month);
        int valDay = day;
        if (day > endDay) {
            valDay = endDay;
        }
        cal.set(5, valDay);
        return DateUtil.formatDay(cal.getTime());
    }

    public static String beforeMonthDate(String dateStr, int number) throws ParseException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.parseDay(dateStr));
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int endDay = DateUtil.maxDayOfMonth(year, month);
        day = Math.min(endDay, day);
        cal.set(2, month - number);
        cal.set(5, day);
        return DateUtil.formatDay(cal.getTime());
    }

    public static long getTwoDay(String bigger, String lesser) throws ParseException {
        return (DateUtil.parseDay(bigger).getTime() - DateUtil.parseDay(lesser).getTime()) / 86400000L;
    }
}

