/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.widgets;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.qozix.tileview.geom.FloatMathHelper;
import com.qozix.tileview.view.TouchUpGestureDetector;
import java.lang.ref.WeakReference;
import java.util.HashSet;

public class ZoomPanLayout
extends ViewGroup
implements GestureDetector.OnDoubleTapListener,
GestureDetector.OnGestureListener,
ScaleGestureDetector.OnScaleGestureListener,
TouchUpGestureDetector.OnTouchUpListener {
    private static final int DEFAULT_ZOOM_PAN_ANIMATION_DURATION = 400;
    private int mBaseWidth;
    private int mBaseHeight;
    private int mScaledWidth;
    private int mScaledHeight;
    private float mScale = 1.0f;
    private float mMinScale = 0.0f;
    private float mMaxScale = 1.0f;
    private float mEffectiveMinScale = 0.0f;
    private boolean mShouldLoopScale = true;
    private boolean mIsFlinging;
    private boolean mIsDragging;
    private boolean mIsScaling;
    private boolean mIsSliding;
    private int mAnimationDuration = 400;
    private HashSet mZoomPanListeners = new HashSet();
    private Scroller mScroller;
    private ZoomPanAnimator mZoomPanAnimator;
    private ScaleGestureDetector mScaleGestureDetector;
    private GestureDetector mGestureDetector;
    private TouchUpGestureDetector mTouchUpGestureDetector;
    private MinimumScaleMode mMinimumScaleMode = MinimumScaleMode.FILL;

    public ZoomPanLayout(Context context) {
        this(context, null);
    }

    public ZoomPanLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZoomPanLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setWillNotDraw(false);
        this.mScroller = new Scroller(context);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mTouchUpGestureDetector = new TouchUpGestureDetector(this);
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.mScaledWidth, (int)0x40000000);
        int n5 = View.MeasureSpec.makeMeasureSpec((int)this.mScaledHeight, (int)0x40000000);
        for (n3 = 0; n3 < this.getChildCount(); ++n3) {
            View view = this.getChildAt(n3);
            view.measure(n4, n5);
        }
        n3 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        n3 = ZoomPanLayout.resolveSize((int)n3, (int)n);
        n6 = ZoomPanLayout.resolveSize((int)n6, (int)n2);
        this.setMeasuredDimension(n3, n6);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        int n7 = 0;
        int n8 = 0;
        if (this.mScaledWidth < n5) {
            n7 = n5 / 2 - this.mScaledWidth / 2;
        }
        if (this.mScaledHeight < n6) {
            n8 = n6 / 2 - this.mScaledHeight / 2;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            view.layout(n7, n8, this.mScaledWidth + n7, this.mScaledHeight + n8);
        }
        this.calculateMinimumScaleToFit();
        this.constrainScrollToLimits();
    }

    public void setShouldScaleToFit(boolean bl) {
        this.setMinimumScaleMode(bl ? MinimumScaleMode.FILL : MinimumScaleMode.NONE);
    }

    public void setMinimumScaleMode(MinimumScaleMode minimumScaleMode) {
        this.mMinimumScaleMode = minimumScaleMode;
        this.calculateMinimumScaleToFit();
    }

    public void setShouldLoopScale(boolean bl) {
        this.mShouldLoopScale = bl;
    }

    public void setScaleLimits(float f, float f2) {
        this.mMinScale = f;
        this.mMaxScale = f2;
        this.setScale(this.mScale);
    }

    public void setSize(int n, int n2) {
        this.mBaseWidth = n;
        this.mBaseHeight = n2;
        this.updateScaledDimensions();
        this.requestLayout();
    }

    public int getBaseWidth() {
        return this.mBaseWidth;
    }

    public int getBaseHeight() {
        return this.mBaseHeight;
    }

    public int getScaledWidth() {
        return this.mScaledWidth;
    }

    public int getScaledHeight() {
        return this.mScaledHeight;
    }

    public void setScale(float f) {
        if (this.mScale != (f = this.getConstrainedDestinationScale(f))) {
            float f2 = this.mScale;
            this.mScale = f;
            this.updateScaledDimensions();
            this.constrainScrollToLimits();
            this.onScaleChanged(f, f2);
            this.invalidate();
        }
    }

    public float getScale() {
        return this.mScale;
    }

    public boolean isFlinging() {
        return this.mIsFlinging;
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean isSliding() {
        return this.mIsSliding;
    }

    public boolean isScaling() {
        return this.mIsScaling;
    }

    public Scroller getScroller() {
        return this.mScroller;
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int n) {
        this.mAnimationDuration = n;
        if (this.mZoomPanAnimator != null) {
            this.mZoomPanAnimator.setDuration(this.mAnimationDuration);
        }
    }

    public boolean addZoomPanListener(ZoomPanListener zoomPanListener) {
        return this.mZoomPanListeners.add(zoomPanListener);
    }

    public boolean removeZoomPanListener(ZoomPanListener zoomPanListener) {
        return this.mZoomPanListeners.remove(zoomPanListener);
    }

    public void scrollToAndCenter(int n, int n2) {
        this.scrollTo(n - this.getHalfWidth(), n2 - this.getHalfHeight());
    }

    public void setScaleFromCenter(float f) {
        this.setScaleFromPosition(this.getHalfWidth(), this.getHalfHeight(), f);
    }

    public void slideTo(int n, int n2) {
        this.getAnimator().animatePan(n, n2);
    }

    public void slideToAndCenter(int n, int n2) {
        this.slideTo(n - this.getHalfWidth(), n2 - this.getHalfHeight());
    }

    public void slideToAndCenterWithScale(int n, int n2, float f) {
        this.getAnimator().animateZoomPan(n - this.getHalfWidth(), n2 - this.getHalfHeight(), f);
    }

    public void smoothScaleTo(float f) {
        this.getAnimator().animateZoom(f);
    }

    public void smoothScaleFromFocalPoint(int n, int n2, float f) {
        if ((f = this.getConstrainedDestinationScale(f)) == this.mScale) {
            return;
        }
        int n3 = this.getOffsetScrollXFromScale(n, f, this.mScale);
        int n4 = this.getOffsetScrollYFromScale(n2, f, this.mScale);
        this.getAnimator().animateZoomPan(n3, n4, f);
    }

    public void smoothScaleFromCenter(float f) {
        this.smoothScaleFromFocalPoint(this.getHalfWidth(), this.getHalfHeight(), f);
    }

    public void onScaleChanged(float f, float f2) {
    }

    private float getConstrainedDestinationScale(float f) {
        f = Math.max(f, this.mEffectiveMinScale);
        f = Math.min(f, this.mMaxScale);
        return f;
    }

    private void constrainScrollToLimits() {
        int n = this.getScrollX();
        int n2 = this.getScrollY();
        int n3 = this.getConstrainedScrollX(n);
        int n4 = this.getConstrainedScrollY(n2);
        if (n != n3 || n2 != n4) {
            this.scrollTo(n3, n4);
        }
    }

    private void updateScaledDimensions() {
        this.mScaledWidth = FloatMathHelper.scale(this.mBaseWidth, this.mScale);
        this.mScaledHeight = FloatMathHelper.scale(this.mBaseHeight, this.mScale);
    }

    protected ZoomPanAnimator getAnimator() {
        if (this.mZoomPanAnimator == null) {
            this.mZoomPanAnimator = new ZoomPanAnimator(this);
            this.mZoomPanAnimator.setDuration(this.mAnimationDuration);
        }
        return this.mZoomPanAnimator;
    }

    private int getOffsetScrollXFromScale(int n, float f, float f2) {
        int n2 = this.getScrollX() + n;
        float f3 = f / f2;
        return (int)((float)n2 * f3) - n;
    }

    private int getOffsetScrollYFromScale(int n, float f, float f2) {
        int n2 = this.getScrollY() + n;
        float f3 = f / f2;
        return (int)((float)n2 * f3) - n;
    }

    public void setScaleFromPosition(int n, int n2, float f) {
        if ((f = this.getConstrainedDestinationScale(f)) == this.mScale) {
            return;
        }
        int n3 = this.getOffsetScrollXFromScale(n, f, this.mScale);
        int n4 = this.getOffsetScrollYFromScale(n2, f, this.mScale);
        this.setScale(f);
        n3 = this.getConstrainedScrollX(n3);
        n4 = this.getConstrainedScrollY(n4);
        this.scrollTo(n3, n4);
    }

    public boolean canScrollHorizontally(int n) {
        int n2 = this.getScrollX();
        return n > 0 ? n2 < this.getScrollLimitX() : n < 0 && n2 > 0;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = this.mGestureDetector.onTouchEvent(motionEvent);
        boolean bl2 = this.mScaleGestureDetector.onTouchEvent(motionEvent);
        boolean bl3 = this.mTouchUpGestureDetector.onTouchEvent(motionEvent);
        return bl || bl2 || bl3 || super.onTouchEvent(motionEvent);
    }

    public void scrollTo(int n, int n2) {
        n = this.getConstrainedScrollX(n);
        n2 = this.getConstrainedScrollY(n2);
        super.scrollTo(n, n2);
    }

    private void calculateMinimumScaleToFit() {
        float f;
        float f2 = (float)this.getWidth() / (float)this.mBaseWidth;
        float f3 = this.calculatedMinScale(f2, f = (float)this.getHeight() / (float)this.mBaseHeight);
        if (f3 != this.mEffectiveMinScale) {
            this.mEffectiveMinScale = f3;
            if (this.mScale < this.mEffectiveMinScale) {
                this.setScale(this.mEffectiveMinScale);
            }
        }
    }

    private float calculatedMinScale(float f, float f2) {
        switch (this.mMinimumScaleMode) {
            case FILL: {
                return Math.max(f, f2);
            }
            case FIT: {
                return Math.min(f, f2);
            }
        }
        return this.mMinScale;
    }

    protected int getHalfWidth() {
        return FloatMathHelper.scale(this.getWidth(), 0.5f);
    }

    protected int getHalfHeight() {
        return FloatMathHelper.scale(this.getHeight(), 0.5f);
    }

    private int getConstrainedScrollX(int n) {
        return Math.max(0, Math.min(n, this.getScrollLimitX()));
    }

    private int getConstrainedScrollY(int n) {
        return Math.max(0, Math.min(n, this.getScrollLimitY()));
    }

    private int getScrollLimitX() {
        return this.mScaledWidth - this.getWidth();
    }

    private int getScrollLimitY() {
        return this.mScaledHeight - this.getHeight();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int n = this.getScrollX();
            int n2 = this.getScrollY();
            int n3 = this.getConstrainedScrollX(this.mScroller.getCurrX());
            int n4 = this.getConstrainedScrollY(this.mScroller.getCurrY());
            if (n != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
                if (this.mIsFlinging) {
                    this.broadcastFlingUpdate();
                }
            }
            if (this.mScroller.isFinished()) {
                if (this.mIsFlinging) {
                    this.mIsFlinging = false;
                    this.broadcastFlingEnd();
                }
            } else {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }
    }

    private void broadcastDragBegin() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanBegin(this.getScrollX(), this.getScrollY(), ZoomPanListener.Origination.DRAG);
        }
    }

    private void broadcastDragUpdate() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanUpdate(this.getScrollX(), this.getScrollY(), ZoomPanListener.Origination.DRAG);
        }
    }

    private void broadcastDragEnd() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanEnd(this.getScrollX(), this.getScrollY(), ZoomPanListener.Origination.DRAG);
        }
    }

    private void broadcastFlingBegin() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanBegin(this.mScroller.getStartX(), this.mScroller.getStartY(), ZoomPanListener.Origination.FLING);
        }
    }

    private void broadcastFlingUpdate() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanUpdate(this.mScroller.getCurrX(), this.mScroller.getCurrY(), ZoomPanListener.Origination.FLING);
        }
    }

    private void broadcastFlingEnd() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanEnd(this.mScroller.getFinalX(), this.mScroller.getFinalY(), ZoomPanListener.Origination.FLING);
        }
    }

    private void broadcastProgrammaticPanBegin() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanBegin(this.getScrollX(), this.getScrollY(), null);
        }
    }

    private void broadcastProgrammaticPanUpdate() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanUpdate(this.getScrollX(), this.getScrollY(), null);
        }
    }

    private void broadcastProgrammaticPanEnd() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onPanEnd(this.getScrollX(), this.getScrollY(), null);
        }
    }

    private void broadcastPinchBegin() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomBegin(this.mScale, ZoomPanListener.Origination.PINCH);
        }
    }

    private void broadcastPinchUpdate() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomUpdate(this.mScale, ZoomPanListener.Origination.PINCH);
        }
    }

    private void broadcastPinchEnd() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomEnd(this.mScale, ZoomPanListener.Origination.PINCH);
        }
    }

    private void broadcastProgrammaticZoomBegin() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomBegin(this.mScale, null);
        }
    }

    private void broadcastProgrammaticZoomUpdate() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomUpdate(this.mScale, null);
        }
    }

    private void broadcastProgrammaticZoomEnd() {
        for (ZoomPanListener zoomPanListener : this.mZoomPanListeners) {
            zoomPanListener.onZoomEnd(this.mScale, null);
        }
    }

    public boolean onDown(MotionEvent motionEvent) {
        if (this.mIsFlinging && !this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
            this.mIsFlinging = false;
            this.broadcastFlingEnd();
        }
        return true;
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        this.mScroller.fling(this.getScrollX(), this.getScrollY(), (int)(-f), (int)(-f2), 0, this.getScrollLimitX(), 0, this.getScrollLimitY());
        this.mIsFlinging = true;
        ViewCompat.postInvalidateOnAnimation((View)this);
        this.broadcastFlingBegin();
        return true;
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        int n = this.getScrollX() + (int)f;
        int n2 = this.getScrollY() + (int)f2;
        this.scrollTo(n, n2);
        if (!this.mIsDragging) {
            this.mIsDragging = true;
            this.broadcastDragBegin();
        } else {
            this.broadcastDragUpdate();
        }
        return true;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        return true;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        float f = (float)Math.pow(2.0, Math.floor(Math.log(this.mScale * 2.0f) / Math.log(2.0)));
        float f2 = this.mShouldLoopScale && this.mScale >= this.mMaxScale ? this.mMinScale : f;
        f = this.getConstrainedDestinationScale(f2);
        this.smoothScaleFromFocalPoint((int)motionEvent.getX(), (int)motionEvent.getY(), f);
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent motionEvent) {
        return true;
    }

    @Override
    public boolean onTouchUp(MotionEvent motionEvent) {
        if (this.mIsDragging) {
            this.mIsDragging = false;
            if (!this.mIsFlinging) {
                this.broadcastDragEnd();
            }
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        this.mIsScaling = true;
        this.broadcastPinchBegin();
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        this.mIsScaling = false;
        this.broadcastPinchEnd();
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        float f = this.mScale * this.mScaleGestureDetector.getScaleFactor();
        this.setScaleFromPosition((int)scaleGestureDetector.getFocusX(), (int)scaleGestureDetector.getFocusY(), f);
        this.broadcastPinchUpdate();
        return true;
    }

    public static enum MinimumScaleMode {
        FILL,
        FIT,
        NONE;

    }

    public static interface ZoomPanListener {
        public void onPanBegin(int var1, int var2, Origination var3);

        public void onPanUpdate(int var1, int var2, Origination var3);

        public void onPanEnd(int var1, int var2, Origination var3);

        public void onZoomBegin(float var1, Origination var2);

        public void onZoomUpdate(float var1, Origination var2);

        public void onZoomEnd(float var1, Origination var2);

        public static enum Origination {
            DRAG,
            FLING,
            PINCH;

        }
    }

    private static class ZoomPanAnimator
    extends ValueAnimator
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private WeakReference mZoomPanLayoutWeakReference;
        private ZoomPanState mStartState = new ZoomPanState();
        private ZoomPanState mEndState = new ZoomPanState();
        private boolean mHasPendingZoomUpdates;
        private boolean mHasPendingPanUpdates;

        public ZoomPanAnimator(ZoomPanLayout zoomPanLayout) {
            this.addUpdateListener(this);
            this.addListener(this);
            this.setFloatValues(new float[]{0.0f, 1.0f});
            this.setInterpolator((TimeInterpolator)new FastEaseInInterpolator());
            this.mZoomPanLayoutWeakReference = new WeakReference<ZoomPanLayout>(zoomPanLayout);
        }

        private boolean setupPanAnimation(int n, int n2) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                this.mStartState.x = zoomPanLayout.getScrollX();
                this.mStartState.y = zoomPanLayout.getScrollY();
                this.mEndState.x = n;
                this.mEndState.y = n2;
                return this.mStartState.x != this.mEndState.x || this.mStartState.y != this.mEndState.y;
            }
            return false;
        }

        private boolean setupZoomAnimation(float f) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                this.mStartState.scale = zoomPanLayout.getScale();
                this.mEndState.scale = f;
                return this.mStartState.scale != this.mEndState.scale;
            }
            return false;
        }

        public void animateZoomPan(int n, int n2, float f) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                this.mHasPendingZoomUpdates = this.setupZoomAnimation(f);
                this.mHasPendingPanUpdates = this.setupPanAnimation(n, n2);
                if (this.mHasPendingPanUpdates || this.mHasPendingZoomUpdates) {
                    this.start();
                }
            }
        }

        public void animateZoom(float f) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                this.mHasPendingZoomUpdates = this.setupZoomAnimation(f);
                if (this.mHasPendingZoomUpdates) {
                    this.start();
                }
            }
        }

        public void animatePan(int n, int n2) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                this.mHasPendingPanUpdates = this.setupPanAnimation(n, n2);
                if (this.mHasPendingPanUpdates) {
                    this.start();
                }
            }
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (this.mHasPendingZoomUpdates) {
                    float f2 = this.mStartState.scale + (this.mEndState.scale - this.mStartState.scale) * f;
                    zoomPanLayout.setScale(f2);
                    zoomPanLayout.broadcastProgrammaticZoomUpdate();
                }
                if (this.mHasPendingPanUpdates) {
                    int n = (int)((float)this.mStartState.x + (float)(this.mEndState.x - this.mStartState.x) * f);
                    int n2 = (int)((float)this.mStartState.y + (float)(this.mEndState.y - this.mStartState.y) * f);
                    zoomPanLayout.scrollTo(n, n2);
                    zoomPanLayout.broadcastProgrammaticPanUpdate();
                }
            }
        }

        public void onAnimationStart(Animator animator) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                if (this.mHasPendingZoomUpdates) {
                    zoomPanLayout.mIsScaling = true;
                    zoomPanLayout.broadcastProgrammaticZoomBegin();
                }
                if (this.mHasPendingPanUpdates) {
                    zoomPanLayout.mIsSliding = true;
                    zoomPanLayout.broadcastProgrammaticPanBegin();
                }
            }
        }

        public void onAnimationEnd(Animator animator) {
            ZoomPanLayout zoomPanLayout = (ZoomPanLayout)this.mZoomPanLayoutWeakReference.get();
            if (zoomPanLayout != null) {
                if (this.mHasPendingZoomUpdates) {
                    this.mHasPendingZoomUpdates = false;
                    zoomPanLayout.mIsScaling = false;
                    zoomPanLayout.broadcastProgrammaticZoomEnd();
                }
                if (this.mHasPendingPanUpdates) {
                    this.mHasPendingPanUpdates = false;
                    zoomPanLayout.mIsSliding = false;
                    zoomPanLayout.broadcastProgrammaticPanEnd();
                }
            }
        }

        public void onAnimationCancel(Animator animator) {
            this.onAnimationEnd(animator);
        }

        public void onAnimationRepeat(Animator animator) {
        }

        private static class FastEaseInInterpolator
        implements Interpolator {
            private FastEaseInInterpolator() {
            }

            public float getInterpolation(float f) {
                return (float)(1.0 - Math.pow(1.0f - f, 8.0));
            }
        }

        private static class ZoomPanState {
            public int x;
            public int y;
            public float scale;

            private ZoomPanState() {
            }
        }
    }
}

