/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import com.qozix.tileview.geom.FloatMathHelper;

public class ScalingLayout
extends ViewGroup {
    private float mScale = 1.0f;

    public ScalingLayout(Context context) {
        super(context);
        this.setWillNotDraw(false);
    }

    public void setScale(float f) {
        this.mScale = f;
        this.invalidate();
    }

    public float getScale() {
        return this.mScale;
    }

    protected void onMeasure(int n, int n2) {
        int n3 = FloatMathHelper.unscale(View.MeasureSpec.getSize((int)n), this.mScale);
        int n4 = FloatMathHelper.unscale(View.MeasureSpec.getSize((int)n2), this.mScale);
        int n5 = View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000);
        int n6 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.measure(n5, n6);
        }
        this.setMeasuredDimension(n3, n4);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = FloatMathHelper.unscale(n3 - n, this.mScale);
        int n6 = FloatMathHelper.unscale(n4 - n2, this.mScale);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            view.layout(0, 0, n5, n6);
        }
    }

    public void onDraw(Canvas canvas) {
        canvas.scale(this.mScale, this.mScale);
        super.onDraw(canvas);
    }
}

