/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.content.Context;
import com.qozix.tileview.graphics.BitmapProvider;
import com.qozix.tileview.tiles.Tile;
import com.qozix.tileview.tiles.TileCanvasViewGroup;
import com.qozix.tileview.tiles.TileRenderHandler;
import com.qozix.tileview.tiles.TileRenderRunnable;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TileRenderPoolExecutor
extends ThreadPoolExecutor {
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final int INITIAL_POOL_SIZE = AVAILABLE_PROCESSORS >> 1;
    private static final int MAXIMUM_POOL_SIZE = AVAILABLE_PROCESSORS;
    private WeakReference mTileCanvasViewGroupWeakReference;
    private TileRenderHandler mHandler = new TileRenderHandler();

    public TileRenderPoolExecutor() {
        super(INITIAL_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingDeque<Runnable>());
    }

    public void queue(TileCanvasViewGroup tileCanvasViewGroup, Set set) {
        TileRenderRunnable tileRenderRunnable;
        this.mTileCanvasViewGroupWeakReference = new WeakReference<TileCanvasViewGroup>(tileCanvasViewGroup);
        this.mHandler.setTileCanvasViewGroup(tileCanvasViewGroup);
        Context context = tileCanvasViewGroup.getContext();
        BitmapProvider bitmapProvider = tileCanvasViewGroup.getBitmapProvider();
        tileCanvasViewGroup.onRenderTaskPreExecute();
        for (Runnable object : this.getQueue()) {
            Tile tile;
            if (!(object instanceof TileRenderRunnable) || (tileRenderRunnable = (TileRenderRunnable)object).isDone() || tileRenderRunnable.isCancelled() || (tile = tileRenderRunnable.getTile()) == null) continue;
            if (set.contains(tile)) {
                set.remove(tile);
                continue;
            }
            tileRenderRunnable.cancel(true);
            this.remove(tileRenderRunnable);
        }
        for (Tile tile : set) {
            if (this.isShutdownOrTerminating()) {
                return;
            }
            tileRenderRunnable = new TileRenderRunnable();
            tileRenderRunnable.setTile(tile);
            tileRenderRunnable.setContext(context);
            tileRenderRunnable.setBitmapProvider(bitmapProvider);
            tileRenderRunnable.setHandler(this.mHandler);
            this.execute(tileRenderRunnable);
        }
    }

    private void broadcastCancel() {
        TileCanvasViewGroup tileCanvasViewGroup;
        if (this.mTileCanvasViewGroupWeakReference != null && (tileCanvasViewGroup = (TileCanvasViewGroup)this.mTileCanvasViewGroupWeakReference.get()) != null) {
            tileCanvasViewGroup.onRenderTaskCancelled();
        }
    }

    public void cancel() {
        for (Runnable runnable : this.getQueue()) {
            if (!(runnable instanceof TileRenderRunnable)) continue;
            TileRenderRunnable tileRenderRunnable = (TileRenderRunnable)runnable;
            tileRenderRunnable.cancel(true);
        }
        this.getQueue().clear();
        this.broadcastCancel();
    }

    public boolean isShutdownOrTerminating() {
        return this.isShutdown() || this.isTerminating() || this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        TileRenderPoolExecutor tileRenderPoolExecutor = this;
        synchronized (tileRenderPoolExecutor) {
            TileCanvasViewGroup tileCanvasViewGroup;
            super.afterExecute(runnable, throwable);
            if (this.getQueue().size() == 0 && this.getActiveCount() == 1 && (tileCanvasViewGroup = (TileCanvasViewGroup)this.mTileCanvasViewGroupWeakReference.get()) != null) {
                tileCanvasViewGroup.onRenderTaskPostExecute();
            }
        }
    }
}

